/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx;

import java.rmi.RemoteException;
import javax.ejb.ApplicationException;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.transaction.Transaction;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.tx.TxPolicy;
import org.jboss.ejb3.tx.TxUtil;

public class Ejb3TxPolicy
extends TxPolicy {
    public void throwMandatory(Invocation invocation) {
        throw new EJBTransactionRequiredException(((MethodInvocation)invocation).getActualMethod().toString());
    }

    public void handleExceptionInOurTx(Invocation invocation, Throwable t, Transaction tx) throws Throwable {
        ApplicationException ae = TxUtil.getApplicationException(t.getClass(), invocation);
        if (ae != null) {
            if (ae.rollback()) {
                this.setRollbackOnly(tx);
            }
            throw t;
        }
        if (!(t instanceof RuntimeException) && !(t instanceof RemoteException)) {
            throw t;
        }
        this.setRollbackOnly(tx);
        if (t instanceof RuntimeException && !(t instanceof EJBException)) {
            throw new EJBException((Exception)t);
        }
        throw t;
    }

    public void handleInCallerTx(Invocation invocation, Throwable t, Transaction tx) throws Throwable {
        ApplicationException ae = TxUtil.getApplicationException(t.getClass(), invocation);
        if (ae != null) {
            if (ae.rollback()) {
                this.setRollbackOnly(tx);
            }
            throw t;
        }
        if (!(t instanceof RuntimeException) && !(t instanceof RemoteException)) {
            throw t;
        }
        this.setRollbackOnly(tx);
        if (t instanceof EJBTransactionRolledbackException) {
            log.error((Object)t);
            throw t;
        }
        EJBTransactionRolledbackException ejbtre = new EJBTransactionRolledbackException(t.getMessage(), (Exception)t);
        log.error((Object)ejbtre);
        throw ejbtre;
    }
}

