/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.dgc.VMID;
import java.util.Arrays;
import java.util.HashSet;
import javax.ejb.LocalHome;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.annotation.LocalBinding;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.stateful.BaseStatefulProxyFactory;
import org.jboss.ejb3.stateful.StatefulHandleImpl;
import org.jboss.ejb3.stateful.StatefulLocalHomeProxy;
import org.jboss.ejb3.stateful.StatefulLocalProxy;
import org.jboss.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulLocalProxyFactory
extends BaseStatefulProxyFactory {
    private VMID vmid = Ejb3Registry.getVMID();

    public StatefulLocalProxyFactory() {
    }

    public StatefulLocalProxyFactory(SessionContainer container, LocalBinding binding) {
        super(container, binding.jndiBinding());
    }

    @Override
    protected Class<?>[] getInterfaces() {
        SessionContainer statefulContainer = (SessionContainer)this.getContainer();
        LocalHome localHome = (LocalHome)statefulContainer.resolveAnnotation(LocalHome.class);
        boolean bindTogether = false;
        if (localHome != null && this.bindHomeAndBusinessTogether(statefulContainer)) {
            bindTogether = true;
        }
        HashSet<Class> localInterfaces = new HashSet<Class>();
        localInterfaces.addAll(Arrays.asList(ProxyFactoryHelper.getLocalAndBusinessLocalInterfaces(this.getContainer())));
        this.ensureEjb21ViewComplete(localHome == null ? null : localHome.value(), ProxyFactoryHelper.getLocalInterfaces(this.getContainer()));
        localInterfaces.add(JBossProxy.class);
        if (bindTogether) {
            localInterfaces.add(localHome.value());
        }
        return localInterfaces.toArray(new Class[0]);
    }

    protected boolean bindHomeAndBusinessTogether(SessionContainer container) {
        return ProxyFactoryHelper.getLocalHomeJndiName(container).equals(this.jndiName);
    }

    @Override
    public void start() throws Exception {
        super.start();
        try {
            Util.rebind((Context)this.getContainer().getInitialContext(), (String)(this.jndiName + "StatefulProxyFactory"), (Object)this);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind stateful local proxy with ejb name " + this.getContainer().getEjbName() + " into JNDI under jndiName: " + this.getContainer().getInitialContext().getNameInNamespace() + "/" + this.jndiName + "StatefulProxyFactory");
            namingException.setRootCause(e);
            throw namingException;
        }
        SessionContainer statefulContainer = (SessionContainer)this.getContainer();
        LocalHome localHome = (LocalHome)((EJBContainer)this.getContainer()).resolveAnnotation(LocalHome.class);
        if (localHome != null && !this.bindHomeAndBusinessTogether(statefulContainer)) {
            Class[] interfaces = new Class[]{localHome.value()};
            Object homeProxy = Proxy.newProxyInstance(this.getContainer().getBeanClass().getClassLoader(), interfaces, (InvocationHandler)new StatefulLocalHomeProxy(this.getContainer()));
            Util.rebind((Context)this.getContainer().getInitialContext(), (String)ProxyFactoryHelper.getLocalHomeJndiName(this.getContainer()), (Object)homeProxy);
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        Util.unbind((Context)this.getContainer().getInitialContext(), (String)(this.jndiName + "StatefulProxyFactory"));
        SessionContainer statefulContainer = (SessionContainer)this.getContainer();
        LocalHome localHome = (LocalHome)((EJBContainer)this.getContainer()).resolveAnnotation(LocalHome.class);
        if (localHome != null && !this.bindHomeAndBusinessTogether(statefulContainer)) {
            Util.unbind((Context)this.getContainer().getInitialContext(), (String)ProxyFactoryHelper.getLocalHomeJndiName(this.getContainer()));
        }
    }

    @Override
    public Object createProxy() {
        SessionContainer sfsb = (SessionContainer)this.getContainer();
        Object id = sfsb.createSession();
        return this.constructProxy(new StatefulLocalProxy(this.getContainer(), id, this.vmid));
    }

    @Override
    public Object createProxy(Object id) {
        return this.constructProxy(new StatefulLocalProxy(this.getContainer(), id, this.vmid));
    }

    public Object createProxy(Class[] initTypes, Object[] initValues) {
        SessionContainer sfsb = (SessionContainer)this.getContainer();
        Object id = sfsb.createSession(initTypes, initValues);
        return this.constructProxy(new StatefulLocalProxy(this.getContainer(), id, this.vmid));
    }

    @Override
    protected StatefulHandleImpl getHandle() {
        StatefulHandleImpl handle = new StatefulHandleImpl();
        LocalBinding remoteBinding = (LocalBinding)((Advisor)this.getContainer()).resolveAnnotation(LocalBinding.class);
        if (remoteBinding != null) {
            handle.jndiName = remoteBinding.jndiBinding();
        }
        return handle;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.vmid = (VMID)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.vmid);
    }
}

