/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.aspects.remoting.Remoting;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.annotation.Clustered;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.remoting.RemoteProxyFactory;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.stateful.BaseStatefulProxyFactory;
import org.jboss.ejb3.stateful.StatefulClusteredProxy;
import org.jboss.ejb3.stateful.StatefulHandleImpl;
import org.jboss.ha.client.loadbalance.FirstAvailable;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.jboss.remoting.InvokerLocator;

public class StatefulClusterProxyFactory
extends BaseStatefulProxyFactory
implements RemoteProxyFactory,
DistributedReplicantManager.ReplicantListener {
    private static final Logger log = Logger.getLogger(StatefulClusterProxyFactory.class);
    private RemoteBinding binding;
    private Clustered clustered;
    private InvokerLocator locator;
    private DistributedReplicantManager drm;
    private HATarget hatarget;
    private String proxyFamilyName;
    private LoadBalancePolicy lbPolicy;
    private FamilyWrapper wrapper;

    public StatefulClusterProxyFactory(SessionContainer container, RemoteBinding binding, Clustered clustered) {
        super(container, binding.jndiBinding());
        assert (clustered != null) : "clustered is null";
        this.binding = binding;
        this.clustered = clustered;
    }

    protected Class[] getInterfaces() {
        Class<?>[] remoteInterfaces = ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(this.getContainer());
        Class[] interfaces = new Class[remoteInterfaces.length + 1];
        System.arraycopy(remoteInterfaces, 0, interfaces, 0, remoteInterfaces.length);
        interfaces[remoteInterfaces.length] = JBossProxy.class;
        return interfaces;
    }

    public void start() throws Exception {
        String clientBindUrl = ProxyFactoryHelper.getClientBindUrl(this.binding);
        this.locator = new InvokerLocator(clientBindUrl);
        String partitionName = ((SessionContainer)this.getContainer()).getPartitionName();
        this.proxyFamilyName = ((SessionContainer)this.getContainer()).getDeploymentQualifiedName() + this.locator.getProtocol() + partitionName;
        HAPartition partition = (HAPartition)this.getContainer().getInitialContext().lookup("/HAPartition/" + partitionName);
        this.hatarget = new HATarget(partition, this.proxyFamilyName, (Serializable)this.locator, 2);
        ClusteringTargetsRepository.initTarget((String)this.proxyFamilyName, (List)this.hatarget.getReplicants());
        ((SessionContainer)this.getContainer()).getClusterFamilies().put(this.proxyFamilyName, this.hatarget);
        this.lbPolicy = this.clustered.loadBalancePolicy() == null || this.clustered.loadBalancePolicy().equals(LoadBalancePolicy.class) ? new FirstAvailable() : (LoadBalancePolicy)this.clustered.loadBalancePolicy().newInstance();
        this.wrapper = new FamilyWrapper(this.proxyFamilyName, (List)this.hatarget.getReplicants());
        this.drm = partition.getDistributedReplicantManager();
        this.drm.registerListener(this.proxyFamilyName, (DistributedReplicantManager.ReplicantListener)this);
        super.start();
        Class[] interfaces = new Class[]{ProxyFactory.class};
        String targetId = this.getTargetId();
        Object factoryProxy = Remoting.createPojiProxy((Object)targetId, (Class[])interfaces, (String)ProxyFactoryHelper.getClientBindUrl(this.binding));
        try {
            Util.rebind((Context)this.getContainer().getInitialContext(), (String)(this.jndiName + "StatefulProxyFactory"), (Object)factoryProxy);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind stateful cluster proxy with ejb name " + this.getContainer().getEjbName() + " into JNDI under jndiName: " + this.getContainer().getInitialContext().getNameInNamespace() + "/" + this.jndiName + "StatefulProxyFactory");
            namingException.setRootCause(e);
            throw namingException;
        }
        assert (!Dispatcher.singleton.isRegistered((Object)targetId)) : targetId + " is already registered";
        Dispatcher.singleton.registerTarget((Object)targetId, (Object)this);
    }

    public Object createProxy() {
        String stackName = "ClusteredStatefulSessionClientInterceptors";
        if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
            stackName = this.binding.interceptorStack();
        }
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        String partitionName = ((SessionContainer)this.getContainer()).getPartitionName();
        return this.constructProxy(new StatefulClusteredProxy(this.getContainer(), stack.createInterceptors((Advisor)this.getContainer(), null), this.wrapper, this.lbPolicy, partitionName));
    }

    public Object createProxy(Object id) {
        throw new RuntimeException("NYI");
    }

    public void stop() throws Exception {
        Dispatcher.singleton.unregisterTarget((Object)this.getTargetId());
        this.hatarget.destroy();
        this.drm.unregisterListener(this.proxyFamilyName, (DistributedReplicantManager.ReplicantListener)this);
        ((SessionContainer)this.getContainer()).getClusterFamilies().remove(this.proxyFamilyName);
        Util.unbind((Context)this.getContainer().getInitialContext(), (String)(this.jndiName + "StatefulProxyFactory"));
        super.stop();
    }

    protected StatefulHandleImpl getHandle() {
        StatefulHandleImpl handle = new StatefulHandleImpl();
        RemoteBinding remoteBinding = (RemoteBinding)((Advisor)this.getContainer()).resolveAnnotation(RemoteBinding.class);
        if (remoteBinding != null) {
            handle.jndiName = remoteBinding.jndiBinding();
        }
        return handle;
    }

    protected String getTargetId() {
        assert (this.jndiName != null) : "jndiName is null";
        String partition = ((SessionContainer)this.getContainer()).getPartitionName();
        return this.jndiName + "StatefulProxyFactory" + "@" + partition;
    }

    public synchronized void replicantsChanged(String key, List newReplicants, int newReplicantsViewId, boolean merge) {
        try {
            ArrayList targets = new ArrayList(newReplicants);
            this.wrapper.get().updateClusterInfo(targets, (long)newReplicantsViewId);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

