/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptor;

import java.lang.reflect.Method;
import java.util.Arrays;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.interceptor.EJB3InterceptorsInterceptor;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.logging.Logger;
import org.jboss.util.MethodHashing;

public class EJB3InterceptorsFactory
implements AspectFactory {
    static Logger log = Logger.getLogger(EJB3InterceptorsFactory.class);
    static final long MESSAGE_LISTENER_ON_MESSAGE;

    public String getName() {
        return this.getClass().getName();
    }

    public Object createPerVM() {
        throw new RuntimeException("NOT ALLOWED");
    }

    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        throw new RuntimeException("NOT ALLOWED");
    }

    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        throw new RuntimeException("NOT ALLOWED");
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        if (jp instanceof MethodJoinpoint) {
            EJBContainer container = (EJBContainer)advisor;
            Class<?> beanClass = container.getBeanClass();
            try {
                Method method = ((MethodJoinpoint)jp).getMethod();
                if (container.isBusinessMethod(method)) {
                    InterceptorInfo[] infos = container.getInterceptorRepository().getBusinessInterceptors(container, method);
                    Method[] beanAroundInvoke = container.getInterceptorRepository().getBeanClassAroundInvokes(container);
                    Object infoString = "[]";
                    if (infoString != null) {
                        infoString = Arrays.asList(infos);
                    }
                    log.debug((Object)("Bound interceptors for joinpoint: " + method + " - " + infoString));
                    return new EJB3InterceptorsInterceptor(infos, beanAroundInvoke);
                }
            }
            catch (RuntimeException e) {
                throw new RuntimeException("An exception occurred initialising interceptors for " + beanClass + "." + ((MethodJoinpoint)jp).getMethod().getName(), e);
            }
        }
        return new EJB3InterceptorsInterceptor(new InterceptorInfo[0], null);
    }

    public Object createPerClass(Advisor advisor) {
        throw new RuntimeException("NOT ALLOWED");
    }

    static {
        try {
            Class<MessageListener> clazz = MessageListener.class;
            Method m = clazz.getDeclaredMethod("onMessage", Message.class);
            MESSAGE_LISTENER_ON_MESSAGE = MethodHashing.calculateHash((Method)m);
        }
        catch (Exception e) {
            throw new RuntimeException("Error initialising hash for MessageListener.onMessage()", e);
        }
    }
}

