/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.security.JaccPolicyUtil;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.EJB3Deployer;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.deployers.Ejb3JBoss5Deployment;
import org.jboss.ejb3.deployers.JBoss5DeploymentScope;
import org.jboss.ejb3.deployers.JBoss5DeploymentUnit;
import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class EJBRegistrationDeployer
extends AbstractVFSRealDeployer {
    private static final Logger log = Logger.getLogger(EJBRegistrationDeployer.class);
    private HashSet ignoredJarsSet;
    private MBeanServer mbeanServer;
    private Kernel kernel;
    private Properties defaultPersistenceProperties;
    private List<String> allowedSuffixes;
    private boolean requireDeploymentDescriptor;

    public EJBRegistrationDeployer() {
        this.setRelativeOrder(-1);
        this.setOutputs(new String[]{Ejb3Deployment.class.getName(), JaccPolicyUtil.IGNORE_ME_NAME});
    }

    public List<String> getAllowedSuffixes() {
        return this.allowedSuffixes;
    }

    public void setAllowedSuffixes(List<String> allowedSuffixes) {
        this.allowedSuffixes = allowedSuffixes;
    }

    public HashSet getIgnoredJarsSet() {
        return this.ignoredJarsSet;
    }

    public void setIgnoredJarsSet(HashSet ignoredJarsSet) {
        this.ignoredJarsSet = ignoredJarsSet;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public Properties getDefaultPersistenceProperties() {
        return this.defaultPersistenceProperties;
    }

    public void setDefaultPersistenceProperties(Properties defaultPersistenceProperties) {
        this.defaultPersistenceProperties = defaultPersistenceProperties;
    }

    public boolean getRequireDeploymentDescriptor() {
        return this.requireDeploymentDescriptor;
    }

    public void setRequireDeploymentDescriptor(boolean requireDeploymentDescriptor) {
        this.requireDeploymentDescriptor = requireDeploymentDescriptor;
    }

    public void deploy(VFSDeploymentUnit unit) throws DeploymentException {
        try {
            boolean hasEjbDd = false;
            boolean hasJbossDd = false;
            VirtualFile jar = unit.getRoot();
            if (jar.isLeaf() || this.ignoredJarsSet.contains(jar.getName())) {
                log.trace((Object)("EJBRegistrationDeployer ignoring: " + jar.getName()));
                return;
            }
            if (!this.hasAllowedSuffix(jar.getName())) {
                log.trace((Object)("EJBRegistrationDeployer suffix not allowed: " + jar.getName()));
                return;
            }
            VirtualFile ejbjar = unit.getMetaDataFile("ejb-jar.xml");
            if (ejbjar != null) {
                InputStream is = ejbjar.openStream();
                boolean has30EjbJarXml = EJB3Deployer.has30EjbJarXml(is);
                is.close();
                if (!has30EjbJarXml) {
                    return;
                }
                hasEjbDd = true;
            }
            boolean bl = hasJbossDd = unit.getMetaDataFile("jboss.xml") != null;
            if (this.getRequireDeploymentDescriptor() && !hasJbossDd && !hasEjbDd) {
                log.trace((Object)(EJBRegistrationDeployer.class.getSimpleName() + " skipping deployment \"" + unit.getSimpleName() + "\", jar: \"" + jar.getName() + "\" - either EJB3 Deployment Descriptor or \"jboss.xml\" is required and neither were found."));
                return;
            }
            log.debug((Object)("********* EJBRegistrationDepoyer Begin Unit: " + unit.getSimpleName() + " jar: " + jar.getName()));
            DeploymentScope scope = null;
            VFSDeploymentUnit parent = unit.getParent();
            if (parent != null && parent.getSimpleName().endsWith(".ear") && (scope = (DeploymentScope)parent.getAttachment(DeploymentScope.class)) == null) {
                scope = new JBoss5DeploymentScope(unit.getParent());
                parent.addAttachment(DeploymentScope.class, (Object)scope);
            }
            JBoss5DeploymentUnit du = new JBoss5DeploymentUnit(unit);
            du.setDefaultPersistenceProperties(this.defaultPersistenceProperties);
            Ejb3JBoss5Deployment deployment = new Ejb3JBoss5Deployment(du, this.kernel, this.mbeanServer, (DeploymentUnit)unit, scope, null, null, null);
            if (scope != null) {
                scope.register(deployment);
            }
            deployment.create();
            if (deployment.getEjbContainers().size() == 0 && deployment.getPersistenceUnitDeployments().size() == 0) {
                log.trace((Object)("EJBRegistrationDeployer no containers in scanned jar, consider adding it to the ignore list: " + jar.getName() + " url: " + jar.toURL() + " unit: " + unit.getSimpleName()));
                return;
            }
            unit.addAttachment(Ejb3Deployment.class, (Object)deployment);
            unit.addAttachment(JaccPolicyUtil.IGNORE_ME_NAME, (Object)true, Boolean.class);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private boolean hasAllowedSuffix(String name) {
        if (this.allowedSuffixes == null) {
            return true;
        }
        for (String suffix : this.allowedSuffixes) {
            if (!name.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public void undeploy(VFSDeploymentUnit unit) {
        Ejb3Deployment deployment = (Ejb3Deployment)unit.getAttachment(Ejb3Deployment.class);
        if (deployment == null) {
            return;
        }
        try {
            deployment.stop();
        }
        catch (Exception e) {
            log.error((Object)"failed to stop deployment", (Throwable)e);
        }
        try {
            deployment.destroy();
        }
        catch (Exception e) {
            log.error((Object)"failed to destroy deployment", (Throwable)e);
        }
    }
}

