/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.clientmodule;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.clientmodule.ClientEjbResolver;
import org.jboss.ejb3.deployers.JBoss5DependencyPolicy;
import org.jboss.ejb3.deployers.JBoss5DeploymentScope;
import org.jboss.ejb3.deployers.JBoss5DeploymentUnit;
import org.jboss.ejb3.enc.DeploymentEjbResolver;
import org.jboss.ejb3.enc.MessageDestinationResolver;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;
import org.jboss.ejb3.javaee.AbstractJavaEEComponent;
import org.jboss.ejb3.javaee.SimpleJavaEEModule;
import org.jboss.injection.DependsHandler;
import org.jboss.injection.EJBRemoteHandler;
import org.jboss.injection.EncInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.PersistenceUnitHandler;
import org.jboss.injection.ResourceHandler;
import org.jboss.injection.WebServiceRefHandler;
import org.jboss.logging.Logger;
import org.jboss.metadata.client.jboss.JBossClientMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
import org.jboss.metadata.serviceref.ServiceReferenceHandler;
import org.jboss.metadata.serviceref.VirtualFileAdaptor;
import org.jboss.virtual.VirtualFile;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientENCInjectionContainer
extends AbstractJavaEEComponent
implements InjectionContainer {
    private static final Logger log = Logger.getLogger(ClientENCInjectionContainer.class);
    private DeploymentUnit ejb3Unit;
    private JBossClientMetaData clientMetaData;
    private Class<?> mainClass;
    private String applicationClientName;
    private ClassLoader classLoader;
    private List<Injector> injectors = new ArrayList<Injector>();
    private Map<String, Map<AccessibleObject, Injector>> encInjections = new HashMap<String, Map<AccessibleObject, Injector>>();
    private Map<String, EncInjector> encInjectors = new HashMap<String, EncInjector>();
    private Context enc;
    private DeploymentEjbResolver ejbResolver;
    private DeploymentScope deploymentScope;
    private ObjectName objectName;
    private DependencyPolicy dependencyPolicy = new JBoss5DependencyPolicy(this);
    private MessageDestinationResolver messageDestinationResolver;

    public ClientENCInjectionContainer(VFSDeploymentUnit unit, JBossClientMetaData xml, Class<?> mainClass, String applicationClientName, ClassLoader classLoader, Context encCtx) throws NamingException {
        super(new SimpleJavaEEModule(unit.getParent() != null ? unit.getParent().getSimpleName() : null, unit.getSimpleName()));
        if (mainClass == null) {
            throw new NullPointerException("mainClass is mandatory");
        }
        if (applicationClientName == null) {
            throw new NullPointerException("applicationClientName is mandatory");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is mandatory");
        }
        this.ejb3Unit = new JBoss5DeploymentUnit(unit);
        this.clientMetaData = xml;
        this.mainClass = mainClass;
        this.applicationClientName = applicationClientName;
        this.classLoader = classLoader;
        this.enc = encCtx;
        if (unit.getParent() != null) {
            this.deploymentScope = new JBoss5DeploymentScope(unit.getParent());
        }
        this.ejbResolver = new ClientEjbResolver(this.deploymentScope, unit.getSimpleName());
        this.messageDestinationResolver = new MessageDestinationResolver(this.deploymentScope, xml.getMessageDestinations());
        String on = "jboss.j2ee:service=EJB3" + this.createScopeKernelName(unit, this.deploymentScope) + ",name=" + applicationClientName;
        try {
            this.objectName = new ObjectName(on);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Malformed object name " + on, e);
        }
        this.processMetaData();
    }

    private String createScopeKernelName(VFSDeploymentUnit unit, DeploymentScope ear) {
        String scopedKernelName = "";
        if (ear != null) {
            scopedKernelName = scopedKernelName + ",ear=" + ear.getShortName();
        }
        scopedKernelName = scopedKernelName + ",jar=" + unit.getSimpleName();
        return scopedKernelName;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz) {
        return clazz.getAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Method method) {
        return method.getAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Method method) {
        return method.getAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Field field) {
        return field.getAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Field field) {
        return field.getAnnotation(annotationType);
    }

    @Override
    public VirtualFile getRootFile() {
        return this.ejb3Unit.getRootFile();
    }

    @Override
    public ClassLoader getClassloader() {
        return this.classLoader;
    }

    @Override
    public DependencyPolicy getDependencyPolicy() {
        return this.dependencyPolicy;
    }

    @Override
    public String getDeploymentDescriptorType() {
        return "application-client.xml";
    }

    public String getEjbJndiName(Class businessInterface) throws NameNotFoundException {
        return this.ejbResolver.getEjbJndiName(businessInterface);
    }

    public String getEjbJndiName(String link, Class businessInterface) {
        return this.ejbResolver.getEjbJndiName(link, businessInterface);
    }

    @Override
    public Context getEnc() {
        return this.enc;
    }

    @Override
    public Map<String, Map<AccessibleObject, Injector>> getEncInjections() {
        return this.encInjections;
    }

    @Override
    public Map<String, EncInjector> getEncInjectors() {
        return this.encInjectors;
    }

    @Override
    public RemoteEnvironment getEnvironmentRefGroup() {
        return this.clientMetaData;
    }

    @Override
    public String getIdentifier() {
        return this.applicationClientName;
    }

    @Override
    public List<Injector> getInjectors() {
        return this.injectors;
    }

    public Class<?> getMainClass() {
        return this.mainClass;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public PersistenceUnitDeployment getPersistenceUnitDeployment(String unitName) throws NameNotFoundException {
        throw new RuntimeException("NYI");
    }

    @Override
    public boolean hasJNDIBinding(String jndiName) {
        return false;
    }

    private void populateEnc() {
        for (EncInjector injector : this.encInjectors.values()) {
            log.trace((Object)("encInjector: " + injector));
            injector.inject(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMetaData() {
        if (this.clientMetaData.getDepends() != null) {
            for (String dependency : this.clientMetaData.getDepends()) {
                this.getDependencyPolicy().addDependency(dependency);
            }
        }
        ArrayList handlers = new ArrayList();
        handlers.add(new EJBRemoteHandler());
        handlers.add(new DependsHandler());
        handlers.add(new PersistenceUnitHandler());
        handlers.add(new ResourceHandler());
        handlers.add(new WebServiceRefHandler());
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            ServiceReferencesMetaData serviceReferencesMetaData;
            for (InjectionHandler injectionHandler : handlers) {
                injectionHandler.loadXml(this.clientMetaData, this);
            }
            Map<AccessibleObject, Injector> tmp = InjectionUtil.processAnnotations(this, handlers, this.getMainClass());
            this.injectors.addAll(tmp.values());
            if (this.clientMetaData != null && (serviceReferencesMetaData = this.clientMetaData.getServiceReferences()) != null) {
                for (ServiceReferenceMetaData sref : serviceReferencesMetaData) {
                    try {
                        String name = sref.getServiceRefName();
                        String encName = "env/" + name;
                        Context encCtx = this.getEnc();
                        VirtualFileAdaptor vfsRoot = new VirtualFileAdaptor(this.getRootFile());
                        new ServiceReferenceHandler().bindServiceRef(encCtx, encName, (UnifiedVirtualFile)vfsRoot, this.getClassloader(), sref);
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to bind service-ref", (Throwable)e);
                    }
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public Container resolveEjbContainer(String link, Class businessIntf) {
        return this.ejbResolver.getEjbContainer(link, businessIntf);
    }

    public Container resolveEjbContainer(Class businessIntf) throws NameNotFoundException {
        return this.ejbResolver.getEjbContainer(businessIntf);
    }

    @Override
    public String resolveMessageDestination(String link) {
        return this.messageDestinationResolver.resolveMessageDestination(link);
    }

    public void start() {
        this.populateEnc();
        log.info((Object)("STARTED CLIENT ENC CONTAINER: " + this.applicationClientName));
    }

    public void stop() {
        log.info((Object)("STOPPED CLIENT ENC CONTAINER: " + this.applicationClientName));
    }
}

