/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.twiddle.command;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.console.twiddle.command.MBeanServerCommand;
import org.jboss.util.Strings;

public class UnregisterCommand
extends MBeanServerCommand {
    private List names = new ArrayList();

    public UnregisterCommand() {
        super("unregister", "Unregister one or more MBeans");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " [options] (<name>)+");
        out.println();
        out.println("options:");
        out.println("    --    Stop processing options");
        out.flush();
    }

    private void processArguments(String[] args) throws CommandException {
        int code;
        this.log.debug((Object)("processing arguments: " + Strings.join((Object[])args, (String)",")));
        if (args.length == 0) {
            throw new CommandException("Command requires arguments");
        }
        String sopts = "-:";
        LongOpt[] lopts = new LongOpt[]{};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        int argidx = 0;
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 1: {
                    String arg = getopt.getOptarg();
                    switch (argidx++) {
                        default: 
                    }
                    this.names.add(this.createObjectName(arg));
                    break;
                }
            }
        }
    }

    public void execute(String[] args) throws Exception {
        this.processArguments(args);
        this.log.debug((Object)("object names: " + this.names));
        if (this.names.size() == 0) {
            throw new CommandException("At least one object name is required");
        }
        MBeanServerConnection server = this.getMBeanServer();
        for (ObjectName name : this.names) {
            server.unregisterMBean(name);
        }
        this.closeServer();
    }
}

