/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.twiddle.command;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.console.twiddle.command.MBeanServerCommand;
import org.jboss.util.Strings;

public class ServerInfoCommand
extends MBeanServerCommand {
    public static final int UNKNOWN = 0;
    public static final int DEFAULT_DOMAIN = 1;
    public static final int MBEAN_COUNT = 2;
    public static final int LIST_NAMES = 3;
    private int mode = 0;

    public ServerInfoCommand() {
        super("serverinfo", "Get information about the MBean server");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " [options]");
        out.println();
        out.println("options:");
        out.println("    -d, --domain    Get the default domain");
        out.println("    -c, --count     Get the MBean count");
        out.println("    -l, --list      List the MBeans");
        out.println("    --              Stop processing options");
    }

    private void processArguments(String[] args) throws CommandException {
        int code;
        this.log.debug((Object)("processing arguments: " + Strings.join((Object[])args, (String)",")));
        if (args.length == 0) {
            throw new CommandException("Command requires arguments");
        }
        String sopts = "-:dcl";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("domain", 0, null, 100), new LongOpt("count", 0, null, 99), new LongOpt("list", 0, null, 108)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 1: {
                    throw new CommandException("Unused argument: " + getopt.getOptarg());
                }
                case 100: {
                    this.mode = 1;
                    break;
                }
                case 99: {
                    this.mode = 2;
                    break;
                }
                case 108: {
                    this.mode = 3;
                }
            }
        }
    }

    public void execute(String[] args) throws Exception {
        this.processArguments(args);
        PrintWriter out = this.context.getWriter();
        MBeanServerConnection server = this.getMBeanServer();
        switch (this.mode) {
            case 1: {
                out.println(server.getDefaultDomain());
                break;
            }
            case 2: {
                out.println(server.getMBeanCount());
                break;
            }
            case 3: {
                ObjectName all = new ObjectName("*:*");
                Set<ObjectName> names = server.queryNames(all, null);
                Iterator<ObjectName> iter = names.iterator();
                while (iter.hasNext()) {
                    out.println(iter.next());
                }
                break;
            }
            default: {
                throw new IllegalStateException("invalid mode: " + this.mode);
            }
        }
        out.flush();
        this.closeServer();
    }
}

