/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.twiddle.command;

import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.AbstractCommand;
import org.jboss.console.twiddle.command.CommandException;

public abstract class MBeanServerCommand
extends AbstractCommand {
    protected MBeanServerCommand(String name, String desc) {
        super(name, desc);
    }

    protected ObjectName createObjectName(String name) throws CommandException {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new CommandException("Invalid object name: " + name);
        }
    }

    protected void closeServer() {
        this.context.closeServer();
    }

    protected MBeanServerConnection getMBeanServer() {
        return this.context.getServer();
    }

    protected ObjectName[] queryMBeans(String query) throws Exception {
        MBeanServerConnection server = this.getMBeanServer();
        Set<ObjectName> matches = server.queryNames(new ObjectName(query), null);
        this.log.debug((Object)("Query matches: " + matches));
        if (matches.size() == 0) {
            throw new CommandException("No MBean matches for query: " + query);
        }
        ObjectName[] names = matches.toArray(new ObjectName[matches.size()]);
        return names;
    }
}

