/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.util.LinkedList;
import org.jboss.resource.connectionmanager.InternalManagedConnectionPool;
import org.jboss.resource.connectionmanager.SecurityActions;

public class PoolFiller
implements Runnable {
    private final LinkedList pools = new LinkedList();
    private final Thread fillerThread = new Thread((Runnable)this, "JCA PoolFiller");
    private static final PoolFiller filler = new PoolFiller();

    public static void fillPool(InternalManagedConnectionPool mcp) {
        filler.internalFillPool(mcp);
    }

    public PoolFiller() {
        this.fillerThread.setDaemon(true);
        this.fillerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ClassLoader myClassLoader = this.getClass().getClassLoader();
        SecurityActions.setTCL(myClassLoader);
        while (true) {
            try {
                InternalManagedConnectionPool mcp = null;
                while (true) {
                    LinkedList linkedList = this.pools;
                    synchronized (linkedList) {
                        mcp = (InternalManagedConnectionPool)this.pools.removeFirst();
                    }
                    if (mcp != null) {
                        mcp.fillToMin();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                LinkedList e = this.pools;
                synchronized (e) {
                    while (this.pools.isEmpty()) {
                        this.pools.wait();
                    }
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalFillPool(InternalManagedConnectionPool mcp) {
        LinkedList linkedList = this.pools;
        synchronized (linkedList) {
            this.pools.addLast(mcp);
            this.pools.notify();
        }
    }
}

