/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.connectionmanager.BaseConnectionManager2;
import org.jboss.resource.connectionmanager.CachedConnectionManager;
import org.jboss.resource.connectionmanager.ConnectionListener;
import org.jboss.resource.connectionmanager.ConnectionRecord;
import org.jboss.resource.connectionmanager.JBossLocalXAException;
import org.jboss.resource.connectionmanager.ManagedConnectionPool;
import org.jboss.resource.connectionmanager.SecurityActions;
import org.jboss.resource.connectionmanager.TransactionSynchronizer;
import org.jboss.resource.connectionmanager.TxConnectionManagerMBean;
import org.jboss.resource.connectionmanager.xa.XAResourceWrapperImpl;
import org.jboss.tm.LastResource;
import org.jboss.tm.TransactionTimeoutConfiguration;
import org.jboss.tm.TxUtils;
import org.jboss.util.NestedRuntimeException;

public class TxConnectionManager
extends BaseConnectionManager2
implements TxConnectionManagerMBean {
    private static final Throwable FAILED_TO_ENLIST = new Throwable("Unabled to enlist resource, see the previous warnings.");
    private ObjectName transactionManagerService;
    private String tmName;
    private TransactionManager tm;
    private boolean interleaving;
    private boolean localTransactions;
    private int xaResourceTimeout = 0;
    private boolean padXid;
    private boolean wrapXAResource;
    private Boolean isSameRMOverrideValue;
    private static final boolean IGNORE_STATUS_MARKED_FOR_ROLLBACK;

    protected static void rethrowAsSystemException(String context, Transaction tx, Throwable t) throws SystemException {
        if (t instanceof SystemException) {
            throw (SystemException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RollbackException) {
            throw new IllegalStateException(context + " tx=" + tx + " marked for rollback.");
        }
        throw new NestedRuntimeException(context + " tx=" + tx + " got unexpected error ", t);
    }

    public TxConnectionManager() {
    }

    public TxConnectionManager(CachedConnectionManager ccm, ManagedConnectionPool poolingStrategy, TransactionManager tm) {
        super(ccm, poolingStrategy);
        this.tm = tm;
    }

    @Override
    public ObjectName getTransactionManagerService() {
        return this.transactionManagerService;
    }

    @Override
    public void setTransactionManagerService(ObjectName transactionManagerService) {
        this.transactionManagerService = transactionManagerService;
    }

    @Override
    public void setTransactionManager(String tmName) {
        this.tmName = tmName;
    }

    @Override
    public String getTransactionManager() {
        return this.tmName;
    }

    @Override
    public TransactionManager getTransactionManagerInstance() {
        return this.tm;
    }

    public void setTransactionManagerInstance(TransactionManager tm) {
        this.tm = tm;
    }

    @Override
    @Deprecated
    public boolean isTrackConnectionByTx() {
        this.log.warn((Object)"isTrackConnectionByTx() is deprecated in favor of isInterleaving()");
        return !this.isInterleaving();
    }

    @Override
    @Deprecated
    public void setTrackConnectionByTx(boolean trackConnectionByTx) {
        this.log.warn((Object)"setTrackConnectionByTx(boolean value) is deprecated in favor of setInterleaving(boolean value)");
        this.setInterleaving(!trackConnectionByTx);
    }

    @Override
    public boolean isInterleaving() {
        return this.interleaving;
    }

    @Override
    public void setInterleaving(boolean value) {
        this.interleaving = value;
    }

    @Override
    public boolean isLocalTransactions() {
        return this.localTransactions;
    }

    @Override
    public void setLocalTransactions(boolean localTransactions) {
        this.localTransactions = localTransactions;
        if (localTransactions) {
            this.setInterleaving(false);
        }
    }

    @Override
    public int getXAResourceTransactionTimeout() {
        return this.xaResourceTimeout;
    }

    @Override
    public void setXAResourceTransactionTimeout(int timeout) {
        this.xaResourceTimeout = timeout;
    }

    @Override
    public Boolean getIsSameRMOverrideValue() {
        return this.isSameRMOverrideValue;
    }

    @Override
    public boolean getWrapXAResource() {
        return this.wrapXAResource;
    }

    @Override
    public void setWrapXAResource(boolean useXAWrapper) {
        this.wrapXAResource = useXAWrapper;
    }

    @Override
    public boolean getPadXid() {
        return this.padXid;
    }

    @Override
    public void setPadXid(boolean padXid) {
        this.padXid = padXid;
    }

    @Override
    public void setIsSameRMOverrideValue(Boolean isSameRMOverrideValue) {
        this.isSameRMOverrideValue = isSameRMOverrideValue;
    }

    @Override
    public long getTimeLeftBeforeTransactionTimeout(boolean errorRollback) throws RollbackException {
        if (this.tm == null) {
            throw new IllegalStateException("No transaction manager: " + this.ccmName);
        }
        if (this.tm instanceof TransactionTimeoutConfiguration) {
            return ((TransactionTimeoutConfiguration)this.tm).getTimeLeftBeforeTransactionTimeout(errorRollback);
        }
        return -1L;
    }

    @Override
    public void checkTransactionActive() throws RollbackException, SystemException {
        int status;
        if (this.tm == null) {
            throw new IllegalStateException("No transaction manager: " + this.ccmName);
        }
        Transaction tx = this.tm.getTransaction();
        if (!(tx == null || (status = tx.getStatus()) == 0 || status == 7 || status == 2 || status == 8 || status == 1 && IGNORE_STATUS_MARKED_FOR_ROLLBACK)) {
            throw new RollbackException("Transaction " + tx + " cannot proceed " + TxUtils.getStatusAsString((int)status));
        }
    }

    @Override
    protected void startService() throws Exception {
        if (this.transactionManagerService != null) {
            this.tm = (TransactionManager)this.getServer().getAttribute(this.transactionManagerService, "TransactionManager");
        } else {
            this.log.warn((Object)"----------------------------------------------------------");
            this.log.warn((Object)"----------------------------------------------------------");
            this.log.warn((Object)"Please change your datasource setup to use <depends optional-attribute-name\"TransactionManagerService\">jboss:service=TransactionManager</depends>");
            this.log.warn((Object)"instead of <attribute name=\"TransactionManager\">java:/TransactionManager</attribute>");
            this.log.warn((Object)"Better still, use a *-ds.xml file");
            this.log.warn((Object)"----------------------------------------------------------");
            this.log.warn((Object)"----------------------------------------------------------");
            this.tm = (TransactionManager)new InitialContext().lookup(this.tmName);
        }
        super.startService();
    }

    @Override
    protected void stopService() throws Exception {
        this.tm = null;
        super.stopService();
    }

    @Override
    public ConnectionListener getManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Transaction trackByTransaction = null;
        try {
            Transaction tx = this.tm.getTransaction();
            if (tx != null && !TxUtils.isActive((Transaction)tx)) {
                throw new ResourceException("Transaction is not active: tx=" + tx);
            }
            if (!this.interleaving) {
                trackByTransaction = tx;
            }
        }
        catch (Throwable t) {
            JBossResourceException.rethrowAsResourceException("Error checking for a transaction.", t);
        }
        if (this.trace) {
            this.log.trace((Object)("getManagedConnection interleaving=" + this.interleaving + " tx=" + trackByTransaction));
        }
        return super.getManagedConnection(trackByTransaction, subject, cri);
    }

    @Override
    public void transactionStarted(Collection crs) throws SystemException {
        HashSet<ConnectionListener> cls = new HashSet<ConnectionListener>();
        for (ConnectionRecord cr : crs) {
            ConnectionListener cl = cr.cl;
            if (cls.contains(cl)) continue;
            cls.add(cl);
            cl.enlist();
        }
    }

    @Override
    protected void managedConnectionReconnected(ConnectionListener cl) throws ResourceException {
        try {
            cl.enlist();
        }
        catch (Throwable t) {
            if (this.trace) {
                this.log.trace((Object)("Could not enlist in transaction on entering meta-aware object! " + cl), t);
            }
            throw new JBossResourceException("Could not enlist in transaction on entering meta-aware object!", t);
        }
    }

    @Override
    protected void managedConnectionDisconnected(ConnectionListener cl) throws ResourceException {
        Throwable throwable = null;
        try {
            cl.delist();
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (cl.isManagedConnectionFree()) {
            if (this.trace) {
                this.log.trace((Object)("Disconnected isManagedConnectionFree=true cl=" + cl));
            }
            this.returnManagedConnection(cl, false);
        } else if (this.trace) {
            this.log.trace((Object)("Disconnected isManagedConnectionFree=false cl=" + cl));
        }
        if (throwable != null) {
            JBossResourceException.rethrowAsResourceException("Could not delist resource, probably a transaction rollback? ", throwable);
        }
    }

    @Override
    public ConnectionListener createConnectionListener(ManagedConnection mc, Object context) throws ResourceException {
        Object xaResource = null;
        if (this.localTransactions) {
            xaResource = new LocalXAResource(this.log);
            if (this.xaResourceTimeout != 0) {
                this.log.debug((Object)("XAResource transaction timeout cannot be set for local transactions: " + this.getJndiName()));
            }
        } else {
            if (this.wrapXAResource) {
                String eisProductName = null;
                String eisProductVersion = null;
                try {
                    eisProductName = mc.getMetaData().getEISProductName();
                    eisProductVersion = mc.getMetaData().getEISProductVersion();
                }
                catch (ResourceException re) {
                    // empty catch block
                }
                this.log.trace((Object)("Generating XAResourceWrapper for TxConnectionManager" + this));
                xaResource = new XAResourceWrapperImpl(mc.getXAResource(), this.padXid, this.isSameRMOverrideValue, eisProductName, eisProductVersion);
            } else {
                this.log.trace((Object)"Not wrapping XAResource.");
                xaResource = mc.getXAResource();
            }
            if (this.xaResourceTimeout != 0) {
                try {
                    if (!xaResource.setTransactionTimeout(this.xaResourceTimeout)) {
                        this.log.debug((Object)("XAResource does not support transaction timeout configuration: " + this.getJndiName()));
                    }
                }
                catch (XAException e) {
                    throw new JBossResourceException("Unable to set XAResource transaction timeout: " + this.getJndiName(), e);
                }
            }
        }
        TxConnectionEventListener cli = new TxConnectionEventListener(mc, this.poolingStrategy, context, this.log, (XAResource)xaResource);
        mc.addConnectionEventListener((ConnectionEventListener)cli);
        return cli;
    }

    @Override
    public boolean isTransactional() {
        return !TxUtils.isCompleted((TransactionManager)this.tm);
    }

    static {
        boolean value = false;
        try {
            String property = SecurityActions.getSystemProperty("org.jboss.resource.connectionmanager.TxConnectionManager.ignoreStatusMarkedForRollback", "false");
            value = Boolean.parseBoolean(property);
            if (value) {
                Logger.getLogger(TxConnectionManager.class).info((Object)"TxConnectionManager will allow transaction work even if tx status = STATUS_MARKED_ROLLBACK");
            }
        }
        catch (Throwable t) {
            Logger.getLogger(TxConnectionManager.class).error((Object)"could not read system property 'org.jboss.resource.connectionmanager.TxConnectionManager.ignoreStatusMarkedForRollback'", t);
        }
        IGNORE_STATUS_MARKED_FOR_ROLLBACK = value;
    }

    private class LocalXAResource
    implements XAResource,
    LastResource {
        protected Logger log;
        private ConnectionListener cl;
        private boolean warned = false;
        private Xid currentXid;

        public LocalXAResource(Logger log) {
            this.log = log;
        }

        void setConnectionListener(ConnectionListener cl) {
            this.cl = cl;
        }

        @Override
        public void start(Xid xid, int flags) throws XAException {
            if (TxConnectionManager.this.trace) {
                this.log.trace((Object)("start, xid: " + xid + ", flags: " + flags));
            }
            if (this.currentXid != null && flags == 0) {
                throw new JBossLocalXAException("Trying to start a new tx when old is not complete! old: " + this.currentXid + ", new " + xid + ", flags " + flags, -6);
            }
            if (this.currentXid == null && flags != 0) {
                throw new JBossLocalXAException("Trying to start a new tx with wrong flags!  new " + xid + ", flags " + flags, -6);
            }
            if (this.currentXid == null) {
                try {
                    this.cl.getManagedConnection().getLocalTransaction().begin();
                }
                catch (ResourceException re) {
                    throw new JBossLocalXAException("Error trying to start local tx: ", -3, re);
                }
                catch (Throwable t) {
                    throw new JBossLocalXAException("Throwable trying to start local transaction!", -3, t);
                }
                this.currentXid = xid;
            }
        }

        @Override
        public void end(Xid xid, int flags) throws XAException {
            if (TxConnectionManager.this.trace) {
                this.log.trace((Object)("end on xid: " + xid + " called with flags " + flags));
            }
        }

        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            if (!xid.equals(this.currentXid)) {
                throw new JBossLocalXAException("wrong xid in commit: expected: " + this.currentXid + ", got: " + xid, -6);
            }
            this.currentXid = null;
            try {
                this.cl.getManagedConnection().getLocalTransaction().commit();
            }
            catch (ResourceException re) {
                TxConnectionManager.this.returnManagedConnection(this.cl, true);
                if (TxConnectionManager.this.trace) {
                    this.log.trace((Object)"commit problem: ", (Throwable)re);
                }
                throw new JBossLocalXAException("could not commit local tx", 100, re);
            }
        }

        @Override
        public void forget(Xid xid) throws XAException {
            throw new JBossLocalXAException("forget not supported in local tx", -3);
        }

        @Override
        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        @Override
        public boolean isSameRM(XAResource xaResource) throws XAException {
            return xaResource == this;
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            if (!this.warned) {
                this.log.warn((Object)"Prepare called on a local tx. Use of local transactions on a jta transaction with more than one branch may result in inconsistent data in some cases of failure.");
            }
            this.warned = true;
            return 0;
        }

        @Override
        public Xid[] recover(int flag) throws XAException {
            throw new JBossLocalXAException("no recover with local-tx only resource managers", -3);
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            if (!xid.equals(this.currentXid)) {
                throw new JBossLocalXAException("wrong xid in rollback: expected: " + this.currentXid + ", got: " + xid, -6);
            }
            this.currentXid = null;
            try {
                this.cl.getManagedConnection().getLocalTransaction().rollback();
            }
            catch (ResourceException re) {
                TxConnectionManager.this.returnManagedConnection(this.cl, true);
                if (TxConnectionManager.this.trace) {
                    this.log.trace((Object)"rollback problem: ", (Throwable)re);
                }
                throw new JBossLocalXAException("could not rollback local tx", -3, re);
            }
        }

        @Override
        public boolean setTransactionTimeout(int seconds) throws XAException {
            return false;
        }
    }

    protected class TxConnectionEventListener
    extends BaseConnectionManager2.BaseConnectionEventListener {
        protected Logger log;
        protected TransactionSynchronization transactionSynchronization;
        private final XAResource xaResource;
        private AtomicBoolean localTransaction;

        public TxConnectionEventListener(ManagedConnection mc, ManagedConnectionPool mcp, Object context, Logger log, XAResource xaResource) throws ResourceException {
            super(mc, mcp, context, log);
            this.localTransaction = new AtomicBoolean(false);
            this.log = log;
            this.xaResource = xaResource;
            if (xaResource instanceof LocalXAResource) {
                ((LocalXAResource)xaResource).setConnectionListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enlist() throws SystemException {
            int status = TxConnectionManager.this.tm.getStatus();
            if (status == 6) {
                if (this.transactionSynchronization != null && this.transactionSynchronization.currentTx != null) {
                    String error = "Attempt to use connection outside a transaction when already a tx!";
                    if (this.trace) {
                        this.log.trace((Object)(error + " " + this));
                    }
                    throw new IllegalStateException(error);
                }
                if (this.trace) {
                    this.log.trace((Object)("No transaction, no need to enlist: " + this));
                }
                return;
            }
            Transaction threadTx = TxConnectionManager.this.tm.getTransaction();
            if (threadTx == null || status != 0) {
                String error = "Transaction " + threadTx + " is not active " + TxUtils.getStatusAsString((int)status);
                if (this.trace) {
                    this.log.trace((Object)(error + " cl=" + this));
                }
                throw new IllegalStateException(error);
            }
            if (this.trace) {
                this.log.trace((Object)("Pre-enlist: " + this + " threadTx=" + threadTx));
            }
            TransactionSynchronization ourSynchronization = null;
            TransactionSynchronizer synchronizer = null;
            TransactionSynchronizer.lock(threadTx);
            try {
                if (!this.isTrackByTx() && this.transactionSynchronization != null) {
                    String error = "Can't enlist - already a tx!";
                    if (this.trace) {
                        this.log.trace((Object)(error + " " + this));
                    }
                    throw new IllegalStateException(error);
                }
                if (this.transactionSynchronization != null && !this.transactionSynchronization.currentTx.equals(threadTx)) {
                    String error = "Trying to change transaction " + threadTx + " in enlist!";
                    if (this.trace) {
                        this.log.trace((Object)(error + " " + this));
                    }
                    throw new IllegalStateException(error);
                }
                try {
                    if (this.trace) {
                        this.log.trace((Object)("Get synchronizer " + this + " threadTx=" + threadTx));
                    }
                    synchronizer = TransactionSynchronizer.getRegisteredSynchronizer(threadTx);
                }
                catch (Throwable t) {
                    this.setTrackByTx(false);
                    TxConnectionManager.rethrowAsSystemException("Cannot register synchronization", threadTx, t);
                }
                if (this.transactionSynchronization == null) {
                    TransactionSynchronization synchronization = new TransactionSynchronization(threadTx, this.isTrackByTx());
                    synchronizer.addUnenlisted(synchronization);
                    this.transactionSynchronization = synchronization;
                }
                ourSynchronization = this.transactionSynchronization;
            }
            finally {
                TransactionSynchronizer.unlock(threadTx);
            }
            ArrayList unenlisted = synchronizer.getUnenlisted();
            if (unenlisted != null) {
                try {
                    for (int i = 0; i < unenlisted.size(); ++i) {
                        TransactionSynchronization sync = (TransactionSynchronization)unenlisted.get(i);
                        if (!sync.enlist()) continue;
                        synchronizer.addEnlisted(sync);
                    }
                }
                finally {
                    synchronizer.enlisted();
                }
            }
            if (this.trace) {
                this.log.trace((Object)("Check enlisted " + this + " threadTx=" + threadTx));
            }
            ourSynchronization.checkEnlisted();
        }

        @Override
        public void delist() throws ResourceException {
            if (this.trace) {
                this.log.trace((Object)("delisting " + this));
            }
            try {
                if (!this.isTrackByTx() && this.transactionSynchronization != null) {
                    Transaction tx = this.transactionSynchronization.currentTx;
                    TransactionSynchronization synchronization = this.transactionSynchronization;
                    this.transactionSynchronization = null;
                    if (TxUtils.isUncommitted((Transaction)tx)) {
                        TransactionSynchronizer synchronizer = TransactionSynchronizer.getRegisteredSynchronizer(tx);
                        if (synchronization.enlisted) {
                            synchronizer.removeEnlisted(synchronization);
                        }
                        if (!tx.delistResource(this.getXAResource(), 0x2000000)) {
                            throw new ResourceException("Failure to delist resource: " + this);
                        }
                    }
                }
            }
            catch (Throwable t) {
                JBossResourceException.rethrowAsResourceException("Error in delist!", t);
            }
        }

        protected XAResource getXAResource() {
            return this.xaResource;
        }

        public void connectionClosed(ConnectionEvent ce) {
            if (this.trace) {
                this.log.trace((Object)("connectionClosed called mc=" + this.getManagedConnection()));
            }
            if (this.getManagedConnection() != (ManagedConnection)ce.getSource()) {
                throw new IllegalArgumentException("ConnectionClosed event received from wrong ManagedConnection! Expected: " + this.getManagedConnection() + ", actual: " + ce.getSource());
            }
            try {
                TxConnectionManager.this.getCcm().unregisterConnection(TxConnectionManager.this, ce.getConnectionHandle());
            }
            catch (Throwable t) {
                this.log.info((Object)"throwable from unregister connection", t);
            }
            try {
                if (this.wasFreed(ce.getConnectionHandle())) {
                    this.delist();
                    if (this.trace) {
                        this.log.trace((Object)("isManagedConnectionFree=true mc=" + this.getManagedConnection()));
                    }
                    TxConnectionManager.this.returnManagedConnection(this, false);
                } else if (this.trace) {
                    this.log.trace((Object)("isManagedConnectionFree=false mc=" + this.getManagedConnection()));
                }
            }
            catch (Throwable t) {
                this.log.error((Object)"Error while closing connection handle!", t);
                TxConnectionManager.this.returnManagedConnection(this, true);
            }
        }

        public void localTransactionStarted(ConnectionEvent ce) {
            this.localTransaction.set(true);
        }

        public void localTransactionCommitted(ConnectionEvent ce) {
            this.localTransaction.set(false);
        }

        public void localTransactionRolledback(ConnectionEvent ce) {
            this.localTransaction.set(false);
        }

        @Override
        public void tidyup() throws ResourceException {
            if (this.localTransaction.get()) {
                LocalTransaction local = null;
                ManagedConnection mc = this.getManagedConnection();
                try {
                    local = mc.getLocalTransaction();
                }
                catch (Throwable t) {
                    JBossResourceException.rethrowAsResourceException("Unfinished local transaction - error getting local transaction from " + this, t);
                }
                if (local == null) {
                    throw new ResourceException("Unfinished local transaction but managed connection does not provide a local transaction. " + this);
                }
                local.rollback();
                this.log.debug((Object)("Unfinished local transaction was rolled back." + this));
            }
        }

        @Override
        public void connectionErrorOccurred(ConnectionEvent ce) {
            this.transactionSynchronization = null;
            super.connectionErrorOccurred(ce);
        }

        @Override
        public boolean isManagedConnectionFree() {
            if (this.isTrackByTx() && this.transactionSynchronization != null) {
                return false;
            }
            return super.isManagedConnectionFree();
        }

        synchronized boolean wasFreed(Object handle) {
            if (handle != null) {
                if (this.isManagedConnectionFree()) {
                    return false;
                }
                TxConnectionManager.this.unregisterAssociation(this, handle);
            } else {
                if (!this.isTrackByTx()) {
                    return false;
                }
                this.setTrackByTx(false);
            }
            return this.isManagedConnectionFree();
        }

        @Override
        protected void toString(StringBuffer buffer) {
            buffer.append(" xaResource=").append(this.xaResource);
            buffer.append(" txSync=").append(this.transactionSynchronization);
        }

        private class TransactionSynchronization
        implements Synchronization {
            private Transaction currentTx;
            private boolean wasTrackByTx;
            private boolean enlisted = false;
            private Throwable enlistError;

            public TransactionSynchronization(Transaction tx, boolean trackByTx) {
                this.currentTx = tx;
                this.wasTrackByTx = trackByTx;
            }

            public void checkEnlisted() throws SystemException {
                if (this.enlistError != null) {
                    String error = "Error enlisting resource in transaction=" + this.currentTx;
                    if (TxConnectionEventListener.this.trace) {
                        TxConnectionEventListener.this.log.trace((Object)(error + " " + TxConnectionEventListener.this));
                    }
                    if (this.enlistError == FAILED_TO_ENLIST) {
                        throw new SystemException(FAILED_TO_ENLIST + " tx=" + this.currentTx);
                    }
                    SystemException e = new SystemException(error);
                    e.initCause(this.enlistError);
                    throw e;
                }
                if (!this.enlisted) {
                    String error = "Resource is not enlisted in transaction=" + this.currentTx;
                    if (TxConnectionEventListener.this.trace) {
                        TxConnectionEventListener.this.log.trace((Object)(error + " " + TxConnectionEventListener.this));
                    }
                    throw new IllegalStateException("Resource was not enlisted.");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean enlist() {
                if (TxConnectionEventListener.this.trace) {
                    TxConnectionEventListener.this.log.trace((Object)("Enlisting resource " + TxConnectionEventListener.this));
                }
                try {
                    XAResource resource = TxConnectionEventListener.this.getXAResource();
                    if (!this.currentTx.enlistResource(resource)) {
                        this.enlistError = FAILED_TO_ENLIST;
                    }
                }
                catch (Throwable t) {
                    this.enlistError = t;
                }
                TransactionSynchronization transactionSynchronization = this;
                synchronized (transactionSynchronization) {
                    if (this.enlistError != null) {
                        if (TxConnectionEventListener.this.trace) {
                            TxConnectionEventListener.this.log.trace((Object)("Failed to enlist resource " + TxConnectionEventListener.this), this.enlistError);
                        }
                        TxConnectionEventListener.this.setTrackByTx(false);
                        TxConnectionEventListener.this.transactionSynchronization = null;
                        return false;
                    }
                    if (TxConnectionEventListener.this.trace) {
                        TxConnectionEventListener.this.log.trace((Object)("Enlisted resource " + TxConnectionEventListener.this));
                    }
                    this.enlisted = true;
                    return true;
                }
            }

            public void beforeCompletion() {
            }

            public void afterCompletion(int status) {
                if (TxConnectionEventListener.this.getState() == 2) {
                    return;
                }
                if (!this.equals(TxConnectionEventListener.this.transactionSynchronization)) {
                    if (!this.wasTrackByTx) {
                        return;
                    }
                    String message = "afterCompletion called with wrong tx! Expected: " + this + ", actual: " + TxConnectionEventListener.this.transactionSynchronization;
                    IllegalStateException e = new IllegalStateException(message);
                    TxConnectionEventListener.this.log.error((Object)"There is something wrong with the pooling?", (Throwable)e);
                }
                TxConnectionEventListener.this.transactionSynchronization = null;
                if (this.wasTrackByTx) {
                    if (TxConnectionEventListener.this.trace) {
                        TxConnectionEventListener.this.log.trace((Object)("afterCompletion(" + status + ") isTrackByTx=" + TxConnectionEventListener.this.isTrackByTx() + " for " + TxConnectionEventListener.this));
                    }
                    if (TxConnectionEventListener.this.wasFreed(null)) {
                        TxConnectionManager.this.returnManagedConnection(TxConnectionEventListener.this, false);
                    }
                }
            }

            public String toString() {
                StringBuffer buffer = new StringBuffer();
                buffer.append("TxSync").append(System.identityHashCode(this));
                buffer.append("{tx=").append(this.currentTx);
                buffer.append(" wasTrackByTx=").append(this.wasTrackByTx);
                buffer.append(" enlisted=").append(this.enlisted);
                buffer.append("}");
                return buffer.toString();
            }
        }
    }
}

