/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.timestamp;

import java.io.Serializable;

public class TimestampDiscrepancy
implements Serializable {
    private static final long serialVersionUID = -6193847623651196577L;
    public static final TimestampDiscrepancy NO_DISCREPANCY;
    private final long fastRequestLimit;
    private final long fastResponseLimit;
    private final long minDiscrepancy;
    private final long maxDiscrepancy;
    private final long remoteTimestamp;
    private final long requestRoundtripTime;

    public TimestampDiscrepancy(long remoteTimestamp, long requestSent, long responseReceived) {
        if (responseReceived < requestSent) {
            throw new IllegalArgumentException("Apparent time travel: " + responseReceived + " is less than " + requestSent);
        }
        this.fastRequestLimit = remoteTimestamp - requestSent;
        this.fastResponseLimit = responseReceived - remoteTimestamp;
        this.minDiscrepancy = Math.min(this.fastRequestLimit, this.fastResponseLimit);
        this.maxDiscrepancy = Math.max(this.fastRequestLimit, this.fastResponseLimit);
        this.remoteTimestamp = remoteTimestamp;
        this.requestRoundtripTime = responseReceived - requestSent;
    }

    public TimestampDiscrepancy(TimestampDiscrepancy base, TimestampDiscrepancy intermediary) {
        if (base == null) {
            throw new IllegalArgumentException("Null base");
        }
        if (intermediary == null) {
            throw new IllegalArgumentException("Null intermediary");
        }
        this.fastRequestLimit = base.fastRequestLimit + intermediary.fastRequestLimit;
        this.fastResponseLimit = base.fastResponseLimit + intermediary.fastResponseLimit;
        this.minDiscrepancy = Math.min(this.fastRequestLimit, this.fastResponseLimit);
        this.maxDiscrepancy = Math.max(this.fastRequestLimit, this.fastResponseLimit);
        this.remoteTimestamp = base.remoteTimestamp;
        this.requestRoundtripTime = base.requestRoundtripTime + intermediary.requestRoundtripTime;
    }

    public long getRemoteTimestamp() {
        return this.remoteTimestamp;
    }

    public long getMinDiscrepancy() {
        return this.minDiscrepancy;
    }

    public long getMaxDiscrepancy() {
        return this.maxDiscrepancy;
    }

    public long getAbsoluteMaxDiscrepancy() {
        return Math.max(Math.abs(this.minDiscrepancy), Math.abs(this.maxDiscrepancy));
    }

    public long getDiscrepancyRange() {
        return this.maxDiscrepancy - this.minDiscrepancy;
    }

    public long getEstimatedDiscrepancy() {
        return (this.maxDiscrepancy + this.minDiscrepancy) / 2L;
    }

    public long getRequestRoundtripTime() {
        return this.requestRoundtripTime;
    }

    public long getMinLocalTimestamp(long remoteTimestamp) {
        return remoteTimestamp - this.minDiscrepancy;
    }

    public long getMaxLocalTimestamp(long remoteTimestamp) {
        return remoteTimestamp + this.maxDiscrepancy;
    }

    public long getMinRemoteTimestamp(long localTimestamp) {
        return localTimestamp + this.minDiscrepancy;
    }

    public long getMaxRemoteTimestamp(long localTimestamp) {
        return localTimestamp - this.maxDiscrepancy;
    }

    static {
        long now = System.currentTimeMillis();
        NO_DISCREPANCY = new TimestampDiscrepancy(now, now, now);
    }
}

