/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.interfaces;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;

public class SubPartitionInfo
implements Comparable,
Cloneable,
Serializable {
    private static final long serialVersionUID = -4116262958129610472L;
    public String subPartitionName = null;
    public HashSet subPartitionMergedNames = new HashSet();
    public ArrayList memberNodeNames = new ArrayList();
    private transient boolean newGroup = false;

    public SubPartitionInfo() {
    }

    public SubPartitionInfo(String partitionName, String[] members) {
        this.subPartitionName = partitionName;
        if (members != null) {
            for (int i = 0; i < members.length; ++i) {
                this.memberNodeNames.add(members[i]);
            }
        }
    }

    public void setIsNewGroup() {
        this.newGroup = true;
    }

    public void merge(SubPartitionInfo merged) {
        this.memberNodeNames.addAll(merged.memberNodeNames);
        if (this.newGroup && !merged.newGroup) {
            this.subPartitionName = merged.subPartitionName;
        } else if (!merged.newGroup) {
            this.subPartitionMergedNames.add(merged.subPartitionName);
        }
        if (!merged.newGroup) {
            this.subPartitionMergedNames.add(merged.subPartitionName);
        }
        this.subPartitionMergedNames.addAll(merged.subPartitionMergedNames);
        merged.memberNodeNames.clear();
        merged.subPartitionMergedNames.clear();
    }

    public String toString() {
        return this.subPartitionName + ":[" + this.memberNodeNames + "] aka '" + this.subPartitionMergedNames + "'";
    }

    public boolean actsForSubPartition(String subPartitionName) {
        return this.subPartitionName.equals(subPartitionName) || this.subPartitionMergedNames.contains(subPartitionName);
    }

    public boolean containsNode(String node) {
        return this.memberNodeNames.contains(node);
    }

    public int compareTo(Object o) {
        int itsSize;
        int mySize = this.memberNodeNames.size();
        if (mySize == (itsSize = ((SubPartitionInfo)o).memberNodeNames.size())) {
            return 0;
        }
        if (mySize > itsSize) {
            return 1;
        }
        return -1;
    }

    public Object clone() {
        SubPartitionInfo clonedObject = new SubPartitionInfo();
        clonedObject.subPartitionName = this.subPartitionName;
        clonedObject.memberNodeNames = (ArrayList)this.memberNodeNames.clone();
        clonedObject.subPartitionMergedNames = (HashSet)this.subPartitionMergedNames.clone();
        return clonedObject;
    }
}

