/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.singleton.HASingletonElectionPolicySimple;
import org.jboss.ha.singleton.PreferredMasterElectionPolicyMBean;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferredMasterElectionPolicy
extends HASingletonElectionPolicySimple
implements PreferredMasterElectionPolicyMBean {
    private Logger log = Logger.getLogger(this.getClass());
    private volatile InetSocketAddress preferredMaster;

    @Override
    public void setPreferredMaster(String value) {
        String node;
        String string = node = value != null ? value.trim() : "";
        if (node.length() > 0) {
            try {
                URI uri = new URI("cluster://" + node);
                String host = uri.getHost();
                if (host == null) {
                    throw new IllegalArgumentException("Cannot extract host/address from " + node);
                }
                this.preferredMaster = new InetSocketAddress(InetAddress.getByName(host), uri.getPort());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Cannot extract URI from " + node, e);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Cannot resolve host from " + node, e);
            }
        } else {
            this.preferredMaster = null;
        }
    }

    @Override
    public String getPreferredMaster() {
        InetSocketAddress address = this.preferredMaster;
        return address != null ? address.toString() : null;
    }

    @Override
    public ClusterNode elect(List<ClusterNode> candidates) {
        InetSocketAddress sockAddress = this.preferredMaster;
        ClusterNode master = null;
        if (sockAddress != null) {
            InetAddress address = sockAddress.getAddress();
            int port = sockAddress.getPort();
            master = this.find(candidates, address.getHostAddress(), port);
            if (master == null) {
                master = this.find(candidates, address.getHostName(), port);
            }
        }
        return master != null ? master : super.elect(candidates);
    }

    private ClusterNode find(List<ClusterNode> candidates, String host, int port) {
        String node = host + ":" + port;
        this.log.debug((Object)("Checking if " + node + " is in candidate list: " + candidates));
        for (ClusterNode candidate : candidates) {
            if (!candidate.getName().equals(node)) continue;
            return candidate;
        }
        return null;
    }
}

