/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.http.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.InvokerHA;
import org.jboss.invocation.http.interfaces.HttpInvokerProxyHA;
import org.jboss.invocation.http.server.HttpInvoker;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.system.Registry;
import org.jboss.util.UnreachableStatementException;

public class HttpInvokerHA
extends HttpInvoker
implements InvokerHA {
    protected HashMap<Integer, HATarget> targetMap = new HashMap();

    protected void startService() throws Exception {
        ObjectName name = super.getServiceName();
        Registry.bind((Object)name, (Object)this);
        super.checkInvokerURL();
        this.log.debug((Object)"Bound HttpHA invoker for JMX node");
    }

    protected void stopService() {
        ObjectName name = super.getServiceName();
        Registry.unbind((Object)name);
        this.log.debug((Object)"Unbound HttpHA invoker for JMX node");
    }

    protected void destroyService() {
        Registry.unbind((Object)this.serviceName);
    }

    public void registerBean(ObjectName targetName, HATarget target) throws Exception {
        Integer hash = new Integer(targetName.hashCode());
        this.log.debug((Object)("Registered targetName(" + targetName + "), hash=" + hash + ", target=" + target));
        if (this.targetMap.containsKey(hash)) {
            throw new IllegalStateException("Duplicate targetName(" + targetName + ") hashCode: " + hash);
        }
        this.targetMap.put(hash, target);
    }

    public void unregisterBean(ObjectName targetName) throws Exception {
        Integer hash = new Integer(targetName.hashCode());
        this.targetMap.remove(hash);
        this.log.debug((Object)("Unregistered targetName(" + targetName + "), hash=" + hash));
    }

    public Invoker createProxy(ObjectName targetName, LoadBalancePolicy policy, String proxyFamilyName) throws Exception {
        Integer hash = new Integer(targetName.hashCode());
        HATarget target = this.targetMap.get(hash);
        if (target == null) {
            throw new IllegalStateException("The targetName(" + targetName + "), hashCode(" + hash + ") not found");
        }
        HttpInvokerProxyHA proxy = new HttpInvokerProxyHA(target.getReplicants(), target.getCurrentViewId(), policy, proxyFamilyName);
        return proxy;
    }

    public Serializable getStub() {
        return super.getInvokerURL();
    }

    public Object invoke(Invocation invocation) throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            ObjectName mbean = (ObjectName)Registry.lookup((Object)invocation.getObjectName());
            long clientViewId = (Long)invocation.getValue((Object)"CLUSTER_VIEW_ID");
            HATarget target = this.targetMap.get(invocation.getObjectName());
            if (target == null) {
                throw new GenericClusteringException(1, "target is not/no more registered on this node");
            }
            if (!target.invocationsAllowed()) {
                throw new GenericClusteringException(1, "invocations are currently not allowed on this target");
            }
            Object[] args = new Object[]{invocation};
            String[] sig = new String[]{"org.jboss.invocation.Invocation"};
            Object rtn = super.getServer().invoke(mbean, "invoke", args, sig);
            HARMIResponse rsp = new HARMIResponse();
            if (clientViewId != target.getCurrentViewId()) {
                rsp.newReplicants = new ArrayList(target.getReplicants());
                rsp.currentViewId = target.getCurrentViewId();
            }
            rsp.response = rtn;
            HARMIResponse hARMIResponse = rsp;
            return hARMIResponse;
        }
        catch (InstanceNotFoundException e) {
            throw new GenericClusteringException(1, (Throwable)e);
        }
        catch (ReflectionException e) {
            throw new GenericClusteringException(1, (Throwable)e);
        }
        catch (Exception e) {
            JMXExceptionDecoder.rethrow((Exception)e);
            throw new UnreachableStatementException();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

