/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.jndi;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.jndi.spi.DistributedTreeManager;
import org.jboss.logging.Logger;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HAJNDI
implements Naming {
    private static final Logger log = Logger.getLogger(HAJNDI.class);
    static final long serialVersionUID = -6277328603304171620L;
    private final HAPartition partition;
    private final DistributedTreeManager delegate;

    public HAJNDI(HAPartition partition, DistributedTreeManager delegate) {
        if (partition == null) {
            throw new IllegalArgumentException("Null partition");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        this.partition = partition;
        this.delegate = delegate;
    }

    public void init() {
        log.debug((Object)"HAJNDI registering RPC Handler with HAPartition");
        this.partition.registerRPCHandler("HAJNDI", (Object)this);
        this.delegate.init();
    }

    public void shutdown() {
        log.debug((Object)"HAJNDI unregistering RPCHandler with HAPartition");
        this.partition.unregisterRPCHandler("HAJNDI", (Object)this);
        this.delegate.shutdown();
    }

    public Object lookupLocally(Name name) throws NamingException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("lookupLocally, name=" + name));
        }
        try {
            if (NamingContext.localServer != null) {
                return NamingContext.localServer.lookup(name);
            }
            return new InitialContext().lookup(name);
        }
        catch (NamingException e) {
            if (trace) {
                log.trace((Object)("lookupLocally failed, name=" + name), (Throwable)e);
            }
            throw e;
        }
        catch (RemoteException e) {
            NamingException ne = new NamingException("unknown remote exception");
            ne.setRootCause(e);
            if (trace) {
                log.trace((Object)("lookupLocally failed, name=" + name), (Throwable)e);
            }
            throw ne;
        }
        catch (RuntimeException e) {
            if (trace) {
                log.trace((Object)("lookupLocally failed, name=" + name), (Throwable)e);
            }
            throw e;
        }
    }

    public synchronized void bind(Name name, Object obj, String className) throws NamingException {
        this.delegate.bind(name, obj, className);
    }

    public synchronized void rebind(Name name, Object obj, String className) throws NamingException {
        this.delegate.rebind(name, obj, className);
    }

    public synchronized void unbind(Name name) throws NamingException {
        this.delegate.unbind(name);
    }

    public Object lookup(Name name) throws NamingException {
        Object binding;
        block3: {
            binding = this.delegate.lookup(name);
            if (binding == null) {
                try {
                    binding = this.lookupLocally(name);
                }
                catch (NameNotFoundException nne) {
                    binding = this.lookupRemotely(name);
                    if (binding != null) break block3;
                    throw nne;
                }
            }
        }
        return binding;
    }

    public Collection<NameClassPair> list(Name name) throws NamingException {
        return this.delegate.list(name);
    }

    public Collection<Binding> listBindings(Name name) throws NamingException {
        return this.delegate.listBindings(name);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.delegate.createSubcontext(name);
    }

    private Object lookupRemotely(Name name) throws NameNotFoundException {
        boolean trace = log.isTraceEnabled();
        Object[] args = new Object[]{name};
        List rsp = null;
        Exception cause = null;
        try {
            if (trace) {
                log.trace((Object)("calling lookupLocally(" + name + ") on HAJNDI cluster"));
            }
            rsp = this.partition.callMethodOnCluster("HAJNDI", "lookupLocally", args, new Class[]{Name.class}, true);
        }
        catch (Exception ignored) {
            if (trace) {
                log.trace((Object)("Clustered lookupLocally(" + name + ") failed"), (Throwable)ignored);
            }
            cause = ignored;
        }
        if (trace) {
            log.trace((Object)("Returned results size: " + (rsp != null ? rsp.size() : 0)));
        }
        if (rsp == null || rsp.size() == 0) {
            NameNotFoundException nnfe2 = new NameNotFoundException(name.toString());
            nnfe2.setRootCause(cause);
            throw nnfe2;
        }
        for (int i = 0; i < rsp.size(); ++i) {
            Object result = rsp.get(i);
            if (trace) {
                String type = result != null ? result.getClass().getName() : "null";
                log.trace((Object)("lookupLocally, i=" + i + ", value=" + result + ", type=" + type));
            }
            if (result == null || result instanceof Exception) continue;
            return result;
        }
        return null;
    }
}

