/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.jndi;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.MarshalledObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.net.ServerSocketFactory;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.ClusterPartitionMBean;
import org.jboss.ha.jndi.DetachedHANamingServiceMBean;
import org.jboss.ha.jndi.HAJNDI;
import org.jboss.ha.jndi.spi.DistributedTreeManager;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BasicThreadPoolMBean;
import org.jboss.util.threadpool.ThreadPool;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetachedHANamingService
extends ServiceMBeanSupport
implements DetachedHANamingServiceMBean {
    ServerSocket bootstrapSocket;
    HAJNDI theServer;
    private Map<Long, Method> marshalledInvocationMapping;
    Naming stub;
    protected HAPartition clusterPartition;
    private DistributedTreeManager distributedTreeManager;
    private ObjectName proxyFactory;
    InetAddress bindAddress;
    private int backlog = 50;
    int port = 1100;
    String adGroupAddress = "230.0.0.4";
    int adGroupPort = 1102;
    InetAddress discoveryBindAddress;
    private AutomaticDiscovery autoDiscovery = null;
    private boolean discoveryDisabled = false;
    int autoDiscoveryTTL = 16;
    private ServerSocketFactory jnpServerSocketFactory;
    private String jnpServerSocketFactoryName;
    ThreadPool lookupPool;

    @Override
    public Map<Long, Method> getMethodMap() {
        return this.marshalledInvocationMapping;
    }

    @Override
    public String getPartitionName() {
        return this.clusterPartition.getPartitionName();
    }

    @Override
    public HAPartition getHAPartition() {
        return this.clusterPartition;
    }

    @Override
    public void setHAPartition(HAPartition clusterPartition) {
        this.clusterPartition = clusterPartition;
    }

    @Override
    public DistributedTreeManager getDistributedTreeManager() {
        return this.distributedTreeManager;
    }

    @Override
    public void setDistributedTreeManager(DistributedTreeManager distributedTreeManager) {
        this.distributedTreeManager = distributedTreeManager;
    }

    @Override
    public ObjectName getProxyFactoryObjectName() {
        return this.proxyFactory;
    }

    @Override
    public void setProxyFactoryObjectName(ObjectName proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    @Override
    public void setPort(int p) {
        this.port = p;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getBindAddress() {
        String address = null;
        if (this.bindAddress != null) {
            address = this.bindAddress.getHostAddress();
        }
        return address;
    }

    @Override
    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = InetAddress.getByName(host);
    }

    @Override
    public int getBacklog() {
        return this.backlog;
    }

    @Override
    public void setBacklog(int backlog) {
        if (backlog <= 0) {
            backlog = 50;
        }
        this.backlog = backlog;
    }

    @Override
    public void setDiscoveryDisabled(boolean disable) {
        this.discoveryDisabled = disable;
    }

    @Override
    public boolean getDiscoveryDisabled() {
        return this.discoveryDisabled;
    }

    @Override
    public String getAutoDiscoveryAddress() {
        return this.adGroupAddress;
    }

    @Override
    public void setAutoDiscoveryAddress(String adAddress) {
        this.adGroupAddress = adAddress;
    }

    @Override
    public int getAutoDiscoveryGroup() {
        return this.adGroupPort;
    }

    @Override
    public void setAutoDiscoveryGroup(int adGroup) {
        this.adGroupPort = adGroup;
    }

    @Override
    public String getAutoDiscoveryBindAddress() {
        return this.discoveryBindAddress != null ? this.discoveryBindAddress.getHostAddress() : null;
    }

    @Override
    public void setAutoDiscoveryBindAddress(String address) throws UnknownHostException {
        this.discoveryBindAddress = InetAddress.getByName(address);
    }

    @Override
    public int getAutoDiscoveryTTL() {
        return this.autoDiscoveryTTL;
    }

    @Override
    public void setAutoDiscoveryTTL(int ttl) {
        this.autoDiscoveryTTL = ttl;
    }

    public void setJNPServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.jnpServerSocketFactoryName = factoryClassName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = loader.loadClass(this.jnpServerSocketFactoryName);
        this.jnpServerSocketFactory = (ServerSocketFactory)clazz.newInstance();
    }

    @Override
    public void setLookupPool(BasicThreadPoolMBean poolMBean) {
        this.lookupPool = poolMBean.getInstance();
    }

    protected void createService() throws Exception {
        Method[] methods;
        if (this.clusterPartition == null) {
            throw new IllegalStateException("HAPartition property must be set before starting HAJNDI service");
        }
        if (this.distributedTreeManager == null) {
            throw new IllegalStateException("DistributedTreeManager property must be set before starting HAJNDI service");
        }
        this.log.debug((Object)("Initializing HAJNDI server on partition: " + this.clusterPartition.getPartitionName()));
        this.theServer = new HAJNDI(this.clusterPartition, this.distributedTreeManager);
        HashMap<Long, Method> map = new HashMap<Long, Method>(13);
        for (Method method : methods = Naming.class.getMethods()) {
            Long hash = new Long(MarshalledInvocation.calculateHash((Method)method));
            map.put(hash, method);
        }
        this.marshalledInvocationMapping = Collections.unmodifiableMap(map);
        NamingContext.setHANamingServerForPartition((String)this.clusterPartition.getPartitionName(), (Naming)this.theServer);
    }

    protected void startService() throws Exception {
        this.log.debug((Object)"Obtaining the HAJNDI transport proxy");
        this.stub = this.getNamingProxy();
        this.distributedTreeManager.setHAStub(this.stub);
        if (this.port >= 0) {
            this.log.debug((Object)"Starting HAJNDI bootstrap listener");
            this.initBootstrapListener();
        }
        if (this.adGroupAddress != null && !this.discoveryDisabled) {
            try {
                this.autoDiscovery = new AutomaticDiscovery();
                this.autoDiscovery.start();
                this.lookupPool.run((Runnable)this.autoDiscovery);
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to start AutomaticDiscovery", (Throwable)e);
            }
        }
        this.log.debug((Object)"initializing HAJNDI");
        this.theServer.init();
    }

    protected void stopService() throws Exception {
        NamingContext.removeHANamingServerForPartition((String)this.clusterPartition.getPartitionName());
        ServerSocket s = this.bootstrapSocket;
        this.bootstrapSocket = null;
        if (s != null) {
            this.log.debug((Object)"Closing the HAJNDI bootstrap listener");
            s.close();
        }
        this.log.debug((Object)"Stopping the HAJNDI service");
        this.theServer.shutdown();
        this.log.debug((Object)"Stopping AutomaticDiscovery");
        if (this.autoDiscovery != null && !this.discoveryDisabled) {
            this.autoDiscovery.stop();
        }
    }

    protected void destroyService() throws Exception {
        this.log.debug((Object)"Destroying the HAJNDI service");
    }

    @Override
    public Object invoke(Invocation invocation) throws Exception {
        if (invocation instanceof MarshalledInvocation) {
            MarshalledInvocation mi = (MarshalledInvocation)invocation;
            mi.setMethodMap(this.marshalledInvocationMapping);
        }
        Method method = invocation.getMethod();
        Object[] args = invocation.getArguments();
        Object value = null;
        try {
            value = method.invoke((Object)this.theServer, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new UndeclaredThrowableException(t, method.toString());
        }
        return value;
    }

    protected void initBootstrapListener() {
        try {
            if (this.jnpServerSocketFactory == null) {
                this.jnpServerSocketFactory = ServerSocketFactory.getDefault();
            }
            this.bootstrapSocket = this.jnpServerSocketFactory.createServerSocket(this.port, this.backlog, this.bindAddress);
            if (this.port == 0) {
                this.port = this.bootstrapSocket.getLocalPort();
            }
            String msg = "Started HAJNDI bootstrap; jnpPort=" + this.port + ", backlog=" + this.backlog + ", bindAddress=" + this.bindAddress;
            this.log.info((Object)msg);
        }
        catch (IOException e) {
            this.log.error((Object)("Could not start HAJNDI bootstrap listener on port " + this.port), (Throwable)e);
        }
        if (this.lookupPool == null) {
            this.lookupPool = new BasicThreadPool("HANamingBootstrap Pool");
        }
        AcceptHandler handler = new AcceptHandler();
        this.lookupPool.run((Runnable)handler);
    }

    protected HAPartition findHAPartitionWithName(String name) {
        HAPartition result = null;
        QueryExp matchName = Query.match(Query.attr("Name"), Query.value("ClusterPartition"));
        QueryExp matchPartitionName = Query.match(Query.attr("PartitionName"), Query.value(name));
        QueryExp exp = Query.and(matchName, matchPartitionName);
        Set<ObjectInstance> mbeans = this.getServer().queryMBeans(null, exp);
        if (mbeans != null && mbeans.size() > 0) {
            Iterator<ObjectInstance> i$ = mbeans.iterator();
            while (i$.hasNext()) {
                ObjectInstance mbean;
                ObjectInstance inst = mbean = i$.next();
                try {
                    ClusterPartitionMBean cp = (ClusterPartitionMBean)MBeanProxyExt.create(ClusterPartitionMBean.class, (ObjectName)inst.getObjectName(), (MBeanServer)this.getServer());
                    result = cp.getHAPartition();
                    break;
                }
                catch (Exception e) {
                }
            }
        }
        return result;
    }

    protected Naming getNamingProxy() throws Exception {
        return (Naming)this.server.getAttribute(this.proxyFactory, "Proxy");
    }

    private class BootstrapRequestHandler
    implements Runnable {
        private Socket socket;

        BootstrapRequestHandler(Socket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                OutputStream os = this.socket.getOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(os);
                MarshalledObject<Naming> replyStub = new MarshalledObject<Naming>(DetachedHANamingService.this.stub);
                out.writeObject(replyStub);
                out.close();
            }
            catch (IOException ex) {
                DetachedHANamingService.this.log.debug((Object)("Error writing response to " + this.socket), (Throwable)ex);
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class AcceptHandler
    implements Runnable {
        AcceptHandler() {
        }

        public void run() {
            boolean trace = DetachedHANamingService.this.log.isTraceEnabled();
            while (DetachedHANamingService.this.bootstrapSocket != null) {
                Socket socket = null;
                try {
                    socket = DetachedHANamingService.this.bootstrapSocket.accept();
                    if (trace) {
                        DetachedHANamingService.this.log.trace((Object)("Accepted bootstrap client: " + socket));
                    }
                    BootstrapRequestHandler handler = new BootstrapRequestHandler(socket);
                    DetachedHANamingService.this.lookupPool.run((Runnable)handler);
                }
                catch (IOException e) {
                    if (DetachedHANamingService.this.bootstrapSocket == null) {
                        return;
                    }
                    DetachedHANamingService.this.log.error((Object)"Naming accept handler stopping", (Throwable)e);
                }
                catch (Throwable e) {
                    DetachedHANamingService.this.log.error((Object)"Unexpected exception during accept", e);
                }
            }
        }
    }

    private class DiscoveryRequestHandler
    implements Runnable {
        private Logger log;
        private MulticastSocket socket;
        private DatagramPacket packet;
        private byte[] ipAddress;

        DiscoveryRequestHandler(Logger log, DatagramPacket packet, MulticastSocket socket, byte[] ipAddress) {
            this.log = log;
            this.packet = packet;
            this.socket = socket;
            this.ipAddress = ipAddress;
        }

        public void run() {
            boolean trace = this.log.isTraceEnabled();
            if (trace) {
                this.log.trace((Object)"DiscoveryRequestHandler begin");
            }
            try {
                String name;
                int colon;
                String requestData = new String(this.packet.getData()).trim();
                if (trace) {
                    this.log.trace((Object)("RequestData: " + requestData));
                }
                if ((colon = requestData.indexOf(58)) > 0 && !(name = requestData.substring(colon + 1)).equals(DetachedHANamingService.this.clusterPartition.getPartitionName())) {
                    this.log.debug((Object)("Ignoring discovery request for partition: " + name));
                    if (trace) {
                        this.log.trace((Object)"DiscoveryRequestHandler end");
                    }
                    return;
                }
                DatagramPacket p = new DatagramPacket(this.ipAddress, this.ipAddress.length, this.packet.getAddress(), this.packet.getPort());
                if (trace) {
                    this.log.trace((Object)("Sending AutomaticDiscovery answer: " + new String(this.ipAddress) + " to " + this.packet.getAddress() + ":" + this.packet.getPort()));
                }
                this.socket.send(p);
                if (trace) {
                    this.log.trace((Object)"AutomaticDiscovery answer sent.");
                }
            }
            catch (IOException ex) {
                this.log.error((Object)"Error writing response", (Throwable)ex);
            }
            if (trace) {
                this.log.trace((Object)"DiscoveryRequestHandler end");
            }
        }
    }

    private class AutomaticDiscovery
    implements Runnable {
        private Logger log = Logger.getLogger(AutomaticDiscovery.class);
        private MulticastSocket socket = null;
        private byte[] ipAddress = null;
        private InetAddress group = null;
        private volatile boolean stopping = false;
        private volatile Thread receiverThread = null;
        private volatile boolean receiverStopped = true;

        public void start() throws Exception {
            this.stopping = false;
            if (DetachedHANamingService.this.discoveryBindAddress == null) {
                DetachedHANamingService.this.discoveryBindAddress = DetachedHANamingService.this.bindAddress;
            }
            this.socket = new MulticastSocket(DetachedHANamingService.this.adGroupPort);
            if (DetachedHANamingService.this.discoveryBindAddress != null && !DetachedHANamingService.this.discoveryBindAddress.isAnyLocalAddress()) {
                this.socket.setInterface(DetachedHANamingService.this.discoveryBindAddress);
            }
            this.socket.setTimeToLive(DetachedHANamingService.this.autoDiscoveryTTL);
            this.group = InetAddress.getByName(DetachedHANamingService.this.adGroupAddress);
            this.socket.joinGroup(this.group);
            String address = DetachedHANamingService.this.getBindAddress();
            if (address == null || address.equals("0.0.0.0")) {
                address = InetAddress.getLocalHost().getHostAddress();
            }
            this.ipAddress = (address + ":" + DetachedHANamingService.this.port).getBytes();
            this.log.info((Object)("Listening on " + this.socket.getInterface() + ":" + this.socket.getLocalPort() + ", group=" + DetachedHANamingService.this.adGroupAddress + ", HA-JNDI address=" + new String(this.ipAddress)));
        }

        public void stop() {
            try {
                this.stopping = true;
                if (this.receiverThread != null && this.receiverThread != Thread.currentThread() && !this.receiverThread.isInterrupted()) {
                    this.receiverThread.join(5L);
                    if (!this.receiverStopped) {
                        this.receiverThread.interrupt();
                    }
                }
                this.socket.leaveGroup(this.group);
                this.socket.close();
            }
            catch (Exception ex) {
                this.log.error((Object)"Stopping AutomaticDiscovery failed", (Throwable)ex);
            }
        }

        public void run() {
            boolean trace = this.log.isTraceEnabled();
            this.log.debug((Object)"Discovery request thread begin");
            this.receiverThread = Thread.currentThread();
            this.receiverStopped = false;
            while (!this.stopping) {
                try {
                    if (trace) {
                        this.log.trace((Object)"HA-JNDI AutomaticDiscovery waiting for queries...");
                    }
                    byte[] buf = new byte[256];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    this.socket.receive(packet);
                    if (trace) {
                        this.log.trace((Object)"HA-JNDI AutomaticDiscovery Packet received.");
                    }
                    DiscoveryRequestHandler handler = new DiscoveryRequestHandler(this.log, packet, this.socket, this.ipAddress);
                    DetachedHANamingService.this.lookupPool.run((Runnable)handler);
                    if (!trace) continue;
                    this.log.trace((Object)"Queued DiscoveryRequestHandler");
                }
                catch (Throwable t) {
                    if (this.stopping) continue;
                    this.log.warn((Object)"Ignored error while processing HAJNDI discovery request:", t);
                }
            }
            this.receiverStopped = true;
            this.log.debug((Object)"Discovery request thread end");
        }
    }
}

