/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.ResponseFilter;
import org.jboss.ha.framework.server.AsynchEventHandler;
import org.jboss.ha.framework.server.ClusterNodeImpl;
import org.jboss.ha.framework.server.ClusterPartitionMBean;
import org.jboss.ha.framework.server.DistributedReplicantManagerImpl;
import org.jboss.ha.framework.server.HAPartitionLocator;
import org.jboss.ha.framework.server.RspFilterAdapter;
import org.jboss.ha.framework.server.deployers.DefaultHAPartitionDependencyCreator;
import org.jboss.ha.framework.server.deployers.HAPartitionDependencyCreator;
import org.jboss.ha.framework.server.spi.HAPartitionCacheHandler;
import org.jboss.ha.framework.server.spi.ManagedDistributedState;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.invocation.MarshalledValueOutputStream;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigUtil;
import org.jboss.util.threadpool.ThreadPool;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelFactory;
import org.jgroups.ExtendedMembershipListener;
import org.jgroups.ExtendedMessageListener;
import org.jgroups.MembershipListener;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterPartition
extends ServiceMBeanSupport
implements ExtendedMembershipListener,
HAPartition,
AsynchEventHandler.AsynchEventProcessor,
ClusterPartitionMBean {
    public static final String DEFAULT_CACHE_CONFIG = "ha-partition";
    private static final byte EOF_VALUE = -1;
    private static final byte NULL_VALUE = 0;
    private static final byte SERIALIZABLE_VALUE = 1;
    private HAPartitionCacheHandler cacheHandler;
    private String cacheConfigName;
    private ChannelFactory channelFactory;
    private String stackName;
    private String partitionName = ServerConfigUtil.getDefaultPartitionName();
    private InetAddress nodeAddress = null;
    private long state_transfer_timeout = 60000L;
    private long method_call_timeout = 60000L;
    private ThreadPool threadPool;
    protected Map<String, Object> rpcHandlers = new ConcurrentHashMap<String, Object>();
    protected Map<String, HAPartition.HAPartitionStateTransfer> stateHandlers = new HashMap<String, HAPartition.HAPartitionStateTransfer>();
    protected boolean allowSyncListeners = false;
    protected ArrayList<HAPartition.HAMembershipListener> synchListeners = new ArrayList();
    protected ArrayList<HAPartition.HAMembershipListener> asynchListeners = new ArrayList();
    protected AsynchEventHandler asynchHandler;
    protected Vector<ClusterNode> members = null;
    protected Vector<Address> jgmembers = null;
    protected Map<String, WeakReference<ClassLoader>> clmap = new ConcurrentHashMap<String, WeakReference<ClassLoader>>();
    public Vector<String> history = new Vector();
    protected Vector<ClusterNode> otherMembers = null;
    protected Vector<Address> jgotherMembers = null;
    protected Address localJGAddress = null;
    protected String nodeName;
    protected ClusterNode me = null;
    protected Channel channel;
    protected DistributedReplicantManagerImpl replicantManager;
    protected DistributedState distributedState;
    protected Logger log = Logger.getLogger((String)HAPartition.class.getName());
    protected Logger clusterLifeCycleLog = Logger.getLogger((String)(HAPartition.class.getName() + ".lifecycle"));
    protected long currentViewId = -1L;
    protected boolean bindIntoJndi = true;
    private final ThreadGate flushBlockGate = new ThreadGate();
    private RpcDispatcher dispatcher = null;
    protected boolean isStateSet = false;
    protected Exception setStateException;
    protected Exception connectException;
    private final Object channelLock = new Object();
    private final MessageListenerAdapter messageListener = new MessageListenerAdapter();
    private HAPartitionDependencyCreator haPartitionDependencyCreator;
    private KernelControllerContext kernelControllerContext;

    private Channel createChannel() {
        ChannelFactory factory = this.getChannelFactory();
        if (factory == null) {
            throw new IllegalStateException("HAPartitionConfig has no JChannelFactory");
        }
        String stack = this.getChannelStackName();
        if (stack == null) {
            throw new IllegalStateException("HAPartitionConfig has no multiplexer stack");
        }
        try {
            return factory.createMultiplexerChannel(stack, this.getPartitionName());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failure creating multiplexed Channel", e);
        }
    }

    public ClusterPartition() {
        this.logHistory("Partition object created");
    }

    protected void createService() throws Exception {
        if (this.replicantManager == null) {
            throw new IllegalStateException("DistributedReplicantManager property must be set before creating ClusterPartition service");
        }
        this.setupLoggers(this.getPartitionName());
        this.replicantManager.createService();
        if (this.distributedState instanceof ManagedDistributedState) {
            ((ManagedDistributedState)this.distributedState).createService();
        }
        this.asynchHandler = new AsynchEventHandler(this, "AsynchViewChangeHandler");
        this.addCanonicalAlias();
        this.log.debug((Object)"done initializing partition");
    }

    protected void startService() throws Exception {
        this.logHistory("Starting partition");
        this.cacheHandler.acquireCache();
        this.channelFactory = this.cacheHandler.getCacheChannelFactory();
        this.stackName = this.cacheHandler.getChannelStackName();
        if (this.channel == null || !this.channel.isOpen()) {
            this.log.debug((Object)("Creating Channel for partition " + this.getPartitionName() + " using stack " + this.getChannelStackName()));
            this.channel = this.createChannel();
            this.channel.setOpt(5, (Object)Boolean.TRUE);
            this.channel.setOpt(6, (Object)Boolean.TRUE);
        }
        this.log.info((Object)("Initializing partition " + this.getPartitionName()));
        this.logHistory("Initializing partition " + this.getPartitionName());
        this.dispatcher = new RpcHandler(this.channel, null, null, new Object(), false);
        this.log.debug((Object)"setMembershipListener");
        this.dispatcher.setMembershipListener((MembershipListener)this);
        this.log.debug((Object)"setMessageListener");
        this.dispatcher.setMessageListener((MessageListener)this.messageListener);
        this.dispatcher.setRequestMarshaller((RpcDispatcher.Marshaller)new RequestMarshallerImpl());
        this.dispatcher.setResponseMarshaller((RpcDispatcher.Marshaller)new ResponseMarshallerImpl());
        this.connectException = null;
        CountDownLatch connectLatch = new CountDownLatch(1);
        if (this.threadPool == null) {
            this.channel.connect(this.getPartitionName());
            connectLatch.countDown();
        } else {
            ChannelConnectTask task = new ChannelConnectTask(connectLatch);
            this.threadPool.run((Runnable)task);
        }
        this.cacheHandler.startCache();
        try {
            connectLatch.await();
            if (this.connectException != null) {
                throw this.connectException;
            }
            this.log.debug((Object)"Get current members");
            this.waitForView();
            this.log.debug((Object)"get nodeName");
            this.localJGAddress = this.channel.getLocalAddress();
            this.me = new ClusterNodeImpl((IpAddress)this.localJGAddress);
            this.nodeName = this.me.getName();
            this.verifyNodeIsUnique();
            this.fetchState();
            this.replicantManager.startService();
            if (this.distributedState instanceof ManagedDistributedState) {
                ((ManagedDistributedState)this.distributedState).startService();
            }
            this.asynchHandler.start();
            HAPartitionLocator.getHAPartitionLocator().registerHAPartition((HAPartition)this);
            if (this.bindIntoJndi) {
                InitialContext ctx = new InitialContext();
                this.bind(HAPartitionLocator.getStandardJndiBinding((String)this.getPartitionName()), this, ClusterPartition.class, ctx);
                this.log.debug((Object)("Bound in JNDI under /HAPartition/" + this.getPartitionName()));
            }
        }
        catch (Throwable t) {
            this.log.debug((Object)("Caught exception after channel connected; closing channel -- " + t.getLocalizedMessage()));
            this.channel.close();
            this.channel = null;
            throw t instanceof Exception ? (Exception)t : new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopService() throws Exception {
        this.logHistory("Stopping partition");
        this.log.info((Object)("Stopping partition " + this.getPartitionName()));
        try {
            this.asynchHandler.stop();
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to stop asynchHandler", (Throwable)e);
        }
        if (this.distributedState instanceof ManagedDistributedState) {
            ((ManagedDistributedState)this.distributedState).stopService();
        }
        this.replicantManager.stopService();
        try {
            this.cacheHandler.releaseCache();
        }
        catch (Exception e) {
            this.log.error((Object)"cache release failed", (Throwable)e);
        }
        try {
            if (this.channel != null && this.channel.isConnected()) {
                this.channel.disconnect();
            }
        }
        catch (Exception e) {
            this.log.error((Object)"channel disconnection failed", (Throwable)e);
        }
        if (this.bindIntoJndi) {
            String boundName = HAPartitionLocator.getStandardJndiBinding((String)this.getPartitionName());
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                ctx.unbind(boundName);
            }
            catch (Exception e) {
                this.log.error((Object)"partition unbind operation failed", (Throwable)e);
            }
            finally {
                if (ctx != null) {
                    ctx.close();
                }
            }
            NonSerializableFactory.unbind((String)boundName);
        }
        HAPartitionLocator.getHAPartitionLocator().deregisterHAPartition((HAPartition)this);
        this.log.info((Object)("Partition " + this.getPartitionName() + " stopped."));
    }

    protected void destroyService() throws Exception {
        this.log.debug((Object)("Destroying HAPartition: " + this.getPartitionName()));
        this.removeCanonicalAlias();
        if (this.distributedState instanceof ManagedDistributedState) {
            ((ManagedDistributedState)this.distributedState).destroyService();
        }
        this.replicantManager.destroyService();
        try {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Closing channel failed", (Throwable)e);
        }
        this.log.info((Object)("Partition " + this.getPartitionName() + " destroyed."));
    }

    private void addCanonicalAlias() {
        if (this.kernelControllerContext != null) {
            KernelController kc = (KernelController)this.kernelControllerContext.getController();
            String aliasName = this.getHaPartitionDependencyCreator().getHAPartitionDependencyName(this.partitionName);
            try {
                kc.addAlias((Object)aliasName, this.kernelControllerContext.getName());
            }
            catch (Throwable t) {
                this.log.error((Object)("Failed adding alias " + aliasName + " to context " + this.kernelControllerContext.getName()), t);
            }
        }
    }

    private void removeCanonicalAlias() {
        if (this.kernelControllerContext != null) {
            KernelController kc = (KernelController)this.kernelControllerContext.getController();
            String aliasName = this.getHaPartitionDependencyCreator().getHAPartitionDependencyName(this.partitionName);
            Set aliases = this.kernelControllerContext.getAliases();
            if (aliases != null && aliases.contains(aliasName)) {
                try {
                    kc.removeAlias((Object)aliasName);
                }
                catch (Throwable t) {
                    this.log.error((Object)("Failed removing alias " + aliasName + " from context " + this.kernelControllerContext.getName()), t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchState() throws Exception {
        this.log.info((Object)("Fetching serviceState (will wait for " + this.getStateTransferTimeout() + " milliseconds):"));
        this.isStateSet = false;
        long start = System.currentTimeMillis();
        boolean rc = this.channel.getState(null, this.getStateTransferTimeout());
        if (rc) {
            Object object = this.channelLock;
            synchronized (object) {
                while (!this.isStateSet) {
                    if (this.setStateException != null) {
                        throw this.setStateException;
                    }
                    try {
                        this.channelLock.wait();
                    }
                    catch (InterruptedException iex) {}
                }
            }
            long stop = System.currentTimeMillis();
            this.log.info((Object)("serviceState was retrieved successfully (in " + (stop - start) + " milliseconds)"));
        } else {
            Vector<ClusterNode> vector = this.members;
            synchronized (vector) {
                while (this.members.size() == 0) {
                    this.log.debug((Object)"waiting on viewAccepted()");
                    try {
                        this.members.wait();
                    }
                    catch (InterruptedException iex) {}
                }
            }
            if (this.isCurrentNodeCoordinator()) {
                this.log.info((Object)"State could not be retrieved (we are the first member in group)");
            } else {
                throw new IllegalStateException("Initial serviceState transfer failed: Channel.getState() returned false");
            }
        }
    }

    private void getStateInternal(OutputStream stream) throws IOException {
        MarshalledValueOutputStream mvos = null;
        for (Map.Entry<String, HAPartition.HAPartitionStateTransfer> entry : this.stateHandlers.entrySet()) {
            HAPartition.HAPartitionStateTransfer subscriber = entry.getValue();
            this.log.debug((Object)("getState for " + entry.getKey()));
            Serializable state = subscriber.getCurrentState();
            if (state == null) continue;
            if (mvos == null) {
                stream.write(1);
                mvos = new MarshalledValueOutputStream(stream);
            }
            mvos.writeObject((Object)entry.getKey());
            mvos.writeObject((Object)state);
        }
        if (mvos == null) {
            stream.write(0);
        } else {
            mvos.writeObject((Object)new StateStreamEnd());
            mvos.flush();
            mvos.close();
        }
    }

    private void setStateInternal(InputStream stream) throws IOException, ClassNotFoundException {
        Object obj;
        byte type = (byte)stream.read();
        if (type == -1) {
            this.log.debug((Object)"serviceState stream is empty");
            return;
        }
        if (type == 0) {
            this.log.debug((Object)"serviceState is null");
            return;
        }
        Runtime rt = Runtime.getRuntime();
        long used_mem_before = rt.totalMemory() - rt.freeMemory();
        MarshalledValueInputStream mvis = new MarshalledValueInputStream(stream);
        while (!((obj = mvis.readObject()) instanceof StateStreamEnd)) {
            String key = (String)obj;
            this.log.debug((Object)("setState for " + key));
            Object someState = mvis.readObject();
            HAPartition.HAPartitionStateTransfer subscriber = this.stateHandlers.get(key);
            if (subscriber != null) {
                try {
                    subscriber.setCurrentState((Serializable)someState);
                }
                catch (Exception e) {
                    if ("DistributedReplicantManager".equals(key)) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    this.log.error((Object)("Caught exception setting serviceState to " + subscriber), (Throwable)e);
                }
                continue;
            }
            this.log.debug((Object)("There is no stateHandler for: " + key));
        }
        try {
            stream.close();
        }
        catch (Exception e) {
            this.log.error((Object)"Caught exception closing serviceState stream", (Throwable)e);
        }
        long used_mem_after = rt.totalMemory() - rt.freeMemory();
        this.log.debug((Object)("received serviceState; expanded memory by " + (used_mem_after - used_mem_before) + " bytes (used memory before: " + used_mem_before + ", used memory after: " + used_mem_after + ")"));
    }

    private void recordSetStateFailure(Throwable t) {
        this.log.error((Object)"failed setting serviceState", t);
        this.setStateException = t instanceof Exception ? (Exception)t : new Exception(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChannelLock() {
        Object object = this.channelLock;
        synchronized (object) {
            this.channelLock.notifyAll();
        }
    }

    public void suspect(Address suspected_mbr) {
        this.logHistory("Node suspected: " + (suspected_mbr == null ? "null" : suspected_mbr.toString()));
        if (this.isCurrentNodeCoordinator()) {
            this.clusterLifeCycleLog.info((Object)("Suspected member: " + suspected_mbr));
        } else {
            this.log.info((Object)("Suspected member: " + suspected_mbr));
        }
    }

    public void block() {
        this.flushBlockGate.close();
        this.log.debug((Object)("Block processed at " + this.me));
    }

    public void unblock() {
        this.flushBlockGate.open();
        this.log.debug((Object)("Unblock processed at " + this.me));
    }

    public void viewAccepted(View newView) {
        try {
            this.currentViewId = newView.getVid().getId();
            this.jgotherMembers = (Vector)newView.getMembers().clone();
            this.jgotherMembers.remove(this.channel.getLocalAddress());
            this.otherMembers = this.translateAddresses(this.jgotherMembers);
            Vector<ClusterNode> translatedNewView = this.translateAddresses((Vector)newView.getMembers().clone());
            this.logHistory("New view: " + translatedNewView + " with viewId: " + this.currentViewId + " (old view: " + this.members + " )");
            Vector<ClusterNode> oldMembers = this.members;
            Vector newjgMembers = (Vector)newView.getMembers().clone();
            Vector<ClusterNode> newMembers = this.translateAddresses(newjgMembers);
            this.members = newMembers;
            this.jgmembers = newjgMembers;
            if (oldMembers == null) {
                this.log.debug((Object)("ViewAccepted: initial members set for partition " + this.getPartitionName() + ": " + this.currentViewId + " (" + this.members + ")"));
                this.log.info((Object)("Number of cluster members: " + this.members.size()));
                for (int m = 0; m > this.members.size(); ++m) {
                    ClusterNode node = this.members.get(m);
                    this.log.debug((Object)node);
                }
                this.log.info((Object)("Other members: " + this.otherMembers.size()));
                this.notifyChannelLock();
                return;
            }
            int difference = newMembers.size() - oldMembers.size();
            if (this.isCurrentNodeCoordinator()) {
                this.clusterLifeCycleLog.info((Object)("New cluster view for partition " + this.getPartitionName() + " (id: " + this.currentViewId + ", delta: " + difference + ") : " + this.members));
            } else {
                this.log.info((Object)("New cluster view for partition " + this.getPartitionName() + ": " + this.currentViewId + " (" + this.members + " delta: " + difference + ")"));
            }
            ViewChangeEvent event = new ViewChangeEvent();
            event.viewId = this.currentViewId;
            event.allMembers = translatedNewView;
            event.deadMembers = this.getDeadMembers(oldMembers, event.allMembers);
            event.newMembers = this.getNewMembers(oldMembers, event.allMembers);
            event.originatingGroups = null;
            if (newView instanceof MergeView) {
                MergeView mergeView = (MergeView)newView;
                event.originatingGroups = mergeView.getSubgroups();
            }
            this.log.debug((Object)("membership changed from " + oldMembers.size() + " to " + event.allMembers.size()));
            this.asynchHandler.queueEvent(event);
            if (this.allowSyncListeners) {
                this.notifyListeners(this.synchListeners, event.viewId, event.allMembers, event.deadMembers, event.newMembers, event.originatingGroups);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"ViewAccepted failed", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForView() throws Exception {
        Object object = this.channelLock;
        synchronized (object) {
            if (this.members == null) {
                if (this.connectException != null) {
                    throw this.connectException;
                }
                try {
                    this.channelLock.wait(this.getMethodCallTimeout());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.connectException != null) {
                    throw this.connectException;
                }
                if (this.members == null) {
                    throw new IllegalStateException("No view received from Channel");
                }
            }
        }
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String newName) {
        this.partitionName = newName;
    }

    @Override
    public DistributedReplicantManager getDistributedReplicantManager() {
        return this.replicantManager;
    }

    @Override
    public DistributedState getDistributedStateService() {
        return this.distributedState;
    }

    public long getCurrentViewId() {
        return this.currentViewId;
    }

    @Override
    public Vector<String> getCurrentView() {
        Vector<String> result = new Vector<String>(this.members.size());
        for (ClusterNode member : this.members) {
            result.add(member.getName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterNode[] getClusterNodes() {
        Vector<ClusterNode> vector = this.members;
        synchronized (vector) {
            return this.members.toArray(new ClusterNode[this.members.size()]);
        }
    }

    public ClusterNode getClusterNode() {
        return this.me;
    }

    public boolean isCurrentNodeCoordinator() {
        if (this.members == null || this.members.size() == 0 || this.me == null) {
            return false;
        }
        return this.members.elementAt(0).equals(this.me);
    }

    public void registerRPCHandler(String objName, Object subscriber) {
        this.rpcHandlers.put(objName, subscriber);
    }

    public void registerRPCHandler(String objName, Object subscriber, ClassLoader classloader) {
        this.registerRPCHandler(objName, subscriber);
        this.clmap.put(objName, new WeakReference<ClassLoader>(classloader));
    }

    public void unregisterRPCHandler(String objName, Object subscriber) {
        this.rpcHandlers.remove(objName);
        this.clmap.remove(objName);
    }

    public ArrayList callMethodOnCluster(String objName, String methodName, Object[] args, Class[] types, boolean excludeSelf) throws Exception {
        return this.callMethodOnCluster(objName, methodName, args, types, excludeSelf, null);
    }

    public ArrayList callMethodOnCluster(String objName, String methodName, Object[] args, Class[] types, boolean excludeSelf, ResponseFilter filter) throws Exception {
        return this.callMethodOnCluster(objName, methodName, args, types, excludeSelf, this.getMethodCallTimeout(), filter);
    }

    public ArrayList callMethodOnCluster(String objName, String methodName, Object[] args, Class[] types, boolean excludeSelf, long methodTimeout, ResponseFilter filter) throws Exception {
        RspFilterAdapter rspFilter;
        RspList rsp = null;
        boolean trace = this.log.isTraceEnabled();
        MethodCall m = new MethodCall(objName + "." + methodName, args, types);
        RspFilterAdapter rspFilterAdapter = rspFilter = filter == null ? null : new RspFilterAdapter(filter);
        if (this.channel.flushSupported()) {
            this.flushBlockGate.await(this.getStateTransferTimeout());
        }
        if (excludeSelf) {
            if (trace) {
                this.log.trace((Object)("callMethodOnCluster(true), objName=" + objName + ", methodName=" + methodName + ", members=" + this.jgotherMembers));
            }
            rsp = this.dispatcher.callRemoteMethods(this.jgotherMembers, m, 2, methodTimeout, false, false, (RspFilter)rspFilter);
        } else {
            if (trace) {
                this.log.trace((Object)("callMethodOnCluster(false), objName=" + objName + ", methodName=" + methodName + ", members=" + this.members));
            }
            rsp = this.dispatcher.callRemoteMethods(null, m, 2, methodTimeout, false, false, (RspFilter)rspFilter);
        }
        return this.processResponseList(rsp, trace);
    }

    public ArrayList callMethodOnCoordinatorNode(String objName, String methodName, Object[] args, Class[] types, boolean excludeSelf) throws Exception {
        return this.callMethodOnCoordinatorNode(objName, methodName, args, types, excludeSelf, this.getMethodCallTimeout());
    }

    public ArrayList callMethodOnCoordinatorNode(String objName, String methodName, Object[] args, Class[] types, boolean excludeSelf, long methodTimeout) throws Exception {
        boolean trace = this.log.isTraceEnabled();
        MethodCall m = new MethodCall(objName + "." + methodName, args, types);
        if (trace) {
            this.log.trace((Object)("callMethodOnCoordinatorNode(false), objName=" + objName + ", methodName=" + methodName));
        }
        Vector<Address> coordinatorOnly = new Vector<Address>();
        if (!this.isCurrentNodeCoordinator() || !excludeSelf) {
            coordinatorOnly.addElement(this.jgmembers.elementAt(0));
        }
        RspList rsp = this.dispatcher.callRemoteMethods(coordinatorOnly, m, 2, methodTimeout);
        return this.processResponseList(rsp, trace);
    }

    public Object callMethodOnNode(String serviceName, String methodName, Object[] args, Class[] types, long methodTimeout, ClusterNode targetNode) throws Throwable {
        Object rc;
        if (!(targetNode instanceof ClusterNodeImpl)) {
            throw new IllegalArgumentException("targetNode " + targetNode + " is not an instance of " + ClusterNodeImpl.class + " -- only targetNodes provided by this HAPartition should be used");
        }
        boolean trace = this.log.isTraceEnabled();
        MethodCall m = new MethodCall(serviceName + "." + methodName, args, types);
        if (trace) {
            this.log.trace((Object)("callMethodOnNode( objName=" + serviceName + ", methodName=" + methodName));
        }
        if ((rc = this.dispatcher.callRemoteMethod((Address)((ClusterNodeImpl)targetNode).getOriginalJGAddress(), m, 1, methodTimeout)) != null) {
            Object item = rc;
            if (item instanceof Rsp) {
                Rsp response = (Rsp)item;
                boolean wasReceived = response.wasReceived();
                if (wasReceived) {
                    item = response.getValue();
                    if (!(item instanceof NoHandlerForRPC)) {
                        rc = item;
                    }
                } else if (trace) {
                    this.log.trace((Object)("Ignoring non-received response: " + response));
                }
            } else if (!(item instanceof NoHandlerForRPC)) {
                rc = item;
            } else if (trace) {
                this.log.trace((Object)"Ignoring NoHandlerForRPC");
            }
        }
        return rc;
    }

    public void callAsyncMethodOnNode(String serviceName, String methodName, Object[] args, Class[] types, long methodTimeout, ClusterNode targetNode) throws Throwable {
        if (!(targetNode instanceof ClusterNodeImpl)) {
            throw new IllegalArgumentException("targetNode " + targetNode + " is not an instance of " + ClusterNodeImpl.class + " -- only targetNodes provided by this HAPartition should be used");
        }
        boolean trace = this.log.isTraceEnabled();
        MethodCall m = new MethodCall(serviceName + "." + methodName, args, types);
        if (trace) {
            this.log.trace((Object)("callAsyncMethodOnNode( objName=" + serviceName + ", methodName=" + methodName));
        }
        this.dispatcher.callRemoteMethod((Address)((ClusterNodeImpl)targetNode).getOriginalJGAddress(), m, 6, methodTimeout);
    }

    private ArrayList processResponseList(RspList rsp, boolean trace) {
        ArrayList<Rsp> rtn = new ArrayList<Rsp>();
        if (rsp != null) {
            for (Object item : rsp.values()) {
                if (item instanceof Rsp) {
                    Rsp response = item;
                    boolean wasReceived = response.wasReceived();
                    if (wasReceived) {
                        item = response.getValue();
                        if (item instanceof NoHandlerForRPC) continue;
                        rtn.add((Rsp)item);
                        continue;
                    }
                    if (!trace) continue;
                    this.log.trace((Object)("Ignoring non-received response: " + response));
                    continue;
                }
                if (!(item instanceof NoHandlerForRPC)) {
                    rtn.add((Rsp)item);
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)"Ignoring NoHandlerForRPC");
            }
        }
        return rtn;
    }

    public void callAsynchMethodOnCluster(String objName, String methodName, Object[] args, Class[] types, boolean excludeSelf) throws Exception {
        boolean trace = this.log.isTraceEnabled();
        MethodCall m = new MethodCall(objName + "." + methodName, args, types);
        if (this.channel.flushSupported()) {
            this.flushBlockGate.await(this.getStateTransferTimeout());
        }
        if (excludeSelf) {
            if (trace) {
                this.log.trace((Object)("callAsynchMethodOnCluster(true), objName=" + objName + ", methodName=" + methodName + ", members=" + this.jgotherMembers));
            }
            this.dispatcher.callRemoteMethods(this.jgotherMembers, m, 6, this.getMethodCallTimeout());
        } else {
            if (trace) {
                this.log.trace((Object)("callAsynchMethodOnCluster(false), objName=" + objName + ", methodName=" + methodName + ", members=" + this.members));
            }
            this.dispatcher.callRemoteMethods(null, m, 6, this.getMethodCallTimeout());
        }
    }

    public void subscribeToStateTransferEvents(String objectName, HAPartition.HAPartitionStateTransfer subscriber) {
        this.stateHandlers.put(objectName, subscriber);
    }

    public void unsubscribeFromStateTransferEvents(String objectName, HAPartition.HAPartitionStateTransfer subscriber) {
        this.stateHandlers.remove(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMembershipListener(HAPartition.HAMembershipListener listener) {
        boolean isAsynch;
        boolean bl = isAsynch = !this.allowSyncListeners || listener instanceof HAPartition.AsynchHAMembershipListener || listener instanceof HAPartition.AsynchHAMembershipExtendedListener;
        if (isAsynch) {
            ArrayList<HAPartition.HAMembershipListener> arrayList = this.asynchListeners;
            synchronized (arrayList) {
                this.asynchListeners.add(listener);
            }
        }
        ArrayList<HAPartition.HAMembershipListener> arrayList = this.synchListeners;
        synchronized (arrayList) {
            this.synchListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMembershipListener(HAPartition.HAMembershipListener listener) {
        boolean isAsynch;
        boolean bl = isAsynch = !this.allowSyncListeners || listener instanceof HAPartition.AsynchHAMembershipListener || listener instanceof HAPartition.AsynchHAMembershipExtendedListener;
        if (isAsynch) {
            ArrayList<HAPartition.HAMembershipListener> arrayList = this.asynchListeners;
            synchronized (arrayList) {
                this.asynchListeners.remove(listener);
            }
        }
        ArrayList<HAPartition.HAMembershipListener> arrayList = this.synchListeners;
        synchronized (arrayList) {
            this.synchListeners.remove(listener);
        }
    }

    @Override
    public boolean getAllowSynchronousMembershipNotifications() {
        return this.allowSyncListeners;
    }

    @Override
    public void setAllowSynchronousMembershipNotifications(boolean allowSync) {
        this.allowSyncListeners = allowSync;
    }

    @Override
    public void processEvent(Object event) {
        ViewChangeEvent vce = (ViewChangeEvent)event;
        this.notifyListeners(this.asynchListeners, vce.viewId, vce.allMembers, vce.deadMembers, vce.newMembers, vce.originatingGroups);
    }

    public void setDistributedStateImpl(DistributedState distributedState) {
        this.distributedState = distributedState;
    }

    public void setDistributedReplicantManagerImpl(DistributedReplicantManagerImpl drm) {
        if (this.replicantManager != null && this.replicantManager != drm) {
            throw new IllegalStateException("DistributedReplicantManager already set");
        }
        this.replicantManager = drm;
        if (this.replicantManager != null) {
            this.replicantManager.setHAPartition(this);
        }
    }

    protected void verifyNodeIsUnique() throws IllegalStateException {
        ClusterNodeImpl matched = null;
        for (ClusterNode member : this.getClusterNodes()) {
            if (!member.equals(this.me)) continue;
            if (matched == null) {
                matched = (ClusterNodeImpl)member;
                continue;
            }
            ClusterNodeImpl other = matched;
            if (other.getOriginalJGAddress().equals((Object)((ClusterNodeImpl)this.me).getOriginalJGAddress())) {
                other = (ClusterNodeImpl)member;
            }
            throw new IllegalStateException("Found member " + other + " in current view that duplicates us (" + this.me + "). This" + " node cannot join partition until duplicate member has" + " been removed");
        }
    }

    protected void bind(String jndiName, Object who, Class classType, Context ctx) throws Exception {
        NonSerializableFactory.bind((String)jndiName, (Object)who);
        Name n = ctx.getNameParser("").parse(jndiName);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                this.log.debug((Object)("creating Subcontext " + ctxName));
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        StringRefAddr addr = new StringRefAddr("nns", jndiName);
        Reference ref = new Reference(classType.getName(), addr, NonSerializableFactory.class.getName(), null);
        ctx.rebind(n.get(0), (Object)ref);
    }

    protected Vector<ClusterNode> getDeadMembers(Vector<ClusterNode> oldMembers, Vector<ClusterNode> newMembers) {
        if (oldMembers == null) {
            oldMembers = new Vector();
        }
        if (newMembers == null) {
            newMembers = new Vector();
        }
        Vector dead = (Vector)oldMembers.clone();
        dead.removeAll(newMembers);
        this.log.debug((Object)("dead members: " + dead));
        return dead;
    }

    protected Vector<ClusterNode> getNewMembers(Vector<ClusterNode> oldMembers, Vector<ClusterNode> allMembers) {
        if (oldMembers == null) {
            oldMembers = new Vector();
        }
        if (allMembers == null) {
            allMembers = new Vector();
        }
        Vector newMembers = (Vector)allMembers.clone();
        newMembers.removeAll(oldMembers);
        return newMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(ArrayList<HAPartition.HAMembershipListener> theListeners, long viewID, Vector<ClusterNode> allMembers, Vector<ClusterNode> deadMembers, Vector<ClusterNode> newMembers, Vector<View> originatingGroups) {
        this.log.debug((Object)("Begin notifyListeners, viewID: " + viewID));
        ArrayList arrayList = theListeners;
        synchronized (arrayList) {
            theListeners = (ArrayList)theListeners.clone();
        }
        for (int i = 0; i < theListeners.size(); ++i) {
            HAPartition.HAMembershipListener aListener = null;
            try {
                aListener = (HAPartition.HAMembershipListener)theListeners.get(i);
                if (originatingGroups != null && aListener instanceof HAPartition.HAMembershipExtendedListener) {
                    HAPartition.HAMembershipExtendedListener exListener = (HAPartition.HAMembershipExtendedListener)aListener;
                    exListener.membershipChangedDuringMerge(deadMembers, newMembers, allMembers, originatingGroups);
                    continue;
                }
                aListener.membershipChanged(deadMembers, newMembers, allMembers);
                continue;
            }
            catch (Throwable e) {
                this.log.warn((Object)("HAMembershipListener callback failure: " + aListener), e);
            }
        }
        this.log.debug((Object)("End notifyListeners, viewID: " + viewID));
    }

    public void setBindIntoJndi(boolean bind) {
        this.bindIntoJndi = bind;
    }

    public boolean getBindIntoJndi() {
        return this.bindIntoJndi;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public synchronized HAPartitionDependencyCreator getHaPartitionDependencyCreator() {
        if (this.haPartitionDependencyCreator == null) {
            this.haPartitionDependencyCreator = DefaultHAPartitionDependencyCreator.INSTANCE;
        }
        return this.haPartitionDependencyCreator;
    }

    public synchronized void setHaPartitionDependencyCreator(HAPartitionDependencyCreator haPartitionDependencyCreator) {
        this.haPartitionDependencyCreator = haPartitionDependencyCreator;
    }

    protected Vector<ClusterNode> translateAddresses(Vector<Address> addresses) {
        if (addresses == null) {
            return null;
        }
        Vector<ClusterNode> result = new Vector<ClusterNode>(addresses.size());
        for (Address address : addresses) {
            result.add(new ClusterNodeImpl((IpAddress)address));
        }
        return result;
    }

    public void logHistory(String message) {
        try {
            this.history.add(new SimpleDateFormat().format(new Date()) + " : " + message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String showHistory() {
        StringBuffer buff = new StringBuffer();
        Vector<String> data = new Vector<String>(this.history);
        for (String info : data) {
            buff.append(info).append("\n");
        }
        return buff.toString();
    }

    @Override
    public String showHistoryAsXML() {
        StringBuffer buff = new StringBuffer();
        buff.append("<events>\n");
        Vector<String> data = new Vector<String>(this.history);
        Iterator<String> row = data.iterator();
        while (row.hasNext()) {
            buff.append("   <event>\n      ");
            String info = row.next();
            buff.append(info);
            buff.append("\n   </event>\n");
        }
        buff.append("</events>\n");
        return buff.toString();
    }

    @Override
    @Deprecated
    public boolean getDeadlockDetection() {
        return false;
    }

    @Deprecated
    public void setDeadlockDetection(boolean doit) {
        this.log.warn((Object)"Property deadlockDetection has been deprecated; setting it has no effect");
    }

    @Override
    public HAPartition getHAPartition() {
        return this;
    }

    @Override
    public String getJGroupsVersion() {
        return "2.6.3.GA( $Id: Version.java,v 1.59.2.6 2008/06/23 11:56:10 belaban Exp $)";
    }

    @Override
    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public HAPartitionCacheHandler getCacheHandler() {
        return this.cacheHandler;
    }

    public void setCacheHandler(HAPartitionCacheHandler cacheHandler) {
        this.cacheHandler = cacheHandler;
        this.cacheConfigName = cacheHandler == null ? null : cacheHandler.getCacheConfigName();
    }

    @Override
    public String getCacheConfigName() {
        return this.cacheConfigName;
    }

    @Override
    public String getChannelStackName() {
        return this.stackName;
    }

    @Override
    public InetAddress getNodeAddress() {
        return this.nodeAddress;
    }

    public void setNodeAddress(InetAddress address) {
        this.nodeAddress = address;
    }

    @Override
    public long getStateTransferTimeout() {
        return this.state_transfer_timeout;
    }

    @Override
    public void setStateTransferTimeout(long timeout) {
        this.state_transfer_timeout = timeout;
    }

    @Override
    public long getMethodCallTimeout() {
        return this.method_call_timeout;
    }

    @Override
    public void setMethodCallTimeout(long timeout) {
        this.method_call_timeout = timeout;
    }

    public void setKernelControllerContext(KernelControllerContext controllerContext) throws Exception {
        super.setKernelControllerContext(controllerContext);
        this.kernelControllerContext = controllerContext;
    }

    public void unsetKernelControllerContext(KernelControllerContext controllerContext) throws Exception {
        super.unsetKernelControllerContext(controllerContext);
        this.kernelControllerContext = null;
    }

    protected Object objectFromByteBufferInternal(byte[] buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        MarshalledValueInputStream mvis = new MarshalledValueInputStream((InputStream)bais);
        return mvis.readObject();
    }

    protected byte[] objectToByteBufferInternal(Object obj) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MarshalledValueOutputStream mvos = new MarshalledValueOutputStream((OutputStream)baos);
        mvos.writeObject(obj);
        mvos.flush();
        return baos.toByteArray();
    }

    protected Object objectFromByteBufferResponseInternal(byte[] buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        if (buffer[0] == 0) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        bais.read();
        MarshalledValueInputStream mvis = new MarshalledValueInputStream((InputStream)bais);
        return mvis.readObject();
    }

    protected byte[] objectToByteBufferResponseInternal(Object obj) throws Exception {
        if (obj == null) {
            return new byte[]{0};
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(1);
        MarshalledValueOutputStream mvos = new MarshalledValueOutputStream((OutputStream)baos);
        mvos.writeObject(obj);
        mvos.flush();
        return baos.toByteArray();
    }

    private void setupLoggers(String partitionName) {
        if (partitionName == null) {
            this.log = Logger.getLogger((String)HAPartition.class.getName());
            this.clusterLifeCycleLog = Logger.getLogger((String)(HAPartition.class.getName() + ".lifecycle"));
        } else {
            this.log = Logger.getLogger((String)(HAPartition.class.getName() + "." + partitionName));
            this.clusterLifeCycleLog = Logger.getLogger((String)(HAPartition.class.getName() + ".lifecycle." + partitionName));
        }
    }

    private static class ThreadGate {
        private boolean isOpen;
        private int generation;

        private ThreadGate() {
        }

        public synchronized void close() {
            this.isOpen = false;
        }

        public synchronized void open() {
            ++this.generation;
            this.isOpen = true;
            this.notifyAll();
        }

        public synchronized void await() throws InterruptedException {
            int arrivalGeneration = this.generation;
            while (!this.isOpen && arrivalGeneration == this.generation) {
                this.wait();
            }
        }

        public synchronized void await(long timeout) throws InterruptedException {
            int arrivalGeneration = this.generation;
            while (!this.isOpen && arrivalGeneration == this.generation) {
                this.wait(timeout);
            }
        }
    }

    private class RpcHandler
    extends RpcDispatcher {
        private RpcHandler(Channel channel, MessageListener l, MembershipListener l2, Object server_obj, boolean deadlock_detection) {
            super(channel, l, l2, server_obj, deadlock_detection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public Object handle(Message req) {
            body = null;
            retval = null;
            handler = null;
            trace = this.log.isTraceEnabled();
            overrideCL = false;
            previousCL = null;
            service = null;
            request_bytes = null;
            if (trace) {
                this.log.trace((Object)("Partition " + ClusterPartition.this.getPartitionName() + " received msg"));
            }
            if (req == null || req.getBuffer() == null) {
                this.log.warn((Object)("Partition " + ClusterPartition.this.getPartitionName() + " message or message buffer is null!"));
                return null;
            }
            try {
                wrapper = ClusterPartition.this.objectFromByteBufferInternal(req.getBuffer());
                if (wrapper == null || !(wrapper instanceof Object[])) {
                    this.log.warn((Object)("Partition " + ClusterPartition.this.getPartitionName() + " message wrapper does not contain Object[] object!"));
                    return null;
                }
                temp = (Object[])wrapper;
                service = (String)temp[0];
                request_bytes = (byte[])temp[1];
                handler = ClusterPartition.this.rpcHandlers.get(service);
                if (handler == null) {
                    if (trace) {
                        this.log.trace((Object)("Partition " + ClusterPartition.this.getPartitionName() + " no rpc handler registered under service " + service));
                    }
                    return new NoHandlerForRPC();
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Partition " + ClusterPartition.this.getPartitionName() + " failed unserializing message buffer (msg=" + req + ")"), (Throwable)e);
                return null;
            }
            try {
                weak = ClusterPartition.this.clmap.get(service);
                if (weak != null) {
                    if (trace) {
                        this.log.trace((Object)("overriding Thread ContextClassLoader for RPC service " + service));
                    }
                    previousCL = Thread.currentThread().getContextClassLoader();
                    loader = (ClassLoader)weak.get();
                    overrideCL = true;
                    Thread.currentThread().setContextClassLoader(loader);
                }
                body = ClusterPartition.this.objectFromByteBufferInternal(request_bytes);
                ** if (!overrideCL) goto lbl-1000
            }
            catch (Exception e) {
                block23: {
                    try {
                        this.log.warn((Object)("Partition " + ClusterPartition.this.getPartitionName() + " failed extracting message body from request bytes"), (Throwable)e);
                        loader = null;
                        if (!overrideCL) break block23;
                    }
                    catch (Throwable var12_14) {
                        if (overrideCL) {
                            this.log.trace((Object)"resetting Thread ContextClassLoader");
                            Thread.currentThread().setContextClassLoader(previousCL);
                        }
                        throw var12_14;
                    }
                    this.log.trace((Object)"resetting Thread ContextClassLoader");
                    Thread.currentThread().setContextClassLoader(previousCL);
                }
                return loader;
            }
lbl-1000:
            // 1 sources

            {
                this.log.trace((Object)"resetting Thread ContextClassLoader");
                Thread.currentThread().setContextClassLoader(previousCL);
            }
lbl-1000:
            // 2 sources

            {
            }
            if (body == null || !(body instanceof MethodCall)) {
                this.log.warn((Object)("Partition " + ClusterPartition.this.getPartitionName() + " message does not contain a MethodCall object!"));
                return null;
            }
            method_call = (MethodCall)body;
            methodName = method_call.getName();
            if (trace) {
                this.log.trace((Object)("full methodName: " + methodName));
            }
            idx = methodName.lastIndexOf(46);
            handlerName = methodName.substring(0, idx);
            newMethodName = methodName.substring(idx + 1);
            if (trace) {
                this.log.trace((Object)("handlerName: " + handlerName + " methodName: " + newMethodName));
                this.log.trace((Object)("Handle: " + methodName));
            }
            method_call.setName(newMethodName);
            try {
                retval = method_call.invoke(handler);
                if (overrideCL) {
                    retbytes = ClusterPartition.this.objectToByteBufferResponseInternal(retval);
                    retval = new HAServiceResponse(handlerName, retbytes);
                }
                if (trace) {
                    this.log.trace((Object)("rpc call return value: " + retval));
                }
            }
            catch (Throwable t) {
                if (trace) {
                    this.log.trace((Object)("Partition " + ClusterPartition.this.getPartitionName() + " rpc call threw exception"), t);
                }
                retval = t;
            }
            return retval;
        }
    }

    private class ResponseMarshallerImpl
    implements RpcDispatcher.Marshaller {
        private ResponseMarshallerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object objectFromByteBuffer(byte[] buf) throws Exception {
            boolean trace = ClusterPartition.this.log.isTraceEnabled();
            Object retval = ClusterPartition.this.objectFromByteBufferResponseInternal(buf);
            if (!(retval instanceof HAServiceResponse)) {
                return retval;
            }
            String serviceName = ((HAServiceResponse)retval).getServiceName();
            byte[] payload = ((HAServiceResponse)retval).getPayload();
            ClassLoader previousCL = null;
            boolean overrideCL = false;
            try {
                WeakReference<ClassLoader> weak = ClusterPartition.this.clmap.get(serviceName);
                if (weak != null) {
                    previousCL = Thread.currentThread().getContextClassLoader();
                    ClassLoader loader = (ClassLoader)weak.get();
                    if (trace) {
                        ClusterPartition.this.log.trace((Object)("overriding response Thread ContextClassLoader for service " + serviceName));
                    }
                    overrideCL = true;
                    Thread.currentThread().setContextClassLoader(loader);
                }
                Object object = retval = ClusterPartition.this.objectFromByteBufferResponseInternal(payload);
                return object;
            }
            finally {
                if (overrideCL) {
                    ClusterPartition.this.log.trace((Object)"resetting response classloader");
                    Thread.currentThread().setContextClassLoader(previousCL);
                }
            }
        }

        public byte[] objectToByteBuffer(Object obj) throws Exception {
            return ClusterPartition.this.objectToByteBufferResponseInternal(obj);
        }
    }

    private class RequestMarshallerImpl
    implements RpcDispatcher.Marshaller {
        private RequestMarshallerImpl() {
        }

        public Object objectFromByteBuffer(byte[] buf) throws Exception {
            return ClusterPartition.this.objectFromByteBufferInternal(buf);
        }

        public byte[] objectToByteBuffer(Object obj) throws Exception {
            if (obj instanceof MethodCall) {
                String name = ((MethodCall)obj).getName();
                int idx = name.lastIndexOf(46);
                String serviceName = name.substring(0, idx);
                return ClusterPartition.this.objectToByteBufferInternal(new Object[]{serviceName, ClusterPartition.this.objectToByteBufferInternal(obj)});
            }
            return ClusterPartition.this.objectToByteBufferInternal(obj);
        }
    }

    private static class ViewChangeEvent {
        long viewId;
        Vector<ClusterNode> deadMembers;
        Vector<ClusterNode> newMembers;
        Vector<ClusterNode> allMembers;
        Vector<View> originatingGroups;

        private ViewChangeEvent() {
        }
    }

    private class MessageListenerAdapter
    implements ExtendedMessageListener {
        private MessageListenerAdapter() {
        }

        public void getState(OutputStream stream) {
            ClusterPartition.this.logHistory("getState called on partition");
            ClusterPartition.this.log.debug((Object)"getState called.");
            try {
                ClusterPartition.this.getStateInternal(stream);
            }
            catch (Exception ex) {
                ClusterPartition.this.log.error((Object)"getState failed", (Throwable)ex);
            }
        }

        public void getState(String state_id, OutputStream ostream) {
            throw new UnsupportedOperationException("Not implemented; see http://jira.jboss.com/jira/browse/JBAS-3594");
        }

        public byte[] getState(String state_id) {
            throw new UnsupportedOperationException("Not implemented; see http://jira.jboss.com/jira/browse/JBAS-3594");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(InputStream stream) {
            ClusterPartition.this.logHistory("setState called on partition");
            try {
                if (stream == null) {
                    ClusterPartition.this.log.debug((Object)"transferred serviceState is null (may be first member in cluster)");
                } else {
                    ClusterPartition.this.setStateInternal(stream);
                }
                ClusterPartition.this.isStateSet = true;
            }
            catch (Throwable t) {
                ClusterPartition.this.recordSetStateFailure(t);
            }
            finally {
                ClusterPartition.this.notifyChannelLock();
            }
        }

        public byte[] getState() {
            ClusterPartition.this.logHistory("getState called on partition");
            ClusterPartition.this.log.debug((Object)"getState called.");
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                ClusterPartition.this.getStateInternal(baos);
                return baos.toByteArray();
            }
            catch (Exception ex) {
                ClusterPartition.this.log.error((Object)"getState failed", (Throwable)ex);
                return null;
            }
        }

        public void setState(String state_id, byte[] state) {
            throw new UnsupportedOperationException("Not implemented; see http://jira.jboss.com/jira/browse/JBAS-3594");
        }

        public void setState(String state_id, InputStream istream) {
            throw new UnsupportedOperationException("Not implemented; see http://jira.jboss.com/jira/browse/JBAS-3594");
        }

        public void receive(Message msg) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(byte[] obj) {
            ClusterPartition.this.logHistory("setState called on partition");
            try {
                if (obj == null) {
                    ClusterPartition.this.log.debug((Object)"transferred serviceState is null (may be first member in cluster)");
                } else {
                    ByteArrayInputStream bais = new ByteArrayInputStream(obj);
                    ClusterPartition.this.setStateInternal(bais);
                    bais.close();
                }
                ClusterPartition.this.isStateSet = true;
            }
            catch (Throwable t) {
                ClusterPartition.this.recordSetStateFailure(t);
            }
            finally {
                ClusterPartition.this.notifyChannelLock();
            }
        }
    }

    private class ChannelConnectTask
    implements Runnable {
        private final CountDownLatch latch;

        private ChannelConnectTask(CountDownLatch latch) {
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ClusterPartition.this.channel.connect(ClusterPartition.this.getPartitionName());
            }
            catch (Exception e) {
                Object object = ClusterPartition.this.channelLock;
                synchronized (object) {
                    ClusterPartition.this.connectException = e;
                }
            }
            finally {
                this.latch.countDown();
            }
        }
    }

    private static class HAServiceResponse
    implements Serializable {
        private static final long serialVersionUID = -6485594652749906437L;
        private final String serviceName;
        private final byte[] payload;

        public HAServiceResponse(String serviceName, byte[] payload) {
            this.serviceName = serviceName;
            this.payload = payload;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public byte[] getPayload() {
            return this.payload;
        }
    }

    private static class StateStreamEnd
    implements Serializable {
        private static final long serialVersionUID = -3705345735451504946L;

        private StateStreamEnd() {
        }
    }

    private static class NoHandlerForRPC
    implements Serializable {
        static final long serialVersionUID = -1263095408483622838L;

        private NoHandlerForRPC() {
        }
    }
}

