/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.Notification;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.jmx.HAServiceMBeanSupport;
import org.jboss.ha.singleton.HASingleton;
import org.jboss.ha.singleton.HASingletonElectionPolicy;
import org.jboss.ha.singleton.HASingletonMBean;

public class HASingletonSupport
extends HAServiceMBeanSupport
implements HASingletonMBean,
HASingleton {
    private final AtomicBoolean master = new AtomicBoolean(false);
    private volatile HASingletonElectionPolicy mElectionPolicyMB = null;
    private volatile boolean restartOnMerge = true;

    public boolean isMasterNode() {
        return this.master.get();
    }

    public void setElectionPolicy(HASingletonElectionPolicy mb) {
        this.mElectionPolicyMB = mb;
    }

    public HASingletonElectionPolicy getElectionPolicy() {
        return this.mElectionPolicyMB;
    }

    public boolean getRestartOnMerge() {
        return this.restartOnMerge;
    }

    public void setRestartOnMerge(boolean restartOnMerge) {
        this.restartOnMerge = restartOnMerge;
    }

    public void startSingleton() {
        this.log.debug((Object)"startSingleton() : elected for master singleton node");
    }

    public void stopSingleton() {
        this.log.debug((Object)"stopSingleton() : another node in the partition (if any) is elected for master");
    }

    public void partitionTopologyChanged(List newReplicants, int newViewID, boolean merge) {
        ClusterNode electedNode;
        boolean isElectedNewMaster = this.mElectionPolicyMB != null ? ((electedNode = this.mElectionPolicyMB.elect()) != null ? electedNode.equals(this.getHAPartition().getClusterNode()) : false) : this.isDRMMasterReplica();
        this.log.debug((Object)("partitionTopologyChanged, isElectedNewMaster=" + isElectedNewMaster + ", isMasterNode=" + this.master + ", viewID=" + newViewID));
        boolean isMaster = this.master.get();
        if (isElectedNewMaster && isMaster) {
            if (this.restartOnMerge && merge) {
                this.restartMaster();
            }
        } else if (isElectedNewMaster && !isMaster) {
            this.makeThisNodeMaster();
        } else if (isMaster) {
            this._stopOldMaster();
        }
    }

    public void _stopOldMaster() {
        this.log.debug((Object)("_stopOldMaster, isMasterNode=" + this.master));
        try {
            if (this.master.compareAndSet(true, false)) {
                this.sendLocalNotification("org.jboss.ha.singleton.stopping");
                this.stopSingleton();
                this.sendLocalNotification("org.jboss.ha.singleton.stopped");
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"_stopOldMaster failed. Will still try to start new master. You need to examine the reason why the old master wouldn't stop and resolve it. It is bad that the old singleton may still be running while we are starting a new one, so you need to resolve this ASAP.", (Throwable)ex);
        }
    }

    protected void makeThisNodeMaster() {
        try {
            this.callAsyncMethodOnPartition("_stopOldMaster", new Object[0], new Class[0]);
            this.startNewMaster();
        }
        catch (Exception ex) {
            this.log.error((Object)"_stopOldMaster failed. New master singleton will not start.", (Throwable)ex);
        }
    }

    protected void startNewMaster() {
        this.log.debug((Object)("startNewMaster, isMasterNode=" + this.master));
        this.master.set(true);
        this.sendLocalNotification("org.jboss.ha.singleton.starting");
        this.startSingleton();
        this.sendLocalNotification("org.jboss.ha.singleton.started");
    }

    protected void restartMaster() {
        this._stopOldMaster();
        this.startNewMaster();
    }

    protected void createService() throws Exception {
        super.createService();
        if (this.mElectionPolicyMB != null) {
            this.mElectionPolicyMB.setHAPartition(this.getHAPartition());
            this.mElectionPolicyMB.setSingletonName(this.getServiceHAName());
        }
    }

    private void sendLocalNotification(String type) {
        Notification n = new Notification(type, this, this.getNextNotificationSequenceNumber());
        super.sendNotificationToLocalListeners(n);
    }
}

