/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.jmx;

import java.io.Serializable;
import java.util.List;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.ClusterPartitionMBean;
import org.jboss.ha.jmx.HAServiceMBean;
import org.jboss.system.ServiceMBeanSupport;

public class HAServiceMBeanSupport
extends ServiceMBeanSupport
implements HAServiceMBean {
    private HAPartition clusterPartition;
    private boolean registerClassloader = false;
    private DistributedReplicantManager.ReplicantListener drmListener = null;
    private String REPLICANT_TOKEN = "";
    private boolean sendLocalLifecycleNotifications = true;
    private boolean sendRemoteLifecycleNotifications = true;
    private String serviceHAName;

    public HAPartition getHAPartition() {
        return this.clusterPartition;
    }

    public void setHAPartition(HAPartition clusterPartition) {
        this.clusterPartition = clusterPartition;
    }

    public void setClusterPartition(ClusterPartitionMBean clusterPartition) {
        if (this.getState() != 3 && this.getState() != 2) {
            this.clusterPartition = clusterPartition.getHAPartition();
        }
    }

    public String getPartitionName() {
        return this.clusterPartition.getPartitionName();
    }

    public boolean isRegisterThreadContextClassLoader() {
        return this.registerClassloader;
    }

    public void setRegisterThreadContextClassLoader(boolean register) {
        this.registerClassloader = register;
    }

    public void setDistributedState(String key, Serializable value) throws Exception {
        DistributedState ds = this.clusterPartition.getDistributedStateService();
        ds.set(this.getServiceHAName(), (Serializable)((Object)key), value);
    }

    public Serializable getDistributedState(String key) {
        DistributedState ds = this.clusterPartition.getDistributedStateService();
        return ds.get(this.getServiceHAName(), (Serializable)((Object)key));
    }

    protected void startService() throws Exception {
        this.log.debug((Object)"start HAServiceMBeanSupport");
        if (this.clusterPartition == null) {
            throw new IllegalStateException("HAPartition property must be set before starting HAServiceMBeanSupport");
        }
        this.setupPartition();
        this.registerRPCHandler();
        this.registerDRMListener();
    }

    protected void stopService() throws Exception {
        this.log.debug((Object)"stop HAServiceMBeanSupport");
        this.unregisterDRMListener();
        this.unregisterRPCHandler();
    }

    protected void setupPartition() throws Exception {
    }

    protected void registerRPCHandler() {
        if (this.isRegisterThreadContextClassLoader()) {
            this.clusterPartition.registerRPCHandler(this.getServiceHAName(), (Object)this, Thread.currentThread().getContextClassLoader());
        } else {
            this.clusterPartition.registerRPCHandler(this.getServiceHAName(), (Object)this);
        }
    }

    protected void unregisterRPCHandler() {
        this.clusterPartition.unregisterRPCHandler(this.getServiceHAName(), (Object)this);
    }

    protected void registerDRMListener() throws Exception {
        DistributedReplicantManager drm = this.clusterPartition.getDistributedReplicantManager();
        this.drmListener = new DistributedReplicantManager.ReplicantListener(){
            Object mutex = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void replicantsChanged(String key, List newReplicants, int newReplicantsViewId, boolean merge) {
                if (key.equals(HAServiceMBeanSupport.this.getServiceHAName())) {
                    Object object = this.mutex;
                    synchronized (object) {
                        HAServiceMBeanSupport.this.partitionTopologyChanged(newReplicants, newReplicantsViewId, merge);
                    }
                }
            }
        };
        drm.registerListener(this.getServiceHAName(), this.drmListener);
        drm.add(this.getServiceHAName(), (Serializable)((Object)this.REPLICANT_TOKEN));
    }

    protected void unregisterDRMListener() throws Exception {
        DistributedReplicantManager drm = this.clusterPartition.getDistributedReplicantManager();
        drm.remove(this.getServiceHAName());
        drm.unregisterListener(this.getServiceHAName(), this.drmListener);
    }

    public void partitionTopologyChanged(List newReplicants, int newReplicantsViewId, boolean merge) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("partitionTopologyChanged(). cluster view id: " + newReplicantsViewId));
        }
    }

    protected boolean isDRMMasterReplica() {
        DistributedReplicantManager drm = this.clusterPartition.getDistributedReplicantManager();
        return drm.isMasterReplica(this.getServiceHAName());
    }

    public List callMethodOnPartition(String methodName, Object[] args, Class[] types) throws Exception {
        return this.clusterPartition.callMethodOnCluster(this.getServiceHAName(), methodName, args, types, true);
    }

    public boolean getSendLocalLifecycleNotifications() {
        return this.sendLocalLifecycleNotifications;
    }

    public void setSendLocalLifecycleNotifications(boolean sendLocalLifecycleNotifications) {
        this.sendLocalLifecycleNotifications = sendLocalLifecycleNotifications;
    }

    public boolean getSendRemoteLifecycleNotifications() {
        return this.sendRemoteLifecycleNotifications;
    }

    public void setSendRemoteLifecycleNotifications(boolean sendRemoteLifecycleNotifications) {
        this.sendRemoteLifecycleNotifications = sendRemoteLifecycleNotifications;
    }

    public void sendNotification(Notification notification) {
        boolean stateChange;
        block4: {
            stateChange = this.isStateChangeNotification(notification);
            if (!stateChange || this.sendRemoteLifecycleNotifications) {
                try {
                    notification.setSource(this.getServiceName());
                    this.sendNotificationRemote(notification);
                }
                catch (Throwable th) {
                    boolean debug = this.log.isDebugEnabled();
                    if (!debug) break block4;
                    this.log.debug((Object)("sendNotificationRemote( " + notification + " ) failed "), th);
                }
            }
        }
        if (!stateChange || this.sendLocalLifecycleNotifications) {
            this.sendNotificationToLocalListeners(notification);
        }
    }

    private boolean isStateChangeNotification(Notification notification) {
        boolean stateChange = false;
        if (notification instanceof AttributeChangeNotification) {
            stateChange = "State".equals(((AttributeChangeNotification)notification).getAttributeName());
        }
        return stateChange;
    }

    protected void sendNotificationToLocalListeners(Notification notification) {
        super.sendNotification(notification);
    }

    protected void callAsyncMethodOnPartition(String methodName, Object[] args, Class[] types) throws Exception {
        this.clusterPartition.callAsynchMethodOnCluster(this.getServiceHAName(), methodName, args, types, true);
    }

    protected void sendNotificationRemote(Notification notification) throws Exception {
        this.callAsyncMethodOnPartition("_receiveRemoteNotification", new Object[]{notification}, new Class[]{Notification.class});
    }

    public void _receiveRemoteNotification(Notification notification) {
        super.sendNotification(notification);
    }

    public String getServiceHAName() {
        if (this.serviceHAName == null) {
            ObjectName on = this.getServiceName();
            if (on != null) {
                this.serviceHAName = on.getCanonicalName();
            } else {
                throw new IllegalStateException("Cannot determine ServiceHAName; either set it explicitly or register this object in JMX before calling create");
            }
        }
        return this.serviceHAName;
    }

    @Inject(fromContext=FromContext.NAME)
    public void setServiceHAName(String haName) {
        this.serviceHAName = haName;
    }
}

