/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.jndi;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.jndi.HAJNDI;
import org.jboss.logging.Logger;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;
import org.jnp.interfaces.NamingParser;

public class TreeHead
implements Naming {
    static final long serialVersionUID = 6342802270002172451L;
    private static final NamingParser parser = new NamingParser();
    private final Fqn m_root;
    private static Logger log = Logger.getLogger(TreeHead.class);
    private Cache m_cache;
    private transient HAPartition partition;
    private transient HAJNDI father;

    public TreeHead(Cache cache, Fqn root) throws NamingException {
        this.m_cache = cache;
        this.m_root = root;
    }

    public void init() throws Exception {
        log.debug((Object)"HAJNDI registering RPC Handler with HAPartition");
        this.partition.registerRPCHandler("HAJNDI", (Object)this);
        log.debug((Object)"initializing HAJNDITreeCache root");
        this.putTreeRoot();
    }

    public void stop() throws Exception {
    }

    public void destroy() throws Exception {
        log.debug((Object)"HAJNDI unregistering RPCHandler with HAPartition");
        this.partition.unregisterRPCHandler("HAJNDI", (Object)this);
    }

    public void setPartition(HAPartition partition) {
        this.partition = partition;
    }

    public void setHARMIHead(HAJNDI father) {
        this.father = father;
    }

    public void bind(Name name, Object obj, String className) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("bind, name=" + name));
        }
        this.internalBind(name, obj, className, false);
    }

    public void rebind(Name name, Object obj, String className) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("rebind, name=" + name));
        }
        this.internalBind(name, obj, className, true);
    }

    public void unbind(Name name) throws NamingException {
        Fqn ctx;
        if (log.isTraceEnabled()) {
            log.trace((Object)("unbind, name=" + name));
        }
        if (name.isEmpty()) {
            throw new InvalidNameException();
        }
        try {
            Fqn temp = new Fqn(this.m_root, Fqn.fromString((String)name.toString()));
            if (this.m_cache.getRoot().hasChild(temp)) {
                this.m_cache.removeNode(temp);
                return;
            }
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
        int size = name.size();
        String key = name.get(size - 1);
        if (size > 1) {
            String prefix = name.getPrefix(size - 1).toString();
            Fqn fqn = Fqn.fromString((String)prefix);
            ctx = new Fqn(this.m_root, fqn);
        } else {
            ctx = this.m_root;
        }
        try {
            Object removed = this.m_cache.remove(ctx, (Object)key);
            if (removed == null) {
                if (!this.m_cache.getRoot().hasChild(ctx)) {
                    throw new NotContextException(name.getPrefix(size - 1).toString() + " not a context");
                }
                throw new NameNotFoundException(key + " not bound");
            }
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
    }

    public Object lookup(Name name) throws NamingException {
        Fqn ctx;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("lookup, name=" + name));
        }
        Object result = null;
        if (name.isEmpty()) {
            return new NamingContext(null, parser.parse(""), this.getRoot());
        }
        try {
            Node n = this.m_cache.getRoot().getChild(new Fqn(this.m_root, Fqn.fromString((String)name.toString())));
            if (n != null) {
                Name fullName = (Name)name.clone();
                return new NamingContext(null, fullName, this.getRoot());
            }
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
        int size = name.size();
        String key = name.get(size - 1);
        if (size > 1) {
            String prefix = name.getPrefix(size - 1).toString();
            Fqn fqn = Fqn.fromString((String)prefix);
            ctx = new Fqn(this.m_root, fqn);
        } else {
            ctx = this.m_root;
        }
        try {
            Binding b = (Binding)this.m_cache.get(ctx, (Object)key);
            result = b != null ? b.getObject() : this.internalLookupLocally(name);
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
        return result;
    }

    public Object lookupLocally(Name name) throws NamingException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("lookupLocally, name=" + name));
        }
        try {
            if (NamingContext.localServer != null) {
                return NamingContext.localServer.lookup(name);
            }
            InitialContext ctx = new InitialContext();
            return ctx.lookup(name);
        }
        catch (NamingException e) {
            if (trace) {
                log.trace((Object)("lookupLocally failed, name=" + name), (Throwable)e);
            }
            throw e;
        }
        catch (RemoteException e) {
            NamingException ne = new NamingException("unknown remote exception");
            ne.setRootCause(e);
            if (trace) {
                log.trace((Object)("lookupLocally failed, name=" + name), (Throwable)e);
            }
            throw ne;
        }
        catch (RuntimeException e) {
            if (trace) {
                log.trace((Object)("lookupLocally failed, name=" + name), (Throwable)e);
            }
            throw e;
        }
    }

    public Collection list(Name name) throws NamingException {
        Fqn ctx;
        if (log.isTraceEnabled()) {
            log.trace((Object)("list, name=" + name));
        }
        Object result = null;
        String ctxName = "";
        int size = name.size();
        if (size >= 1) {
            ctxName = name.toString();
            Fqn fqn = Fqn.fromString((String)ctxName);
            ctx = new Fqn(this.m_root, fqn);
        } else {
            ctx = this.m_root;
        }
        boolean exists = this.m_cache.getRoot().hasChild(ctx);
        if (!exists) {
            try {
                return this.enum2list(new InitialContext().list(name));
            }
            catch (NamingException e) {
                throw new NotContextException(ctxName + " not a context");
            }
        }
        Vector<NameClassPair> list = null;
        try {
            list = new Vector<NameClassPair>();
            Node base = this.m_cache.getRoot().getChild(ctx);
            if (base != null) {
                Map data = base.getData();
                for (Binding b : data.values()) {
                    list.addElement(new NameClassPair(b.getName(), b.getClassName(), true));
                }
                Set children = base.getChildrenNames();
                if (children != null && !children.isEmpty()) {
                    for (String node : children) {
                        Name fullName = (Name)name.clone();
                        fullName.add(node);
                        list.addElement(new NameClassPair(node, NamingContext.class.getName(), true));
                    }
                }
            }
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
        return list;
    }

    public Collection listBindings(Name name) throws NamingException {
        Fqn ctx;
        if (log.isTraceEnabled()) {
            log.trace((Object)("listBindings, name=" + name));
        }
        String ctxName = "";
        int size = name.size();
        if (size >= 1) {
            ctxName = name.toString();
            Fqn fqn = Fqn.fromString((String)ctxName);
            ctx = new Fqn(this.m_root, fqn);
        } else {
            ctx = this.m_root;
        }
        boolean exists = this.m_cache.getRoot().hasChild(ctx);
        if (!exists) {
            try {
                return this.enum2list(new InitialContext().listBindings(name));
            }
            catch (NamingException e) {
                throw new NotContextException(ctxName + " not a context");
            }
        }
        Vector<Object> list = null;
        try {
            list = new Vector<Object>();
            Node node = this.m_cache.getRoot().getChild(ctx);
            if (node != null) {
                Set children;
                Map data = node.getData();
                if (data != null && data.size() > 0) {
                    list.addAll(data.values());
                }
                if ((children = node.getChildrenNames()) != null && !children.isEmpty()) {
                    for (String child : children) {
                        Name fullName = (Name)name.clone();
                        fullName.add(child);
                        NamingContext subCtx = new NamingContext(null, fullName, this.getRoot());
                        Binding b = new Binding(child, NamingContext.class.getName(), subCtx, true);
                        list.addElement(b);
                    }
                }
            }
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
        return list;
    }

    public Context createSubcontext(Name name) throws NamingException {
        Fqn pctx;
        int size;
        if (log.isTraceEnabled()) {
            log.trace((Object)("createSubcontext, name=" + name));
        }
        if ((size = name.size()) == 0) {
            throw new InvalidNameException("Cannot pass an empty name to createSubcontext");
        }
        NamingContext subCtx = null;
        String str = name.toString();
        Fqn fqn = Fqn.fromString((String)str);
        Fqn ctx = new Fqn(this.m_root, fqn);
        if (this.m_cache.getRoot().hasChild(ctx)) {
            throw new NameAlreadyBoundException();
        }
        String newctx = name.get(size - 1);
        if (size > 1) {
            String prefix = name.getPrefix(size - 1).toString();
            Fqn fqn2 = Fqn.fromString((String)prefix);
            pctx = new Fqn(this.m_root, fqn2);
        } else {
            pctx = this.m_root;
        }
        boolean exists = this.m_cache.getRoot().hasChild(pctx);
        if (!exists) {
            throw new NotContextException(name.getPrefix(size - 1).toString());
        }
        Fqn newf = new Fqn(pctx, Fqn.fromString((String)newctx));
        try {
            this.m_cache.put(newf, new HashMap());
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
        Name fullName = parser.parse("");
        fullName.addAll(name);
        subCtx = new NamingContext(null, fullName, this.getRoot());
        return subCtx;
    }

    public Naming getRoot() {
        return this.father.getHAStub();
    }

    private void putTreeRoot() throws CacheException {
        if (!this.m_cache.getRoot().hasChild(this.m_root)) {
            this.m_cache.put(this.m_root, null);
        }
    }

    private void internalBind(Name name, Object obj, String className, boolean rebind) throws NamingException {
        Node node;
        Fqn ctx;
        if (name.isEmpty()) {
            throw new InvalidNameException();
        }
        int size = name.size();
        String key = name.get(size - 1);
        if (size > 1) {
            String prefix = name.getPrefix(size - 1).toString();
            Fqn fqn = Fqn.fromString((String)prefix);
            ctx = new Fqn(this.m_root, fqn);
        } else {
            ctx = this.m_root;
        }
        boolean exists = this.m_cache.getRoot().hasChild(ctx);
        if (!exists) {
            throw new NotContextException(name.getPrefix(size - 1).toString() + " not a context");
        }
        if (!rebind && (node = this.m_cache.getRoot().getChild(ctx)) != null && node.get((Object)key) != null) {
            throw new NameAlreadyBoundException(key);
        }
        try {
            this.m_cache.put(ctx, (Object)key, (Object)new Binding(key, className, obj, true));
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private Object internalLookupLocally(Name name) throws NamingException {
        boolean trace = log.isTraceEnabled();
        Object result = null;
        try {
            result = this.lookupLocally(name);
        }
        catch (NameNotFoundException nnfe) {
            Object[] args = new Object[]{name};
            List rsp = null;
            Exception cause = null;
            try {
                if (trace) {
                    log.trace((Object)("calling lookupLocally(" + name + ") on HAJNDI cluster"));
                }
                rsp = this.partition.callMethodOnCluster("HAJNDI", "lookupLocally", args, new Class[]{Name.class}, true);
            }
            catch (Exception ignored) {
                if (trace) {
                    log.trace((Object)("Clustered lookupLocally(" + name + ") failed"), (Throwable)ignored);
                }
                cause = ignored;
            }
            if (trace) {
                log.trace((Object)("Returned results size: " + (rsp != null ? rsp.size() : 0)));
            }
            if (rsp == null || rsp.size() == 0) {
                NameNotFoundException nnfe2 = new NameNotFoundException(name.toString());
                nnfe2.setRootCause(cause);
                throw nnfe2;
            }
            for (int i = 0; i < rsp.size(); ++i) {
                result = rsp.get(i);
                if (trace) {
                    String type = result != null ? result.getClass().getName() : "null";
                    log.trace((Object)("lookupLocally, i=" + i + ", value=" + result + ", type=" + type));
                }
                if (result == null || result instanceof Exception) continue;
                return result;
            }
            throw nnfe;
        }
        return result;
    }

    private ArrayList enum2list(NamingEnumeration en) {
        ArrayList rtn = new ArrayList();
        try {
            while (en.hasMore()) {
                rtn.add(en.next());
            }
            en.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return rtn;
    }
}

