/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.net.InetAddress;
import java.rmi.dgc.VMID;
import java.rmi.server.UID;
import java.util.HashMap;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBean;
import org.jboss.system.server.ServerConfigUtil;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.jmx.JChannelFactoryMBean;
import org.jgroups.mux.MuxChannel;
import org.jgroups.stack.IpAddress;

public class JChannelFactory
extends org.jgroups.JChannelFactory
implements JChannelFactoryMBean {
    protected static Logger log = Logger.getLogger(JChannelFactory.class);
    private static final int CREATED = 6;
    private static final int STARTING = 2;
    private static final int STARTED = 3;
    private static final int STOPPING = 1;
    private static final int STOPPED = 0;
    private static final int DESTROYED = 5;
    private static final int FAILED = 4;
    private InetAddress nodeAddress;
    private String nodeName;
    private int namingServicePort = -1;
    private int state;
    private boolean assignLogicalAddresses = true;

    public Channel createMultiplexerChannel(String stack_name, String id, boolean register_for_state_transfer, String substate_id) throws Exception {
        Channel channel = super.createMultiplexerChannel(stack_name, id, false, null);
        if (this.assignLogicalAddresses) {
            this.setChannelUniqueId(channel);
        }
        return channel;
    }

    public Channel createMultiplexerChannel(String stack_name, String id) throws Exception {
        return this.createMultiplexerChannel(stack_name, id, false, null);
    }

    public InetAddress getNodeAddress() {
        return this.nodeAddress;
    }

    public void setNodeAddress(InetAddress nodeAddress) {
        this.nodeAddress = nodeAddress;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public int getNamingServicePort() {
        return this.namingServicePort;
    }

    public void setNamingServicePort(int jndiPort) {
        this.namingServicePort = jndiPort;
    }

    public boolean getAssignLogicalAddresses() {
        return this.assignLogicalAddresses;
    }

    public void setAssignLogicalAddresses(boolean logicalAddresses) {
        this.assignLogicalAddresses = logicalAddresses;
    }

    public void create() throws Exception {
        if (this.state == 6 || this.state == 2 || this.state == 3 || this.state == 1 || this.state == 0) {
            log.debug((Object)("Ignoring create call; current state is " + this.getStateString()));
            return;
        }
        log.debug((Object)"Creating JChannelFactory");
        try {
            super.create();
            this.state = 6;
        }
        catch (Exception e) {
            log.debug((Object)"Initialization failed JChannelFactory", (Throwable)e);
            throw e;
        }
        log.debug((Object)"Created JChannelFactory");
        super.create();
    }

    public void start() throws Exception {
        if (this.state == 2 || this.state == 3 || this.state == 1) {
            log.debug((Object)("Ignoring start call; current state is " + this.getStateString()));
            return;
        }
        if (this.state != 6 && this.state != 0 && this.state != 4) {
            log.debug((Object)"Start requested before create, calling create now");
            this.create();
        }
        this.state = 2;
        log.debug((Object)"Starting JChannelFactory");
        try {
            super.start();
        }
        catch (Exception e) {
            this.state = 4;
            log.debug((Object)"Starting failed JChannelFactory", (Throwable)e);
            throw e;
        }
        this.state = 3;
        log.debug((Object)"Started JChannelFactory");
    }

    public void stop() {
        if (this.state != 3) {
            log.debug((Object)("Ignoring stop call; current state is " + this.getStateString()));
            return;
        }
        this.state = 1;
        log.debug((Object)"Stopping JChannelFactory");
        try {
            super.stop();
        }
        catch (Throwable e) {
            this.state = 4;
            log.warn((Object)"Stopping failed JChannelFactory", e);
            return;
        }
        this.state = 0;
        log.debug((Object)"Stopped JChannelFactory");
    }

    public void destroy() {
        if (this.state == 5) {
            log.debug((Object)("Ignoring destroy call; current state is " + this.getStateString()));
            return;
        }
        if (this.state == 3) {
            log.debug((Object)"Destroy requested before stop, calling stop now");
            this.stop();
        }
        log.debug((Object)"Destroying JChannelFactory");
        try {
            super.destroy();
        }
        catch (Throwable t) {
            log.warn((Object)"Destroying failed JChannelFactory", t);
        }
        this.state = 5;
        log.debug((Object)"Destroyed JChannelFactory");
    }

    private void setChannelUniqueId(Channel channel) throws Exception {
        IpAddress address = (IpAddress)channel.getLocalAddress();
        if (address == null) {
            if (this.nodeName == null || "".equals(this.nodeName)) {
                this.nodeName = this.generateUniqueNodeName();
            }
            log.debug((Object)("Passing unique node id " + this.nodeName + " to the channel as additional data"));
            HashMap<String, byte[]> staticNodeName = new HashMap<String, byte[]>();
            staticNodeName.put("additional_data", this.nodeName.getBytes());
            channel.down(new Event(56, staticNodeName));
        } else if (address.getAdditionalData() == null) {
            Channel testee = channel;
            if (channel instanceof MuxChannel) {
                testee = ((MuxChannel)channel).getChannel();
            }
            if (testee.isConnected()) {
                throw new IllegalStateException("Underlying JChannel was connected before additional_data was set");
            }
        } else if (this.nodeName == null || "".equals(this.nodeName)) {
            this.nodeName = new String(address.getAdditionalData());
            log.warn((Object)("Field nodeName was not set but mux channel already had additional data -- setting nodeName to " + this.nodeName));
        }
    }

    private String getStateString() {
        return ServiceMBean.states[this.state];
    }

    private String generateUniqueNodeName() throws Exception {
        String hostIP = null;
        InetAddress address = ServerConfigUtil.fixRemoteAddress((InetAddress)this.nodeAddress);
        if (address == null) {
            log.debug((Object)"unable to create a GUID for this cluster, check network configuration is correctly setup (getLocalHost has returned an exception)");
            log.debug((Object)"using a full GUID strategy");
            return new VMID().toString();
        }
        hostIP = address.getHostAddress();
        if (this.namingServicePort > 0) {
            return hostIP + ":" + this.namingServicePort;
        }
        log.debug((Object)"JNDI has been found but the service wasn't started so we cannot be entirely sure we are the only one that wants to use this PORT as a GUID on this host.");
        String uid = new UID().toString();
        return hostIP + ":" + uid;
    }
}

