/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.net.InetAddress;
import org.jboss.cache.Cache;
import org.jboss.cache.config.Configuration;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.system.server.ServerConfigUtil;
import org.jgroups.ChannelFactory;

public class ClusterPartitionConfig {
    private Cache cache;
    private ChannelFactory multiplexer;
    private DistributedState distributedState;
    private String stackName;
    private String partitionName = ServerConfigUtil.getDefaultPartitionName();
    private boolean deadlock_detection = false;
    private boolean allow_sync_events = false;
    private String nodeUniqueId = null;
    private InetAddress nodeAddress = null;
    private int namingServicePort = -1;
    private long state_transfer_timeout = 60000L;
    private long method_call_timeout = 60000L;

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String newName) {
        this.partitionName = newName;
    }

    public String getNodeUniqueId() {
        return this.nodeUniqueId;
    }

    public void setNodeUniqueId(String node) {
        this.nodeUniqueId = node;
    }

    public InetAddress getNodeAddress() {
        return this.nodeAddress;
    }

    public void setNodeAddress(InetAddress address) {
        this.nodeAddress = address;
    }

    public long getStateTransferTimeout() {
        return this.state_transfer_timeout;
    }

    public void setStateTransferTimeout(long timeout) {
        this.state_transfer_timeout = timeout;
    }

    public long getMethodCallTimeout() {
        return this.method_call_timeout;
    }

    public void setMethodCallTimeout(long timeout) {
        this.method_call_timeout = timeout;
    }

    public boolean getDeadlockDetection() {
        return this.deadlock_detection;
    }

    public void setDeadlockDetection(boolean doit) {
        this.deadlock_detection = doit;
    }

    public boolean getAllowSynchronousMembershipNotifications() {
        return this.allow_sync_events;
    }

    public void setAllowSynchronousMembershipNotifications(boolean allowSync) {
        this.allow_sync_events = allowSync;
    }

    public ChannelFactory getMultiplexer() {
        return this.multiplexer;
    }

    public String getMultiplexerStack() {
        return this.stackName;
    }

    public Cache getClusteredCache() {
        return this.cache;
    }

    public void setClusteredCache(Cache cache) {
        this.cache = cache;
        Configuration config = cache.getConfiguration();
        this.multiplexer = config.getRuntimeConfig().getMuxChannelFactory();
        if (this.multiplexer == null) {
            throw new IllegalArgumentException("Cache not configured for a multiplexer");
        }
        this.stackName = config.getMultiplexerStack();
    }

    public int getNamingServicePort() {
        return this.namingServicePort;
    }

    public void setNamingServicePort(int namingServicePort) {
        this.namingServicePort = namingServicePort;
    }

    public DistributedState getDistributedState() {
        return this.distributedState;
    }

    public void setDistributedState(DistributedState distributedState) {
        this.distributedState = distributedState;
    }
}

