/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.maven.FileSet;

public class JandexGoal
implements Mojo {
    private File classesDir;
    private List<FileSet> fileSets;
    private boolean processDefaultFileSet = true;
    private boolean verbose = false;
    private String indexName = "jandex.idx";
    private boolean skip = true;
    private Log log;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Jandex execution skipped.");
            return;
        }
        if (this.processDefaultFileSet) {
            boolean found = false;
            if (this.fileSets != null) {
                for (FileSet fileset : this.fileSets) {
                    if (!fileset.getDirectory().equals(this.classesDir)) continue;
                    found = true;
                }
            }
            if (!found) {
                FileSet fs = new FileSet();
                fs.setDirectory(this.classesDir);
                fs.setIncludes(Collections.singletonList("**/*.class"));
                if (this.fileSets == null) {
                    this.fileSets = new ArrayList<FileSet>();
                }
                this.fileSets.add(fs);
            }
        }
        Indexer indexer = new Indexer();
        for (FileSet fileset : this.fileSets) {
            String[] files;
            List<String> excludes;
            List<String> includes;
            File dir = fileset.getDirectory();
            if (!dir.exists()) {
                this.getLog().info((CharSequence)("[SKIP] Cannot process fileset in directory: " + fileset.getDirectory() + ". Directory does not exist!"));
                continue;
            }
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(dir);
            if (fileset.isUseDefaultExcludes()) {
                scanner.addDefaultExcludes();
            }
            if ((includes = fileset.getIncludes()) != null) {
                scanner.setIncludes(includes.toArray(new String[0]));
            }
            if ((excludes = fileset.getExcludes()) != null) {
                scanner.setExcludes(excludes.toArray(new String[0]));
            }
            scanner.scan();
            for (String file : files = scanner.getIncludedFiles()) {
                FileInputStream fis;
                block20: {
                    if (!file.endsWith(".class")) continue;
                    fis = null;
                    try {
                        fis = new FileInputStream(new File(dir, file));
                        ClassInfo info = indexer.index((InputStream)fis);
                        if (!this.doVerbose() || info == null) break block20;
                        this.getLog().info((CharSequence)("Indexed " + info.name() + " (" + info.annotations().size() + " annotations)"));
                    }
                    catch (Exception e) {
                        try {
                            throw new MojoExecutionException(e.getMessage(), e);
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(fis);
                            throw throwable;
                        }
                    }
                }
                IOUtil.close((InputStream)fis);
            }
            File idx = new File(dir, "META-INF/" + this.indexName);
            idx.getParentFile().mkdirs();
            FileOutputStream indexOut = null;
            try {
                indexOut = new FileOutputStream(idx);
                IndexWriter writer = new IndexWriter((OutputStream)indexOut);
                Index index = indexer.complete();
                writer.write(index);
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(indexOut);
                    throw throwable;
                }
            }
            IOUtil.close((OutputStream)indexOut);
        }
    }

    private boolean doVerbose() {
        return this.verbose || this.getLog().isDebugEnabled();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        return this.log;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }
}

