/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import org.jboss.jca.adapters.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.jca.adapters.jdbc.JBossWrapper;
import org.jboss.jca.adapters.jdbc.WrappedConnection;
import org.jboss.jca.adapters.jdbc.WrappedConnectionRequestInfo;
import org.jboss.jca.core.spi.transaction.TransactionTimeoutConfiguration;
import org.jboss.jca.core.spi.transaction.TxUtils;

public class WrapperDataSource
extends JBossWrapper
implements Referenceable,
DataSource,
Serializable {
    private static final long serialVersionUID = 3570285419164793501L;
    private static org.jboss.logging.Logger spyLogger = org.jboss.logging.Logger.getLogger((String)"jboss.jdbc.spy");
    private final BaseWrapperManagedConnectionFactory mcf;
    private final ConnectionManager cm;
    private PrintWriter logger;
    private Reference reference;
    private boolean initialized = false;
    private ConnectionRequestInfo defaultCRI;

    protected WrapperDataSource(BaseWrapperManagedConnectionFactory mcf, ConnectionManager cm) {
        this.mcf = mcf;
        this.cm = cm;
        this.defaultCRI = mcf.getUserName() != null ? new WrappedConnectionRequestInfo(mcf.getUserName(), mcf.getPassword()) : null;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logger;
    }

    @Override
    public void setLogWriter(PrintWriter pw) throws SQLException {
        this.logger = pw;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLoginTimeout(int param1) throws SQLException {
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            if (this.mcf.getSpy().booleanValue()) {
                spyLogger.debugf("%s [%s] getConnection()", (Object)this.mcf.getJndiName(), (Object)"DataSource");
            }
            WrappedConnection wc = (WrappedConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, this.defaultCRI);
            wc.setDataSource(this);
            wc.setSpy(this.mcf.getSpy());
            wc.setJndiName(this.mcf.getJndiName());
            return wc;
        }
        catch (ResourceException re) {
            throw new SQLException(re);
        }
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        WrappedConnectionRequestInfo cri = new WrappedConnectionRequestInfo(user, password);
        try {
            if (this.mcf.getSpy().booleanValue()) {
                spyLogger.debugf("%s [%s] getConnection(%s, ****)", (Object)this.mcf.getJndiName(), (Object)"DataSource", (Object)user);
            }
            WrappedConnection wc = (WrappedConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)cri);
            wc.setDataSource(this);
            wc.setSpy(this.mcf.getSpy());
            wc.setJndiName(this.mcf.getJndiName());
            return wc;
        }
        catch (ResourceException re) {
            throw new SQLException(re);
        }
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }

    protected int getTimeLeftBeforeTransactionTimeout() throws SQLException {
        try {
            if (this.cm instanceof TransactionTimeoutConfiguration) {
                long timeout = ((TransactionTimeoutConfiguration)this.cm).getTimeLeftBeforeTransactionTimeout(true);
                if (timeout == -1L) {
                    return -1;
                }
                long result = timeout / 1000L;
                if (result % 1000L != 0L) {
                    ++result;
                }
                return (int)result;
            }
            return -1;
        }
        catch (RollbackException e) {
            throw new SQLException(e);
        }
    }

    protected void checkTransactionActive() throws SQLException {
        if (!this.mcf.isJTA().booleanValue()) {
            return;
        }
        try {
            int status = this.mcf.getTransactionSynchronizationRegistry().getTransactionStatus();
            if (status == 6) {
                return;
            }
            if (status != 0 && status != 7 && status != 2 && status != 8) {
                throw new SQLException(bundle.transactionCannotProceed(TxUtils.getStatusAsString((int)status)));
            }
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage(), t);
        }
    }
}

