/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.jca.adapters.jdbc.JBossWrapper;
import org.jboss.jca.adapters.jdbc.SecurityActions;
import org.jboss.jca.adapters.jdbc.StatementAccess;
import org.jboss.jca.adapters.jdbc.WrappedConnection;
import org.jboss.jca.adapters.jdbc.WrappedResultSet;
import org.jboss.logging.Logger;

public abstract class WrappedStatement
extends JBossWrapper
implements Statement,
StatementAccess {
    protected static Logger spyLogger = Logger.getLogger((String)"jboss.jdbc.spy");
    private final WrappedConnection lc;
    private final Statement s;
    private HashMap<WrappedResultSet, Throwable> resultSets;
    private AtomicBoolean closed = new AtomicBoolean(false);
    protected final boolean spy;
    protected final String jndiName;
    protected static Integer defaultFetchSize = null;
    private int timeoutSet;

    public WrappedStatement(WrappedConnection lc, Statement s, boolean spy, String jndiName) {
        this.lc = lc;
        this.s = s;
        this.spy = spy;
        this.jndiName = jndiName;
        this.timeoutSet = 0;
        if (defaultFetchSize != null) {
            try {
                s.setFetchSize(defaultFetchSize);
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        lc.registerStatement(this);
    }

    protected void lock() throws SQLException {
        this.lc.lock();
    }

    protected void unlock() {
        this.lc.unlock();
    }

    @Override
    public void close() throws SQLException {
        if (this.closed.get()) {
            return;
        }
        if (this.spy) {
            spyLogger.debugf("%s [%s] close()", (Object)this.jndiName, (Object)"Statement");
        }
        this.closed.set(true);
        this.lc.unregisterStatement(this);
        this.internalClose();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                if (this.spy) {
                    spyLogger.debugf("%s [%s] execute(%s)", (Object)this.jndiName, (Object)"Statement", (Object)sql);
                }
                boolean bl = this.s.execute(sql);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                if (this.spy) {
                    spyLogger.debugf("%s [%s] execute(%s, %s)", new Object[]{this.jndiName, "Statement", sql, autoGeneratedKeys});
                }
                boolean bl = this.s.execute(sql, autoGeneratedKeys);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                if (this.spy) {
                    spyLogger.debugf("%s [%s] execute(%s, %s)", new Object[]{this.jndiName, "Statement", sql, Arrays.toString(columnIndexes)});
                }
                boolean bl = this.s.execute(sql, columnIndexes);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                if (this.spy) {
                    spyLogger.debugf("%s [%s] execute(%s, %s)", new Object[]{this.jndiName, "Statement", sql, Arrays.toString(columnNames)});
                }
                boolean bl = this.s.execute(sql, columnNames);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.spy) {
            spyLogger.debugf("%s [%s] getConnection()", (Object)this.jndiName, (Object)"Statement");
        }
        return this.lc;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getWarnings()", (Object)this.jndiName, (Object)"Statement");
                }
                SQLWarning sQLWarning = this.s.getWarnings();
                return sQLWarning;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] clearWarnings()", (Object)this.jndiName, (Object)"Statement");
                }
                this.s.clearWarnings();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                if (this.spy) {
                    spyLogger.debugf("%s [%s] executeQuery(%s)", (Object)this.jndiName, (Object)"Statement", (Object)sql);
                }
                ResultSet result = this.s.executeQuery(sql);
                ResultSet resultSet = this.registerResultSet(result);
                return resultSet;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                if (this.spy) {
                    spyLogger.debugf("%s [%s] executeUpdate(%s)", (Object)this.jndiName, (Object)"Statement", (Object)sql);
                }
                int n = this.s.executeUpdate(sql);
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                if (this.spy) {
                    spyLogger.debugf("%s [%s] executeUpdate(%s, %s)", new Object[]{this.jndiName, "Statement", sql, autoGeneratedKeys});
                }
                int n = this.s.executeUpdate(sql, autoGeneratedKeys);
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                if (this.spy) {
                    spyLogger.debugf("%s [%s] executeUpdate(%s, %s)", new Object[]{this.jndiName, "Statement", sql, Arrays.toString(columnIndexes)});
                }
                int n = this.s.executeUpdate(sql, columnIndexes);
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                if (this.spy) {
                    spyLogger.debugf("%s [%s] executeUpdate(%s, %s)", new Object[]{this.jndiName, "Statement", sql, Arrays.toString(columnNames)});
                }
                int n = this.s.executeUpdate(sql, columnNames);
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getMaxFieldSize()", (Object)this.jndiName, (Object)"Statement");
                }
                int n = this.s.getMaxFieldSize();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setMaxFieldSize(%s)", (Object)this.jndiName, (Object)"Statement", (Object)max);
                }
                this.s.setMaxFieldSize(max);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getMaxRows()", (Object)this.jndiName, (Object)"Statement");
                }
                int n = this.s.getMaxRows();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxRows(int max) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setMaxRows(%s)", (Object)this.jndiName, (Object)"Statement", (Object)max);
                }
                this.s.setMaxRows(max);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setEscapeProcessing(%s)", (Object)this.jndiName, (Object)"Statement", (Object)enable);
                }
                this.s.setEscapeProcessing(enable);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getQueryTimeout()", (Object)this.jndiName, (Object)"Statement");
                }
                int n = this.s.getQueryTimeout();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueryTimeout(int timeout) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setQueryTimeout(%s)", (Object)this.jndiName, (Object)"Statement", (Object)timeout);
                }
                this.s.setQueryTimeout(timeout);
                this.timeoutSet = timeout;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] cancel()", (Object)this.jndiName, (Object)"Statement");
            }
            this.s.cancel();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorName(String name) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setCursorName(%s)", (Object)this.jndiName, (Object)"Statement", (Object)name);
                }
                this.s.setCursorName(name);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                ResultSet result;
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getResultSet()", (Object)this.jndiName, (Object)"Statement");
                }
                if ((result = this.s.getResultSet()) == null) {
                    ResultSet resultSet = null;
                    return resultSet;
                }
                ResultSet resultSet = this.registerResultSet(result);
                return resultSet;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getUpdateCount()", (Object)this.jndiName, (Object)"Statement");
                }
                int n = this.s.getUpdateCount();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getMoreResults()", (Object)this.jndiName, (Object)"Statement");
                }
                boolean bl = this.s.getMoreResults();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getMoreResults(%s)", (Object)this.jndiName, (Object)"Statement", (Object)current);
                }
                boolean bl = this.s.getMoreResults(current);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setFetchDirection(%s)", (Object)this.jndiName, (Object)"Statement", (Object)direction);
                }
                this.s.setFetchDirection(direction);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getFetchDirection()", (Object)this.jndiName, (Object)"Statement");
                }
                int n = this.s.getFetchDirection();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setFetchSize(%s)", (Object)this.jndiName, (Object)"Statement", (Object)rows);
                }
                this.s.setFetchSize(rows);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getFetchSize()", (Object)this.jndiName, (Object)"Statement");
                }
                int n = this.s.getFetchSize();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getResultSetConcurrency()", (Object)this.jndiName, (Object)"Statement");
                }
                int n = this.s.getResultSetConcurrency();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getResultSetType()", (Object)this.jndiName, (Object)"Statement");
                }
                int n = this.s.getResultSetType();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String sql) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] addBatch(%s)", (Object)this.jndiName, (Object)"Statement", (Object)sql);
                }
                this.s.addBatch(sql);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] clearBatch()", (Object)this.jndiName, (Object)"Statement");
                }
                this.s.clearBatch();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                this.checkConfiguredQueryTimeout();
                if (this.spy) {
                    spyLogger.debugf("%s [%s] executeBatch()", (Object)this.jndiName, (Object)"Statement");
                }
                int[] nArray = this.s.executeBatch();
                return nArray;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getGeneratedKeys()", (Object)this.jndiName, (Object)"Statement");
                }
                ResultSet resultSet = this.s.getGeneratedKeys();
                ResultSet resultSet2 = this.registerResultSet(resultSet);
                return resultSet2;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getResultSetHoldability()", (Object)this.jndiName, (Object)"Statement");
                }
                int n = this.s.getResultSetHoldability();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.lock();
        try {
            Statement wrapped;
            if (this.spy) {
                spyLogger.debugf("%s [%s] isClosed()", (Object)this.jndiName, (Object)"Statement");
            }
            if ((wrapped = this.getWrappedObject()) == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = wrapped.isClosed();
            return bl;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.lock();
        try {
            Statement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] isPoolable()", (Object)this.jndiName, (Object)"Statement");
                }
                boolean bl = statement.isPoolable();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.lock();
        try {
            Statement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setPoolable(%s)", (Object)this.jndiName, (Object)"Statement", (Object)poolable);
                }
                statement.setPoolable(poolable);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getUnderlyingStatement() throws SQLException {
        this.lock();
        try {
            this.checkState();
            Statement statement = this.s;
            return statement;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    protected Statement getWrappedObject() throws SQLException {
        return this.getUnderlyingStatement();
    }

    protected SQLException checkException(Throwable t) throws SQLException {
        throw this.lc.checkException(t);
    }

    protected void checkTransaction() throws SQLException {
        this.checkState();
        this.lc.checkTransaction();
    }

    protected void checkConfiguredQueryTimeout() throws SQLException {
        this.lc.checkConfiguredQueryTimeout(this, this.timeoutSet);
    }

    protected void checkTransactionActive() throws SQLException {
        this.lc.checkTransactionActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalClose() throws SQLException {
        this.closed.set(true);
        try {
            this.closeResultSets();
        }
        finally {
            this.s.close();
        }
        this.timeoutSet = 0;
    }

    void checkState() throws SQLException {
        if (this.closed.get()) {
            throw new SQLException(bundle.statementClosed());
        }
    }

    protected abstract WrappedResultSet wrapResultSet(ResultSet var1, boolean var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet registerResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            resultSet = this.wrapResultSet(resultSet, this.spy, this.jndiName);
        }
        if (this.lc.getTrackStatements() == 0) {
            return resultSet;
        }
        WrappedResultSet wrapped = (WrappedResultSet)resultSet;
        WrappedStatement wrappedStatement = this;
        synchronized (wrappedStatement) {
            if (this.resultSets == null) {
                this.resultSets = new HashMap(1);
            }
            if (this.lc.getTrackStatements() == 1) {
                this.resultSets.put(wrapped, new Throwable("STACKTRACE"));
            } else {
                this.resultSets.put(wrapped, null);
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterResultSet(WrappedResultSet resultSet) {
        if (this.lc.getTrackStatements() == 0) {
            return;
        }
        WrappedStatement wrappedStatement = this;
        synchronized (wrappedStatement) {
            if (this.resultSets != null) {
                this.resultSets.remove(resultSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResultSets() {
        if (this.lc.getTrackStatements() == 0) {
            return;
        }
        WrappedStatement wrappedStatement = this;
        synchronized (wrappedStatement) {
            if (this.resultSets == null) {
                return;
            }
            for (Map.Entry<WrappedResultSet, Throwable> entry : this.resultSets.entrySet()) {
                WrappedResultSet resultSet = entry.getKey();
                if (this.lc.getTrackStatements() == 1) {
                    Throwable stackTrace = entry.getValue();
                    this.lc.getLogger().closingResultSet(resultSet.toString(), stackTrace);
                }
                try {
                    resultSet.internalClose();
                }
                catch (Throwable t) {
                    this.lc.getLogger().errorDuringClosingResultSet(resultSet.toString(), t);
                }
            }
            this.resultSets.clear();
        }
    }

    static {
        String dfs = SecurityActions.getSystemProperty("ironjacamar.jdbc.defaultfetchsize");
        if (dfs != null) {
            defaultFetchSize = Integer.valueOf(dfs);
        }
    }
}

