/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getClassLoader(final Class<?> c) {
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return c.getClassLoader();
            }
        });
    }

    static String getSystemProperty(final String name) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(name);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        });
    }

    static StackTraceElement[] getStackTrace(final Thread t) {
        if (System.getSecurityManager() == null) {
            return t.getStackTrace();
        }
        return AccessController.doPrivileged(new PrivilegedAction<StackTraceElement[]>(){

            @Override
            public StackTraceElement[] run() {
                return t.getStackTrace();
            }
        });
    }
}

