/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.xa;

import java.sql.SQLException;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.jca.adapters.jdbc.BaseWrapperManagedConnection;
import org.jboss.jca.adapters.jdbc.xa.XAManagedConnectionFactory;

public class XAManagedConnection
extends BaseWrapperManagedConnection
implements XAResource,
LocalTransaction {
    protected final XAConnection xaConnection;
    protected final XAResource xaResource;
    protected Xid currentXid;

    public XAManagedConnection(XAManagedConnectionFactory mcf, XAConnection xaConnection, Properties props, int transactionIsolation, int psCacheSize) throws SQLException {
        super(mcf, xaConnection.getConnection(), props, transactionIsolation, psCacheSize);
        this.xaConnection = xaConnection;
        xaConnection.addConnectionEventListener(new ConnectionEventListener(){

            @Override
            public void connectionClosed(ConnectionEvent ce) {
            }

            @Override
            public void connectionErrorOccurred(ConnectionEvent ce) {
                SQLException ex = ce.getSQLException();
                XAManagedConnection.this.broadcastConnectionError(ex);
            }
        });
        this.xaResource = xaConnection.getXAResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws ResourceException {
        this.lock();
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (!this.inManagedTransaction) {
                    try {
                        if (this.underlyingAutoCommit) {
                            this.underlyingAutoCommit = false;
                            this.con.setAutoCommit(false);
                        }
                        this.checkState();
                        this.inManagedTransaction = true;
                    }
                    catch (SQLException e) {
                        this.checkException(e);
                    }
                } else {
                    throw new ResourceException(bundle.localTransactionNested());
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws ResourceException {
        this.lock();
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.inManagedTransaction) {
                    this.inManagedTransaction = false;
                }
            }
            try {
                this.con.commit();
            }
            catch (SQLException e) {
                this.checkException(e);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws ResourceException {
        this.lock();
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.inManagedTransaction) {
                    this.inManagedTransaction = false;
                }
            }
            try {
                this.con.rollback();
            }
            catch (SQLException e) {
                try {
                    this.checkException(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    protected void broadcastConnectionError(SQLException e) {
        super.broadcastConnectionError(e);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this;
    }

    public XAResource getXAResource() throws ResourceException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws ResourceException {
        try {
            super.destroy();
        }
        finally {
            try {
                this.xaConnection.close();
            }
            catch (SQLException e) {
                this.checkException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.lock();
        try {
            try {
                this.checkState();
            }
            catch (SQLException e) {
                this.getLog().errorCheckingState(e);
            }
            try {
                this.xaResource.start(xid, flags);
            }
            catch (XAException e) {
                if (this.isFailedXA(e.errorCode)) {
                    this.broadcastConnectionError(e);
                }
                throw e;
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.currentXid = xid;
                this.inManagedTransaction = true;
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.lock();
        try {
            try {
                this.xaResource.end(xid, flags);
            }
            catch (XAException e) {
                if (this.isFailedXA(e.errorCode)) {
                    this.broadcastConnectionError(e);
                }
                throw e;
            }
            Object object = this.stateLock;
            synchronized (object) {
                if (this.currentXid != null && this.currentXid.equals(xid)) {
                    this.inManagedTransaction = false;
                    this.currentXid = null;
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.xaResource.prepare(xid);
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.xaResource.commit(xid, onePhase);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.xaResource.rollback(xid);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.xaResource.forget(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.xaResource.recover(flag);
    }

    @Override
    public boolean isSameRM(XAResource other) throws XAException {
        Boolean overrideValue = ((XAManagedConnectionFactory)this.mcf).getIsSameRMOverrideValue();
        if (overrideValue != null) {
            return overrideValue;
        }
        return other instanceof XAManagedConnection ? this.xaResource.isSameRM(((XAManagedConnection)other).xaResource) : this.xaResource.isSameRM(other);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xaResource.setTransactionTimeout(seconds);
    }

    private boolean isFailedXA(int errorCode) {
        return errorCode < 100 || errorCode >= 107;
    }

    @Override
    public boolean isXA() {
        return true;
    }
}

