/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.local;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import org.jboss.jca.adapters.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.jca.adapters.jdbc.local.LocalManagedConnection;
import org.jboss.jca.adapters.jdbc.spi.URLSelectorStrategy;

public class LocalManagedConnectionFactory
extends BaseWrapperManagedConnectionFactory {
    private static final long serialVersionUID = 4698955390505160469L;
    private String driverClass;
    private transient Driver driver;
    private String connectionURL;
    private URLSelectorStrategy urlSelector;
    protected String connectionProperties;
    private static Map<String, Driver> driverCache = new ConcurrentHashMap<String, Driver>();

    @Override
    public Object createConnectionFactory(ConnectionManager cm) throws ResourceException {
        if (this.driverClass == null) {
            throw new ResourceException("driverClass is null");
        }
        if (this.connectionURL == null) {
            throw new ResourceException("connectionURL is null");
        }
        return super.createConnectionFactory(cm);
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
        if (this.urlDelimiter != null) {
            this.initUrlSelector();
        }
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public synchronized void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        this.driver = null;
    }

    public String getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(String connectionProperties) {
        this.connectionProperties = connectionProperties;
        this.connectionProps.clear();
        if (connectionProperties != null) {
            connectionProperties = connectionProperties.replaceAll("\\\\", "\\\\\\\\");
            connectionProperties = connectionProperties.replaceAll(";", "\n");
            ByteArrayInputStream is = new ByteArrayInputStream(connectionProperties.getBytes());
            try {
                this.connectionProps.load(is);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not load connection properties", ioe);
            }
        }
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties props = this.getConnectionProperties(subject, cri);
        Properties copy = (Properties)props.clone();
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            Properties logCopy = copy;
            if (copy.getProperty("password") != null) {
                logCopy = (Properties)props.clone();
                logCopy.setProperty("password", "--hidden--");
            }
            this.log.trace((Object)("Using properties: " + logCopy));
        }
        if (this.urlSelector != null) {
            return this.getHALocalManagedConnection(props, copy);
        }
        return this.getLocalManagedConnection(props, copy);
    }

    private LocalManagedConnection getLocalManagedConnection(Properties props, Properties copy) throws ResourceException {
        Connection con = null;
        try {
            String url = this.getConnectionURL();
            Driver d = this.getDriver(url);
            con = d.connect(url, copy);
            if (con == null) {
                throw new ResourceException("Wrong driver class [" + d.getClass() + "] for this connection URL [" + url + "]");
            }
            return new LocalManagedConnection(this, con, props, this.transactionIsolation, (int)this.preparedStatementCacheSize);
        }
        catch (Throwable e) {
            if (con != null) {
                try {
                    con.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
            throw new ResourceException("Could not create connection", e);
        }
    }

    private LocalManagedConnection getHALocalManagedConnection(Properties props, Properties copy) throws ResourceException {
        boolean trace = this.log.isTraceEnabled();
        for (int i = 0; i < this.urlSelector.getCustomSortedUrls().size(); ++i) {
            String url = (String)this.urlSelector.getUrlObject();
            if (trace) {
                this.log.trace((Object)("Trying to create a connection to " + url));
            }
            Connection con = null;
            try {
                Driver d = this.getDriver(url);
                con = d.connect(url, copy);
                if (con != null) {
                    return new LocalManagedConnection(this, con, props, this.transactionIsolation, (int)this.preparedStatementCacheSize);
                }
                this.log.warn((Object)("Wrong driver class [" + d.getClass() + "] for this connection URL: " + url));
                this.urlSelector.failedUrlObject(url);
                continue;
            }
            catch (Exception e) {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                }
                this.log.warn((Object)("Failed to create connection for " + url + ": " + e.getMessage()));
                this.urlSelector.failedUrlObject(url);
            }
        }
        throw new ResourceException("Could not create connection using any of the URLs: " + this.urlSelector.getAllUrlObjects());
    }

    @Override
    public void setURLDelimiter(String urlDelimiter) {
        this.urlDelimiter = urlDelimiter;
        if (this.getConnectionURL() != null) {
            this.initUrlSelector();
        }
    }

    protected void initUrlSelector() {
        String url;
        boolean trace = this.log.isTraceEnabled();
        ArrayList<String> urlsList = new ArrayList<String>();
        String urlsStr = this.getConnectionURL();
        int urlStart = 0;
        int urlEnd = urlsStr.indexOf(this.urlDelimiter);
        while (urlEnd > 0) {
            url = urlsStr.substring(urlStart, urlEnd);
            urlsList.add(url);
            urlStart = ++urlEnd;
            urlEnd = urlsStr.indexOf(this.urlDelimiter, urlEnd);
            if (!trace) continue;
            this.log.trace((Object)("added HA connection url: " + url));
        }
        if (urlStart != urlsStr.length()) {
            url = urlsStr.substring(urlStart, urlsStr.length());
            urlsList.add(url);
            if (trace) {
                this.log.trace((Object)("added HA connection url: " + url));
            }
        }
        if (this.getUrlSelectorStrategyClassName() == null) {
            this.urlSelector = new URLSelector(urlsList);
            this.log.debug((Object)("Default URLSelectorStrategy is being used : " + this.urlSelector));
        } else {
            this.urlSelector = (URLSelectorStrategy)this.loadClass(this.getUrlSelectorStrategyClassName(), urlsList);
            this.log.debug((Object)("Customized URLSelectorStrategy is being used : " + this.urlSelector));
        }
    }

    public ManagedConnection matchManagedConnections(Set mcs, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties newProps = this.getConnectionProperties(subject, cri);
        for (Object o : mcs) {
            if (!(o instanceof LocalManagedConnection)) continue;
            LocalManagedConnection mc = (LocalManagedConnection)o;
            if (Boolean.TRUE.equals(this.getReauthEnabled())) {
                return mc;
            }
            if (!mc.getProperties().equals(newProps) || (!this.getValidateOnMatch().booleanValue() || !mc.checkValid()) && this.getValidateOnMatch().booleanValue()) continue;
            return mc;
        }
        return null;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.connectionURL == null ? 0 : this.connectionURL.hashCode());
        result = result * 37 + (this.driverClass == null ? 0 : this.driverClass.hashCode());
        result = result * 37 + (this.userName == null ? 0 : this.userName.hashCode());
        result = result * 37 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 37 + this.transactionIsolation;
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        LocalManagedConnectionFactory otherMcf = (LocalManagedConnectionFactory)other;
        return this.connectionURL.equals(otherMcf.connectionURL) && this.driverClass.equals(otherMcf.driverClass) && (this.userName == null ? otherMcf.userName == null : this.userName.equals(otherMcf.userName)) && (this.password == null ? otherMcf.password == null : this.password.equals(otherMcf.password)) && this.transactionIsolation == otherMcf.transactionIsolation;
    }

    protected synchronized Driver getDriver(String url) throws ResourceException {
        boolean trace = this.log.isTraceEnabled();
        if (this.driver != null) {
            return this.driver;
        }
        if (trace) {
            this.log.trace((Object)("Checking driver for URL: " + url));
        }
        if (this.driverClass == null) {
            throw new ResourceException("No Driver class specified (url = " + url + ")!");
        }
        this.driver = driverCache.get(url.substring(0, url.indexOf(":", 6)));
        try {
            Class<?> clazz = Class.forName(this.driverClass, true, this.getClassLoaderPlugin().getClassLoader());
            if (this.isDriverLoadedForURL(url)) {
                return this.driver;
            }
            this.driver = (Driver)clazz.newInstance();
            DriverManager.registerDriver(this.driver);
            this.log.debug((Object)("class loaded and instance created:" + this.driver));
            driverCache.put(url.substring(0, url.indexOf(":", 6)), this.driver);
        }
        catch (Exception e) {
            throw new ResourceException("Failed to register driver for: " + this.driverClass, (Throwable)e);
        }
        return this.driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDriverLoadedForURL(String url) {
        boolean trace = this.log.isTraceEnabled();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoaderPlugin().getClassLoader());
            this.driver = DriverManager.getDriver(url);
            if (trace) {
                this.log.trace((Object)("Driver already registered for url: " + url));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (trace) {
                this.log.trace((Object)("Driver not yet registered for url: " + url));
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    protected String internalGetConnectionURL() {
        return this.connectionURL;
    }

    public static class URLSelector
    implements URLSelectorStrategy {
        private final List<String> urls;
        private int urlIndex;
        private String url;

        public URLSelector(List<String> urls) {
            if (urls == null || urls.size() == 0) {
                throw new IllegalStateException("Expected non-empty list of connection URLs but got: " + urls);
            }
            this.urls = Collections.unmodifiableList(urls);
        }

        public synchronized String getUrl() {
            if (this.url == null) {
                if (this.urlIndex == this.urls.size()) {
                    this.urlIndex = 0;
                }
                this.url = this.urls.get(this.urlIndex++);
            }
            return this.url;
        }

        public synchronized void failedUrl(String url) {
            if (url.equals(this.url)) {
                this.url = null;
            }
        }

        @Override
        public List<?> getCustomSortedUrls() {
            return this.urls;
        }

        @Override
        public void failedUrlObject(Object urlObject) {
            this.failedUrl((String)urlObject);
        }

        @Override
        public List<?> getAllUrlObjects() {
            return this.urls;
        }

        @Override
        public Object getUrlObject() {
            return this.getUrl();
        }
    }
}

