package org.jboss.jca.embedded.dsl.resourceadapters13.impl; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.jca.embedded.dsl.resourceadapters13.api.WorkmanagerSecurityType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.jca.embedded.dsl.resourceadapters13.api.WorkmanagerSecurityGroupsType;
import org.jboss.jca.embedded.dsl.resourceadapters13.impl.WorkmanagerSecurityGroupsTypeImpl;
import org.jboss.jca.embedded.dsl.resourceadapters13.api.WorkmanagerSecurityMappingsType;
import org.jboss.jca.embedded.dsl.resourceadapters13.impl.WorkmanagerSecurityMappingsTypeImpl;

/**
 * This class implements the <code> workmanagerSecurityType </code> xsd type 
 */
public class WorkmanagerSecurityTypeImpl<T> implements Child<T>, WorkmanagerSecurityType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public WorkmanagerSecurityTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public WorkmanagerSecurityTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WorkmanagerSecurityType ElementName: xsd:boolean ElementType : mapping-required
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>mapping-required</code> element
    * @param mappingRequired the value for the element <code>mapping-required</code> 
    * @return the current instance of <code>WorkmanagerSecurityType<T></code> 
    */
   public WorkmanagerSecurityType<T> mappingRequired(Boolean mappingRequired)
   {
      childNode.getOrCreate("mapping-required").text(mappingRequired);
      return this;
   }

   /**
    * Returns the <code>mapping-required</code> element
    * @return the node defined for the element <code>mapping-required</code> 
    */
   public Boolean isMappingRequired()
   {
      return Strings.isTrue(childNode.getTextValueForPatternName("mapping-required"));
   }

   /**
    * Removes the <code>mapping-required</code> element 
    * @return the current instance of <code>WorkmanagerSecurityType<T></code> 
    */
   public WorkmanagerSecurityType<T> removeMappingRequired()
   {
      childNode.removeChildren("mapping-required");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WorkmanagerSecurityType ElementName: xsd:token ElementType : domain
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>domain</code> element
    * @param domain the value for the element <code>domain</code> 
    * @return the current instance of <code>WorkmanagerSecurityType<T></code> 
    */
   public WorkmanagerSecurityType<T> domain(String domain)
   {
      childNode.getOrCreate("domain").text(domain);
      return this;
   }

   /**
    * Returns the <code>domain</code> element
    * @return the node defined for the element <code>domain</code> 
    */
   public String getDomain()
   {
      return childNode.getTextValueForPatternName("domain");
   }

   /**
    * Removes the <code>domain</code> element 
    * @return the current instance of <code>WorkmanagerSecurityType<T></code> 
    */
   public WorkmanagerSecurityType<T> removeDomain()
   {
      childNode.removeChildren("domain");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WorkmanagerSecurityType ElementName: xsd:token ElementType : default-principal
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>default-principal</code> element
    * @param defaultPrincipal the value for the element <code>default-principal</code> 
    * @return the current instance of <code>WorkmanagerSecurityType<T></code> 
    */
   public WorkmanagerSecurityType<T> defaultPrincipal(String defaultPrincipal)
   {
      childNode.getOrCreate("default-principal").text(defaultPrincipal);
      return this;
   }

   /**
    * Returns the <code>default-principal</code> element
    * @return the node defined for the element <code>default-principal</code> 
    */
   public String getDefaultPrincipal()
   {
      return childNode.getTextValueForPatternName("default-principal");
   }

   /**
    * Removes the <code>default-principal</code> element 
    * @return the current instance of <code>WorkmanagerSecurityType<T></code> 
    */
   public WorkmanagerSecurityType<T> removeDefaultPrincipal()
   {
      childNode.removeChildren("default-principal");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WorkmanagerSecurityType ElementName: resource-adapters:workmanagerSecurityGroupsType ElementType : default-groups
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>default-groups</code> element with the given value will be created.
    * Otherwise, the existing <code>default-groups</code> element will be returned.
    * @return  a new or existing instance of <code>WorkmanagerSecurityGroupsType<WorkmanagerSecurityType<T>></code> 
    */
   public WorkmanagerSecurityGroupsType<WorkmanagerSecurityType<T>> getOrCreateDefaultGroups()
   {
      Node node = childNode.getOrCreate("default-groups");
      WorkmanagerSecurityGroupsType<WorkmanagerSecurityType<T>> defaultGroups = new WorkmanagerSecurityGroupsTypeImpl<WorkmanagerSecurityType<T>>(this, "default-groups", childNode, node);
      return defaultGroups;
   }

   /**
    * Removes the <code>default-groups</code> element 
    * @return the current instance of <code>WorkmanagerSecurityType<T></code> 
    */
   public WorkmanagerSecurityType<T> removeDefaultGroups()
   {
      childNode.removeChildren("default-groups");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WorkmanagerSecurityType ElementName: resource-adapters:workmanagerSecurityMappingsType ElementType : mappings
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>mappings</code> element with the given value will be created.
    * Otherwise, the existing <code>mappings</code> element will be returned.
    * @return  a new or existing instance of <code>WorkmanagerSecurityMappingsType<WorkmanagerSecurityType<T>></code> 
    */
   public WorkmanagerSecurityMappingsType<WorkmanagerSecurityType<T>> getOrCreateMappings()
   {
      Node node = childNode.getOrCreate("mappings");
      WorkmanagerSecurityMappingsType<WorkmanagerSecurityType<T>> mappings = new WorkmanagerSecurityMappingsTypeImpl<WorkmanagerSecurityType<T>>(this, "mappings", childNode, node);
      return mappings;
   }

   /**
    * Removes the <code>mappings</code> element 
    * @return the current instance of <code>WorkmanagerSecurityType<T></code> 
    */
   public WorkmanagerSecurityType<T> removeMappings()
   {
      childNode.removeChildren("mappings");
      return this;
   }
}
