package org.jboss.jca.embedded.dsl.ironjacamar13.impl; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.jca.embedded.dsl.ironjacamar13.api.WorkmanagerSecurityGroupsType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> workmanagerSecurityGroupsType </code> xsd type 
 */
public class WorkmanagerSecurityGroupsTypeImpl<T> implements Child<T>, WorkmanagerSecurityGroupsType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public WorkmanagerSecurityGroupsTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public WorkmanagerSecurityGroupsTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WorkmanagerSecurityGroupsType ElementName: xsd:token ElementType : group
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>group</code> elements, 
    * a new <code>group</code> element 
    * @param values list of <code>group</code> objects 
    * @return the current instance of <code>WorkmanagerSecurityGroupsType<T></code> 
    */
   public WorkmanagerSecurityGroupsType<T> group(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("group").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>group</code> elements
    * @return list of <code>group</code> 
    */
public List<String> getAllGroup()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("group");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>group</code> element 
    * @return the current instance of <code>WorkmanagerSecurityGroupsType<T></code> 
    */
   public WorkmanagerSecurityGroupsType<T> removeAllGroup()
   {
      childNode.removeChildren("group");
      return this;
   }
}
