package org.jboss.jca.embedded.dsl.ironjacamar12.api; 

/**
 * This class implements the <code> transaction-supportType </code> xsd type 
 */
public enum TransactionSupportType
{
   _NOTRANSACTION("NoTransaction"),
   _LOCALTRANSACTION("LocalTransaction"),
   _XATRANSACTION("XATransaction");

   private String value;

   TransactionSupportType (String value) { this.value = value; }

   public String toString() {return value;}

   public static TransactionSupportType getFromStringValue(String value)
   {
      for(TransactionSupportType type: TransactionSupportType.values())
      {
         if(value != null && type.toString().equals(value))
        { return type;}
      }
      return null;
   }

}

