package org.jboss.jca.embedded.dsl.resourceadapters11.api; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.jca.embedded.dsl.resourceadapters11.api.AdminObjectType;
/**
 * This interface defines the contract for the <code> admin-objectsType </code> xsd type 
 */
public interface AdminObjectsType<T> extends Child<T>
{
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AdminObjectsType ElementName: resource-adapters:admin-objectType ElementType : admin-object
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>admin-object</code> element will be created and returned.
    * Otherwise, the first existing <code>admin-object</code> element will be returned.
    * @return the instance defined for the element <code>admin-object</code> 
    */
   public AdminObjectType<AdminObjectsType<T>> getOrCreateAdminObject();

   /**
    * Creates a new <code>admin-object</code> element 
    * @return the new created instance of <code>AdminObjectType<AdminObjectsType<T>></code> 
    */
   public AdminObjectType<AdminObjectsType<T>> createAdminObject();

   /**
    * Returns all <code>admin-object</code> elements
    * @return list of <code>admin-object</code> 
    */
   public List<AdminObjectType<AdminObjectsType<T>>> getAllAdminObject();

   /**
    * Removes all <code>admin-object</code> elements 
    * @return the current instance of <code>AdminObjectType<AdminObjectsType<T>></code> 
    */
   public AdminObjectsType<T> removeAllAdminObject();
}
