package org.jboss.jca.embedded.dsl.datasources10.api; 

/**
 * This class implements the <code> transaction-isolationType </code> xsd type 
 */
public enum TransactionIsolationType
{
   _TRANSACTION_READ_UNCOMMITTED("TRANSACTION_READ_UNCOMMITTED"),
   _TRANSACTION_READ_COMMITTED("TRANSACTION_READ_COMMITTED"),
   _TRANSACTION_REPEATABLE_READ("TRANSACTION_REPEATABLE_READ"),
   _TRANSACTION_SERIALIZABLE("TRANSACTION_SERIALIZABLE"),
   _TRANSACTION_NONE("TRANSACTION_NONE");

   private String value;

   TransactionIsolationType (String value) { this.value = value; }

   public String toString() {return value;}

   public static TransactionIsolationType getFromStringValue(String value)
   {
      for(TransactionIsolationType type: TransactionIsolationType.values())
      {
         if(value != null && type.toString().equals(value))
        { return type;}
      }
      return null;
   }

}

