package org.jboss.jca.embedded.dsl.datasources12.api; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.jca.embedded.dsl.datasources12.api.ExtensionType;
import org.jboss.jca.embedded.dsl.datasources12.api.ExtensionType;
/**
 * This interface defines the contract for the <code> capacityType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 * @since Generation date :2013-02-28T09:43:16.119-05:00
 */
public interface CapacityType<T> extends Child<T>
{
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CapacityType ElementName: datasources:extensionType ElementType : incrementer
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>incrementer</code> element with the given value will be created.
    * Otherwise, the existing <code>incrementer</code> element will be returned.
    * @return  a new or existing instance of <code>ExtensionType<CapacityType<T>></code> 
    */
   public ExtensionType<CapacityType<T>> getOrCreateIncrementer();

   /**
    * Removes the <code>incrementer</code> element 
    * @return the current instance of <code>CapacityType<T></code> 
    */
   public CapacityType<T> removeIncrementer();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CapacityType ElementName: datasources:extensionType ElementType : decrementer
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>decrementer</code> element with the given value will be created.
    * Otherwise, the existing <code>decrementer</code> element will be returned.
    * @return  a new or existing instance of <code>ExtensionType<CapacityType<T>></code> 
    */
   public ExtensionType<CapacityType<T>> getOrCreateDecrementer();

   /**
    * Removes the <code>decrementer</code> element 
    * @return the current instance of <code>CapacityType<T></code> 
    */
   public CapacityType<T> removeDecrementer();
}
