/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.common;

import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.CommonDataSource;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.common.metadata.ra.common.ConfigPropertyImpl;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.connectionmanager.ConnectionManagerFactory;
import org.jboss.jca.core.connectionmanager.TxConnectionManager;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PoolFactory;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;
import org.jboss.jca.core.connectionmanager.pool.api.PrefillPool;
import org.jboss.jca.core.recovery.DefaultRecoveryPlugin;
import org.jboss.jca.core.spi.mdr.NotFoundException;
import org.jboss.jca.core.spi.recovery.RecoveryPlugin;
import org.jboss.jca.core.spi.statistics.Statistics;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecoveryRegistry;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SubjectFactory;

public abstract class AbstractDsDeployer {
    protected Logger log;
    protected TransactionIntegration transactionIntegration;
    protected XAResourceRecoveryRegistry xaResourceRecoveryRegistry;
    private ManagementRepository managementRepository = null;
    private CachedConnectionManager ccm;

    public AbstractDsDeployer(Logger log) {
        this.log = log;
        this.transactionIntegration = null;
        this.ccm = null;
    }

    public void setTransactionIntegration(TransactionIntegration value) {
        this.transactionIntegration = value;
    }

    public TransactionIntegration getTransactionIntegration() {
        return this.transactionIntegration;
    }

    public ManagementRepository getManagementRepository() {
        return this.managementRepository;
    }

    public void setManagementRepository(ManagementRepository managementRepository) {
        this.managementRepository = managementRepository;
    }

    public void setCachedConnectionManager(CachedConnectionManager value) {
        this.ccm = value;
    }

    public CachedConnectionManager getCachedConnectionManager() {
        return this.ccm;
    }

    public XAResourceRecoveryRegistry getXAResourceRecoveryRegistry() {
        return this.xaResourceRecoveryRegistry;
    }

    public void setXAResourceRecoveryRegistry(XAResourceRecoveryRegistry xAResourceRecoveryRegistry) {
        this.xaResourceRecoveryRegistry = xAResourceRecoveryRegistry;
    }

    protected CommonDeployment createObjectsAndInjectValue(URL url, String deploymentName, String uniqueJdbcLocalId, String uniqueJdbcXAId, DataSources dataSources, ClassLoader parentClassLoader) throws DeployException {
        try {
            org.jboss.jca.core.api.management.DataSource mgtDataSource;
            String jndiName;
            ArrayList<Object> cfs = new ArrayList<Object>(1);
            ArrayList<String> jndis = new ArrayList<String>(1);
            ArrayList recoveryModules = new ArrayList(1);
            ArrayList<org.jboss.jca.core.api.management.DataSource> mgts = new ArrayList<org.jboss.jca.core.api.management.DataSource>(1);
            if (uniqueJdbcLocalId != null) {
                List ds = dataSources.getDataSource();
                if (ds != null) {
                    ClassLoader jdbcLocalDeploymentCl = this.getDeploymentClassLoader(uniqueJdbcLocalId);
                    for (DataSource dataSource : ds) {
                        if (!dataSource.isEnabled().booleanValue()) continue;
                        jndiName = this.buildJndiName(dataSource.getJndiName(), dataSource.isUseJavaContext());
                        try {
                            mgtDataSource = new org.jboss.jca.core.api.management.DataSource(false);
                            Object cf = this.deployDataSource(dataSource, jndiName, uniqueJdbcLocalId, mgtDataSource, jdbcLocalDeploymentCl);
                            this.bindConnectionFactory(deploymentName, jndiName, cf);
                            cfs.add(cf);
                            jndis.add(jndiName);
                            mgts.add(mgtDataSource);
                        }
                        catch (Throwable t) {
                            this.log.error((Object)("Error during the deployment of " + jndiName), t);
                        }
                    }
                }
            } else if (dataSources.getDataSource() != null && dataSources.getDataSource().size() > 0) {
                this.log.error((Object)"Deployment of datasources disabled since jdbc-local.rar couldn't be found");
            }
            if (uniqueJdbcXAId != null) {
                List xads = dataSources.getXaDataSource();
                if (xads != null) {
                    ClassLoader jdbcXADeploymentCl = this.getDeploymentClassLoader(uniqueJdbcXAId);
                    for (XaDataSource xaDataSource : xads) {
                        if (!xaDataSource.isEnabled().booleanValue()) continue;
                        jndiName = this.buildJndiName(xaDataSource.getJndiName(), xaDataSource.isUseJavaContext());
                        try {
                            mgtDataSource = new org.jboss.jca.core.api.management.DataSource(true);
                            Object recovery = null;
                            Object cf = this.deployXADataSource(xaDataSource, jndiName, uniqueJdbcXAId, (XAResourceRecovery)recovery, mgtDataSource, jdbcXADeploymentCl);
                            recoveryModules.add(recovery);
                            this.bindConnectionFactory(deploymentName, jndiName, cf);
                            cfs.add(cf);
                            jndis.add(jndiName);
                            mgts.add(mgtDataSource);
                        }
                        catch (Throwable t) {
                            this.log.error((Object)("Error during the deployment of " + jndiName), t);
                        }
                    }
                }
            } else if (dataSources.getXaDataSource() != null && dataSources.getXaDataSource().size() > 0) {
                this.log.error((Object)"Deployment of XA datasources disabled since jdbc-xa.rar couldn't be found");
            }
            return new CommonDeployment(url, deploymentName, true, null, null, cfs.toArray(new Object[cfs.size()]), jndis.toArray(new String[jndis.size()]), null, null, recoveryModules.toArray(new XAResourceRecovery[recoveryModules.size()]), null, mgts.toArray(new org.jboss.jca.core.api.management.DataSource[mgts.size()]), parentClassLoader, this.log);
        }
        catch (Throwable t) {
            throw new DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
    }

    protected String buildJndiName(String jndiName, Boolean javaContext) {
        if (javaContext != null) {
            if (javaContext.booleanValue() && !jndiName.startsWith("java:/")) {
                jndiName = "java:/" + jndiName;
            } else if (!javaContext.booleanValue() && jndiName.startsWith("java:/")) {
                jndiName = jndiName.substring(7);
            }
        }
        return jndiName;
    }

    private Object deployDataSource(DataSource ds, String jndiName, String uniqueId, org.jboss.jca.core.api.management.DataSource mgtDs, ClassLoader cl) throws Throwable {
        this.log.debug((Object)("DataSource=" + ds));
        ManagedConnectionFactory mcf = this.createMcf(ds, uniqueId, cl);
        this.initAndInjectClassLoaderPlugin(mcf, (CommonDataSource)ds);
        PoolConfiguration pc = this.createPoolConfiguration(ds.getPool(), (CommonTimeOut)ds.getTimeOut(), (CommonValidation)ds.getValidation());
        PoolFactory pf = new PoolFactory();
        PoolStrategy strategy = PoolStrategy.ONE_POOL;
        String securityDomain = null;
        if (ds.getSecurity() != null) {
            if (ds.getSecurity().getReauthPlugin() != null) {
                strategy = PoolStrategy.REAUTH;
                securityDomain = ds.getSecurity().getSecurityDomain();
            } else if (ds.getSecurity().getSecurityDomain() != null) {
                strategy = PoolStrategy.POOL_BY_SUBJECT;
                securityDomain = ds.getSecurity().getSecurityDomain();
            }
        }
        Pool pool = pf.create(strategy, mcf, pc, false);
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        if (ds.getTimeOut() != null) {
            allocationRetry = ds.getTimeOut().getAllocationRetry();
            allocationRetryWaitMillis = ds.getTimeOut().getAllocationRetryWaitMillis();
        }
        mgtDs.setJndiName(jndiName);
        mgtDs.setPoolConfiguration(pc);
        mgtDs.setPool((org.jboss.jca.core.api.connectionmanager.pool.Pool)pool);
        if (mcf instanceof Statistics) {
            mgtDs.setStatistics(((Statistics)mcf).getStatistics());
        }
        this.log.debugf("Adding management datasource: %s", (Object)mgtDs);
        this.getManagementRepository().getDataSources().add(mgtDs);
        FlushStrategy flushStrategy = FlushStrategy.FAILING_CONNECTION_ONLY;
        if (ds.getPool() != null) {
            flushStrategy = ds.getPool().getFlushStrategy();
        }
        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
        TxConnectionManager cm = cmf.createTransactional(tsl, pool, this.getSubjectFactory(securityDomain), securityDomain, ds.isUseCcm(), this.getCachedConnectionManager(), flushStrategy, allocationRetry, allocationRetryWaitMillis, this.getTransactionIntegration(), null, null, null, null, null);
        cm.setJndiName(jndiName);
        String poolName = null;
        if (ds.getPoolName() != null) {
            poolName = ds.getPoolName();
        }
        if (poolName == null) {
            poolName = jndiName;
        }
        pool.setName(poolName);
        if (ds.isSpy()) {
            this.injectValue(mcf, "setSpy", Boolean.TRUE);
            this.injectValue(mcf, "setJndiName", jndiName);
        }
        if (strategy == PoolStrategy.REAUTH) {
            this.injectValue(mcf, "setReauthEnabled", Boolean.TRUE);
            this.injectValue(mcf, "setReauthPluginClassName", ds.getSecurity().getReauthPlugin().getClassName());
            Map mps = ds.getSecurity().getReauthPlugin().getConfigPropertiesMap();
            if (mps != null && mps.size() > 0) {
                StringBuilder reauthPluginProperties = new StringBuilder();
                Iterator entryIterator = mps.entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry entry = entryIterator.next();
                    reauthPluginProperties.append((String)entry.getKey());
                    reauthPluginProperties.append("|");
                    reauthPluginProperties.append((String)entry.getValue());
                    if (!entryIterator.hasNext()) continue;
                    reauthPluginProperties.append(",");
                }
                this.injectValue(mcf, "setReauthPluginProperties", reauthPluginProperties.toString());
            }
        }
        if (pool instanceof PrefillPool) {
            PrefillPool pp = (PrefillPool)pool;
            SubjectFactory subjectFactory = this.getSubjectFactory(securityDomain);
            Subject subject = null;
            if (subjectFactory != null) {
                subject = this.createSubject(subjectFactory, securityDomain, mcf);
            }
            pp.prefill(subject, null, false);
        }
        return mcf.createConnectionFactory((ConnectionManager)cm);
    }

    private Object deployXADataSource(XaDataSource ds, String jndiName, String uniqueId, XAResourceRecovery recovery, org.jboss.jca.core.api.management.DataSource mgtDs, ClassLoader cl) throws Throwable {
        this.log.debug((Object)("XaDataSource=" + ds));
        ManagedConnectionFactory mcf = this.createMcf(ds, uniqueId, cl);
        PoolConfiguration pc = this.createPoolConfiguration((CommonPool)ds.getXaPool(), (CommonTimeOut)ds.getTimeOut(), (CommonValidation)ds.getValidation());
        Boolean noTxSeparatePool = Boolean.FALSE;
        if (ds.getXaPool() != null && ds.getXaPool().isNoTxSeparatePool() != null) {
            noTxSeparatePool = ds.getXaPool().isNoTxSeparatePool();
        }
        PoolFactory pf = new PoolFactory();
        PoolStrategy strategy = PoolStrategy.ONE_POOL;
        String securityDomain = null;
        if (ds.getSecurity() != null) {
            if (ds.getSecurity().getReauthPlugin() != null) {
                strategy = PoolStrategy.REAUTH;
                securityDomain = ds.getSecurity().getSecurityDomain();
            } else if (ds.getSecurity().getSecurityDomain() != null) {
                strategy = PoolStrategy.POOL_BY_SUBJECT;
                securityDomain = ds.getSecurity().getSecurityDomain();
            }
        }
        Pool pool = pf.create(strategy, mcf, pc, noTxSeparatePool.booleanValue());
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        Boolean interleaving = null;
        Integer xaResourceTimeout = null;
        Boolean isSameRMOverride = null;
        Boolean wrapXAResource = null;
        Boolean padXid = null;
        if (ds.getTimeOut() != null) {
            allocationRetry = ds.getTimeOut().getAllocationRetry();
            allocationRetryWaitMillis = ds.getTimeOut().getAllocationRetryWaitMillis();
            xaResourceTimeout = ds.getTimeOut().getXaResourceTimeout();
        }
        if (ds.getXaPool() != null) {
            interleaving = ds.getXaPool().isInterleaving();
            isSameRMOverride = ds.getXaPool().isSameRmOverride();
            wrapXAResource = ds.getXaPool().isWrapXaDataSource();
            padXid = ds.getXaPool().isPadXid();
        }
        mgtDs.setJndiName(jndiName);
        mgtDs.setPoolConfiguration(pc);
        mgtDs.setPool((org.jboss.jca.core.api.connectionmanager.pool.Pool)pool);
        if (mcf instanceof Statistics) {
            mgtDs.setStatistics(((Statistics)mcf).getStatistics());
        }
        this.log.debugf("Adding management datasource: %s", (Object)mgtDs);
        this.getManagementRepository().getDataSources().add(mgtDs);
        FlushStrategy flushStrategy = FlushStrategy.FAILING_CONNECTION_ONLY;
        if (ds.getXaPool() != null) {
            flushStrategy = ds.getXaPool().getFlushStrategy();
        }
        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
        TxConnectionManager cm = cmf.createTransactional(tsl, pool, this.getSubjectFactory(securityDomain), securityDomain, ds.isUseCcm(), this.getCachedConnectionManager(), flushStrategy, allocationRetry, allocationRetryWaitMillis, this.getTransactionIntegration(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
        cm.setJndiName(jndiName);
        String poolName = null;
        if (ds.getPoolName() != null) {
            poolName = ds.getPoolName();
        }
        if (poolName == null) {
            poolName = jndiName;
        }
        pool.setName(poolName);
        if (ds.isSpy()) {
            this.injectValue(mcf, "setSpy", Boolean.TRUE);
            this.injectValue(mcf, "setJndiName", jndiName);
        }
        if (strategy == PoolStrategy.REAUTH) {
            this.injectValue(mcf, "setReauthEnabled", Boolean.TRUE);
            this.injectValue(mcf, "setReauthPluginClassName", ds.getSecurity().getReauthPlugin().getClassName());
            Map mps = ds.getSecurity().getReauthPlugin().getConfigPropertiesMap();
            if (mps != null && mps.size() > 0) {
                StringBuilder reauthPluginProperties = new StringBuilder();
                Iterator entryIterator = mps.entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry entry = entryIterator.next();
                    reauthPluginProperties.append((String)entry.getKey());
                    reauthPluginProperties.append("|");
                    reauthPluginProperties.append((String)entry.getValue());
                    if (!entryIterator.hasNext()) continue;
                    reauthPluginProperties.append(",");
                }
                this.injectValue(mcf, "setReauthPluginProperties", reauthPluginProperties.toString());
            }
        }
        Recovery recoveryMD = ds.getRecovery();
        String defaultSecurityDomain = null;
        String defaultUserName = null;
        String defaultPassword = null;
        if (ds.getSecurity() != null) {
            defaultSecurityDomain = ds.getSecurity().getSecurityDomain();
            defaultUserName = ds.getSecurity().getUserName();
            defaultPassword = ds.getSecurity().getPassword();
        }
        String recoverSecurityDomain = defaultSecurityDomain;
        String recoverUser = defaultUserName;
        String recoverPassword = defaultPassword;
        XAResourceRecovery recoveryImpl = null;
        if (recoveryMD == null || !recoveryMD.getNoRecovery().booleanValue()) {
            Credential credential;
            Credential credential2 = credential = recoveryMD != null ? recoveryMD.getCredential() : null;
            if (credential != null) {
                recoverSecurityDomain = credential.getSecurityDomain();
                recoverUser = credential.getUserName();
                recoverPassword = credential.getPassword();
            }
            if (this.log.isDebugEnabled()) {
                if (recoverUser != null) {
                    this.log.debug((Object)("RecoverUser=" + recoverUser));
                } else if (recoverSecurityDomain != null) {
                    this.log.debug((Object)("RecoverSecurityDomain=" + recoverSecurityDomain));
                }
            }
            DefaultRecoveryPlugin plugin = null;
            if (recoveryMD != null && recoveryMD.getRecoverPlugin() != null) {
                ArrayList<ConfigPropertyImpl> configProperties = null;
                if (recoveryMD.getRecoverPlugin().getConfigPropertiesMap() != null) {
                    configProperties = new ArrayList<ConfigPropertyImpl>(recoveryMD.getRecoverPlugin().getConfigPropertiesMap().size());
                    for (Map.Entry property : recoveryMD.getRecoverPlugin().getConfigPropertiesMap().entrySet()) {
                        ConfigPropertyImpl c = new ConfigPropertyImpl(null, new XsdString((String)property.getKey(), null), new XsdString("String", null), new XsdString((String)property.getValue(), null), null);
                        configProperties.add(c);
                    }
                    plugin = (RecoveryPlugin)this.initAndInject(recoveryMD.getRecoverPlugin().getClassName(), configProperties, cl);
                }
            } else {
                plugin = new DefaultRecoveryPlugin();
            }
            recoveryImpl = this.getTransactionIntegration().createXAResourceRecovery(mcf, padXid, isSameRMOverride, wrapXAResource, recoverUser, recoverPassword, recoverSecurityDomain, this.getSubjectFactory(recoverSecurityDomain), (RecoveryPlugin)plugin);
        }
        if (this.getTransactionIntegration().getRecoveryRegistry() != null && recoveryImpl != null) {
            recoveryImpl.setJndiName(cm.getJndiName());
            this.getTransactionIntegration().getRecoveryRegistry().addXAResourceRecovery(recoveryImpl);
            recovery = recoveryImpl;
        }
        if (pool instanceof PrefillPool) {
            PrefillPool pp = (PrefillPool)pool;
            SubjectFactory subjectFactory = this.getSubjectFactory(securityDomain);
            Subject subject = null;
            if (subjectFactory != null) {
                subject = this.createSubject(subjectFactory, securityDomain, mcf);
            }
            pp.prefill(subject, null, noTxSeparatePool.booleanValue());
        }
        return mcf.createConnectionFactory((ConnectionManager)cm);
    }

    protected abstract ManagedConnectionFactory createMcf(XaDataSource var1, String var2, ClassLoader var3) throws NotFoundException, Exception, DeployException;

    protected abstract ManagedConnectionFactory createMcf(DataSource var1, String var2, ClassLoader var3) throws NotFoundException, Exception, DeployException;

    private PoolConfiguration createPoolConfiguration(CommonPool pp, CommonTimeOut tp, CommonValidation vp) {
        PoolConfiguration pc = new PoolConfiguration();
        if (pp != null) {
            if (pp.getMinPoolSize() != null) {
                pc.setMinSize(pp.getMinPoolSize().intValue());
            }
            if (pp.getMaxPoolSize() != null) {
                pc.setMaxSize(pp.getMaxPoolSize().intValue());
            }
            if (pp.isPrefill() != null) {
                pc.setPrefill(pp.isPrefill().booleanValue());
            }
            if (pp.isUseStrictMin() != null) {
                pc.setStrictMin(pp.isUseStrictMin().booleanValue());
            }
        }
        if (tp != null) {
            if (tp.getBlockingTimeoutMillis() != null) {
                pc.setBlockingTimeout(tp.getBlockingTimeoutMillis().longValue());
            }
            if (tp.getIdleTimeoutMinutes() != null) {
                pc.setIdleTimeout(tp.getIdleTimeoutMinutes().longValue());
            }
        }
        if (vp != null) {
            if (vp.isBackgroundValidation() != null) {
                pc.setBackgroundValidation(vp.isBackgroundValidation().booleanValue());
            }
            if (vp.getBackgroundValidationMinutes() != null) {
                pc.setBackgroundValidationMinutes(vp.getBackgroundValidationMinutes().intValue());
            }
            if (vp.isUseFastFail() != null) {
                pc.setUseFastFail(vp.isUseFastFail().booleanValue());
            }
        }
        return pc;
    }

    private void injectValue(Object o, String methodName, Object value) throws Exception {
        Method[] methods = o.getClass().getMethods();
        if (methods != null) {
            boolean found = false;
            for (int i = 0; !found && i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.getName().equals(methodName) || m.getParameterTypes().length != 1) continue;
                m.invoke(o, value);
                found = true;
            }
        }
    }

    protected abstract ClassLoader getDeploymentClassLoader(String var1);

    protected abstract String[] bindConnectionFactory(String var1, String var2, Object var3) throws Throwable;

    protected abstract Object initAndInject(String var1, List<? extends ConfigProperty> var2, ClassLoader var3) throws DeployException;

    protected void initAndInjectClassLoaderPlugin(ManagedConnectionFactory mcf, CommonDataSource dsMetadata) throws DeployException {
    }

    protected abstract SubjectFactory getSubjectFactory(String var1) throws DeployException;

    protected Subject createSubject(final SubjectFactory subjectFactory, final String securityDomain, final ManagedConnectionFactory mcf) {
        if (subjectFactory == null) {
            throw new IllegalArgumentException("SubjectFactory is null");
        }
        if (securityDomain == null) {
            throw new IllegalArgumentException("SecurityDomain is null");
        }
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                try {
                    SecurityContext securityContext = SecurityContextFactory.createSecurityContext((String)securityDomain);
                    SecurityContextAssociation.setSecurityContext((SecurityContext)securityContext);
                    Subject unauthenticated = new Subject();
                    securityContext.getSubjectInfo().setAuthenticatedSubject(unauthenticated);
                    Subject subject = subjectFactory.createSubject(securityDomain);
                    Set<PasswordCredential> pcs = subject.getPrivateCredentials(PasswordCredential.class);
                    if (pcs != null && pcs.size() > 0) {
                        for (PasswordCredential pc : pcs) {
                            pc.setManagedConnectionFactory(mcf);
                        }
                    }
                    if (AbstractDsDeployer.this.log.isDebugEnabled()) {
                        AbstractDsDeployer.this.log.debug((Object)("Subject=" + subject));
                    }
                    return subject;
                }
                catch (Throwable t) {
                    AbstractDsDeployer.this.log.error((Object)("Exception during createSubject()" + t.getMessage()), t);
                    return null;
                }
            }
        });
    }
}

