/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.TransactionSupport;
import javax.transaction.TransactionManager;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.AdminObject;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.MessageListener;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.ra10.ResourceAdapter10;
import org.jboss.jca.core.api.bootstrap.CloneableBootstrapContext;
import org.jboss.jca.core.connectionmanager.ConnectionManagerFactory;
import org.jboss.jca.core.connectionmanager.NoTxConnectionManager;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.pool.api.PoolFactory;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;
import org.jboss.jca.core.spi.mdr.AlreadyExistsException;
import org.jboss.jca.deployers.common.BeanValidation;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.Configuration;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.jca.validator.Failure;
import org.jboss.jca.validator.FailureHelper;
import org.jboss.jca.validator.Key;
import org.jboss.jca.validator.Validate;
import org.jboss.jca.validator.ValidateClass;
import org.jboss.jca.validator.ValidateObject;
import org.jboss.jca.validator.Validator;
import org.jboss.jca.validator.ValidatorException;
import org.jboss.logging.Logger;

public abstract class AbstractResourceAdapterDeployer {
    protected final Logger log;
    protected final boolean trace;
    protected final boolean validateClasses;
    private Configuration configuration = null;

    public AbstractResourceAdapterDeployer(boolean validateClasses, Logger log) {
        this.log = log;
        this.trace = log.isTraceEnabled();
        this.validateClasses = validateClasses;
    }

    public void setConfiguration(Configuration value) {
        this.configuration = value;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Set<Failure> validateArchive(URL url, List<Validate> archiveValidation, Set<Failure> failures) {
        if (!this.getConfiguration().getArchiveValidation()) {
            return null;
        }
        for (Validate validate : archiveValidation) {
            if (validate instanceof ValidateObject || this.validateClasses) continue;
            return null;
        }
        Validator validator = new Validator();
        List partialFailures = validator.validate(archiveValidation);
        if (partialFailures != null) {
            if (failures == null) {
                failures = new HashSet<Failure>();
            }
            failures.addAll(partialFailures);
        }
        return failures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printFailuresLog(String urlFileName, Validator validator, Collection<Failure> failures, File reportDirectory, FailureHelper ... fhInput) {
        String errorText = "";
        FailureHelper fh = null;
        fh = fhInput.length == 0 ? new FailureHelper(failures) : fhInput[0];
        if (failures != null && failures.size() > 0) {
            if (reportDirectory == null) {
                reportDirectory = this.getReportDirectory();
            }
            if (reportDirectory != null && reportDirectory.exists()) {
                int lastSepaIndex;
                int lastIndex;
                int lastSlashIndex = urlFileName.lastIndexOf("/");
                int n = lastIndex = lastSlashIndex > (lastSepaIndex = urlFileName.lastIndexOf(File.separator)) ? lastSlashIndex : lastSepaIndex;
                if (lastIndex != -1) {
                    urlFileName = urlFileName.substring(lastIndex + 1);
                }
                urlFileName = urlFileName + ".log";
                File report = new File(reportDirectory, urlFileName);
                FileWriter fw = null;
                BufferedWriter bw = null;
                try {
                    fw = new FileWriter(report);
                    bw = new BufferedWriter(fw, 8192);
                    bw.write(fh.asText(validator.getResourceBundle()));
                    bw.flush();
                    errorText = "Validation failures - see: " + report.getAbsolutePath();
                }
                catch (IOException ioe) {
                    this.log.warn((Object)ioe.getMessage(), (Throwable)ioe);
                }
                finally {
                    if (bw != null) {
                        try {
                            bw.close();
                        }
                        catch (IOException ignore) {}
                    }
                    if (fw != null) {
                        try {
                            fw.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            } else {
                errorText = fh.asText(validator.getResourceBundle());
            }
        }
        return errorText;
    }

    protected boolean hasFailuresLevel(Collection<Failure> failures, int severity) {
        if (failures != null) {
            for (Failure failure : failures) {
                if (failure.getSeverity() != severity) continue;
                return true;
            }
        }
        return false;
    }

    protected void startContext(ResourceAdapter resourceAdapter, String bootstrapIdentifier) throws DeployException {
        try {
            CloneableBootstrapContext bc;
            Class<?> clz = resourceAdapter.getClass();
            Method start = clz.getMethod("start", BootstrapContext.class);
            CloneableBootstrapContext cbc = null;
            if (bootstrapIdentifier != null && this.getConfiguration().getBootstrapContexts() != null && (bc = this.getConfiguration().getBootstrapContexts().get(bootstrapIdentifier)) != null) {
                cbc = bc.clone();
            }
            if (cbc == null) {
                cbc = this.getConfiguration().getDefaultBootstrapContext().clone();
            }
            start.invoke((Object)resourceAdapter, cbc);
        }
        catch (InvocationTargetException ite) {
            throw new DeployException("Unable to start " + resourceAdapter.getClass().getName(), ite.getTargetException());
        }
        catch (Throwable t) {
            throw new DeployException("Unable to start " + resourceAdapter.getClass().getName(), t);
        }
    }

    protected void associateResourceAdapter(ResourceAdapter resourceAdapter, Object object) throws DeployException {
        if (resourceAdapter != null && object != null && object instanceof ResourceAdapterAssociation) {
            try {
                Class<?> clz = object.getClass();
                Method setResourceAdapter = clz.getMethod("setResourceAdapter", ResourceAdapter.class);
                setResourceAdapter.invoke(object, resourceAdapter);
            }
            catch (Throwable t) {
                throw new DeployException("Unable to associate " + object.getClass().getName(), t);
            }
        }
    }

    protected CommonConnDef findConnectionDefinition(String clz, List<CommonConnDef> defs) {
        if (defs != null) {
            if (defs.size() == 1) {
                CommonConnDef cd = defs.get(0);
                if (cd.getClassName() != null && !clz.equals(cd.getClassName())) {
                    this.log.warn((Object)("Only one connection definitopn found with a mis-match in class-name: " + cd));
                    return null;
                }
                return cd;
            }
            if (clz == null) {
                throw new IllegalArgumentException("ManagedConnectionFactory must be defined in class-name");
            }
            for (CommonConnDef cd : defs) {
                if (!clz.equals(cd.getClassName())) continue;
                return cd;
            }
        }
        return null;
    }

    protected PoolConfiguration createPoolConfiguration(CommonPool pp, CommonTimeOut tp, CommonValidation vp) {
        PoolConfiguration pc = new PoolConfiguration();
        if (pp != null) {
            if (pp.getMinPoolSize() != null) {
                pc.setMinSize(pp.getMinPoolSize().intValue());
            }
            if (pp.getMaxPoolSize() != null) {
                pc.setMaxSize(pp.getMaxPoolSize().intValue());
            }
            if (pp.isPrefill() != null) {
                pc.setPrefill(pp.isPrefill().booleanValue());
            }
            if (pp.isUseStrictMin() != null) {
                pc.setStrictMin(pp.isUseStrictMin().booleanValue());
            }
        }
        if (tp != null) {
            if (tp.getBlockingTimeoutMillis() != null) {
                pc.setBlockingTimeout(tp.getBlockingTimeoutMillis().longValue());
            }
            if (tp.getIdleTimeoutMinutes() != null) {
                pc.setIdleTimeout(tp.getIdleTimeoutMinutes().longValue());
            }
        }
        if (vp != null) {
            if (vp.isBackgroundValidation() != null) {
                pc.setBackgroundValidation(vp.isBackgroundValidation().booleanValue());
            }
            if (vp.getBackgroundValidationMinutes() != null) {
                pc.setBackgroundValidationMinutes(vp.getBackgroundValidationMinutes().intValue());
            }
            if (vp.isUseFastFail() != null) {
                pc.setUseFastFail(vp.isUseFastFail().booleanValue());
            }
        }
        return pc;
    }

    public void start() {
        if (!this.checkConfigurationIsValid()) {
            throw new IllegalStateException("Configuration not valid or not defined");
        }
    }

    protected Set<Failure> initActivationSpec(ClassLoader cl, Connector cmd, ResourceAdapter resourceAdapter, List<Validate> archiveValidationObjects, List<Object> beanValidationObjects, Set<Failure> failures, URL url, boolean activateDeployment) throws DeployException {
        List mlMetas;
        ResourceAdapter1516 ra1516;
        if (cmd.getVersion() != Connector.Version.V_10 && (ra1516 = (ResourceAdapter1516)cmd.getResourceadapter()) != null && ra1516.getInboundResourceadapter() != null && ra1516.getInboundResourceadapter().getMessageadapter() != null && ra1516.getInboundResourceadapter().getMessageadapter().getMessagelisteners() != null && (mlMetas = ra1516.getInboundResourceadapter().getMessageadapter().getMessagelisteners()).size() > 0) {
            for (MessageListener mlMD : mlMetas) {
                if (mlMD.getActivationspec() == null || mlMD.getActivationspec().getActivationspecClass().getValue() == null) continue;
                failures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.ACTIVATION_SPEC, mlMD.getActivationspec().getActivationspecClass().getValue(), cl, mlMD.getActivationspec().getConfigProperties())), failures);
                if (this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1) || !activateDeployment) continue;
                List cpm = mlMD.getActivationspec().getConfigProperties();
                Object o = this.initAndInject(mlMD.getActivationspec().getActivationspecClass().getValue(), cpm, cl);
                if (this.trace) {
                    this.log.trace((Object)("ActivationSpec: " + o.getClass().getName()));
                    this.log.trace((Object)("ActivationSpec defined in classloader: " + o.getClass().getClassLoader()));
                }
                archiveValidationObjects.add((Validate)new ValidateObject(Key.ACTIVATION_SPEC, o, cpm));
                beanValidationObjects.add(o);
                this.associateResourceAdapter(resourceAdapter, o);
            }
        }
        return failures;
    }

    protected Set<Failure> initAdminObject(Connector cmd, ClassLoader cl, List<Validate> archiveValidationObjects, List<Object> beanValidationObjects, Set<Failure> failures, URL url, boolean activateDeployment) throws DeployException {
        List aoMetas;
        ResourceAdapter1516 ra1516;
        if (cmd.getVersion() != Connector.Version.V_10 && (ra1516 = (ResourceAdapter1516)cmd.getResourceadapter()) != null && ra1516.getAdminObjects() != null && (aoMetas = ((ResourceAdapter1516)cmd.getResourceadapter()).getAdminObjects()).size() > 0) {
            for (AdminObject aoMeta : aoMetas) {
                if (aoMeta.getAdminobjectClass() == null || aoMeta.getAdminobjectClass().getValue() == null) continue;
                failures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.ADMIN_OBJECT, aoMeta.getAdminobjectClass().getValue(), cl, aoMeta.getConfigProperties())), failures);
                if (this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1) || !activateDeployment) continue;
                Object o = this.initAndInject(aoMeta.getAdminobjectClass().getValue(), aoMeta.getConfigProperties(), cl);
                if (this.trace) {
                    this.log.trace((Object)("AdminObject: " + o.getClass().getName()));
                    this.log.trace((Object)("AdminObject defined in classloader: " + o.getClass().getClassLoader()));
                }
                archiveValidationObjects.add((Validate)new ValidateObject(Key.ADMIN_OBJECT, o, aoMeta.getConfigProperties()));
                beanValidationObjects.add(o);
            }
        }
        return failures;
    }

    protected abstract boolean checkActivation(Connector var1, IronJacamar var2);

    protected abstract Object initAndInject(String var1, List<? extends ConfigProperty> var2, ClassLoader var3) throws DeployException;

    protected CommonDeployment createObjectsAndInjectValue(URL url, String deploymentName, File root, ClassLoader cl, Connector cmd, IronJacamar ijmd) throws DeployException, ResourceException, ValidatorException, AlreadyExistsException, ClassNotFoundException, Throwable {
        Set<Failure> failures = null;
        try {
            boolean activateDeployment;
            String[] jndiNames;
            Object[] cfs;
            ArrayList<Object> beanValidationObjects;
            ArrayList<Validate> archiveValidationObjects;
            ResourceAdapter resourceAdapter;
            block59: {
                block61: {
                    List cdMetas;
                    block60: {
                        CommonXaPool ijXaPool;
                        ResourceAdapter1516 ra1516;
                        if (cmd != null && cmd.getLicense() != null && cmd.getLicense().isLicenseRequired()) {
                            this.log.info((Object)("Required license terms for " + url.toExternalForm()));
                        }
                        resourceAdapter = null;
                        archiveValidationObjects = new ArrayList<Validate>();
                        beanValidationObjects = new ArrayList<Object>();
                        cfs = null;
                        jndiNames = null;
                        activateDeployment = this.checkActivation(cmd, ijmd);
                        if (cmd == null) break block59;
                        if (cmd.getVersion() != Connector.Version.V_10 && (ra1516 = (ResourceAdapter1516)cmd.getResourceadapter()) != null && ra1516.getResourceadapterClass() != null) {
                            failures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.RESOURCE_ADAPTER, ra1516.getResourceadapterClass(), cl, cmd.getResourceadapter().getConfigProperties())), failures);
                            if (!(this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1) || !activateDeployment)) {
                                resourceAdapter = (ResourceAdapter)this.initAndInject(ra1516.getResourceadapterClass(), ra1516.getConfigProperties(), cl);
                                if (this.trace) {
                                    this.log.trace((Object)("ResourceAdapter: " + resourceAdapter.getClass().getName()));
                                    this.log.trace((Object)("ResourceAdapter defined in classloader: " + resourceAdapter.getClass().getClassLoader()));
                                }
                                archiveValidationObjects.add((Validate)new ValidateObject(Key.RESOURCE_ADAPTER, (Object)resourceAdapter, ra1516.getConfigProperties()));
                                beanValidationObjects.add(resourceAdapter);
                            }
                        }
                        if (cmd.getVersion() != Connector.Version.V_10) break block60;
                        ResourceAdapter10 ra10 = (ResourceAdapter10)cmd.getResourceadapter();
                        if (!activateDeployment) break block61;
                        CommonConnDef ijCD = null;
                        if (ijmd != null) {
                            ijCD = this.findConnectionDefinition(ra10.getManagedConnectionFactoryClass().getValue(), ijmd.getConnectionDefinitions());
                        }
                        if (ijCD != null && !ijCD.isEnabled().booleanValue()) break block61;
                        ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(ra10.getManagedConnectionFactoryClass().getValue(), ra10.getConfigProperties(), cl);
                        if (this.trace) {
                            this.log.trace((Object)("ManagedConnectionFactory: " + mcf.getClass().getName()));
                            this.log.trace((Object)("ManagedConnectionFactory is defined in classloader: " + mcf.getClass().getClassLoader()));
                        }
                        mcf.setLogWriter(this.getLogPrintWriter());
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.MANAGED_CONNECTION_FACTORY, (Object)mcf, ra10.getConfigProperties()));
                        beanValidationObjects.add(mcf);
                        this.associateResourceAdapter(resourceAdapter, mcf);
                        PoolConfiguration poolConfiguration = this.createPoolConfiguration(ijCD != null ? ijCD.getPool() : null, ijCD != null ? ijCD.getTimeOut() : null, ijCD != null ? ijCD.getValidation() : null);
                        PoolFactory pf = new PoolFactory();
                        Boolean noTxSeparatePool = Boolean.FALSE;
                        if (ijCD != null && ijCD.getPool() != null && ijCD.isXa().booleanValue() && (ijXaPool = (CommonXaPool)ijCD.getPool()) != null) {
                            noTxSeparatePool = ijXaPool.isNoTxSeparatePool();
                        }
                        Pool pool = pf.create(PoolStrategy.ONE_POOL, mcf, poolConfiguration, noTxSeparatePool.booleanValue());
                        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
                        NoTxConnectionManager cm = null;
                        TransactionSupportEnum tsmd = TransactionSupportEnum.NoTransaction;
                        tsmd = ijmd != null && ijmd.getTransactionSupport() != null ? ijmd.getTransactionSupport() : ((ResourceAdapter10)cmd.getResourceadapter()).getTransactionSupport();
                        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                        if (tsmd == TransactionSupportEnum.NoTransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                        } else if (tsmd == TransactionSupportEnum.LocalTransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
                        } else if (tsmd == TransactionSupportEnum.XATransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
                        }
                        if (mcf instanceof TransactionSupport) {
                            tsl = ((TransactionSupport)mcf).getTransactionSupport();
                        }
                        Integer allocationRetry = null;
                        Long allocationRetryWaitMillis = null;
                        if (ijCD != null && ijCD.getTimeOut() != null) {
                            allocationRetry = ijCD.getTimeOut().getAllocationRetry();
                            allocationRetryWaitMillis = ijCD.getTimeOut().getAllocationRetryWaitMillis();
                        }
                        if (tsl == TransactionSupport.TransactionSupportLevel.NoTransaction) {
                            cm = cmf.createNonTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis);
                        } else {
                            CommonXaPool ijXaPool2;
                            Boolean interleaving = null;
                            Integer xaResourceTimeout = null;
                            Boolean isSameRMOverride = null;
                            Boolean wrapXAResource = null;
                            Boolean padXid = null;
                            if (ijCD != null && ijCD.getPool() != null && ijCD.isXa().booleanValue() && (ijXaPool2 = (CommonXaPool)ijCD.getPool()) != null) {
                                interleaving = ijXaPool2.isInterleaving();
                                isSameRMOverride = ijXaPool2.isSameRmOverride();
                                wrapXAResource = ijXaPool2.isWrapXaDataSource();
                                padXid = ijXaPool2.isPadXid();
                            }
                            cm = cmf.createTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis, this.getTransactionManager(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
                        }
                        Object cf = mcf.createConnectionFactory((ConnectionManager)cm);
                        if (cf == null) {
                            this.log.error((Object)"ConnectionFactory is null");
                        } else if (this.trace) {
                            this.log.trace((Object)("ConnectionFactory: " + cf.getClass().getName()));
                            this.log.trace((Object)("ConnectionFactory defined in classloader: " + cf.getClass().getClassLoader()));
                        }
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.CONNECTION_FACTORY, cf));
                        if (cf == null || !(cf instanceof Serializable) || !(cf instanceof Referenceable)) break block61;
                        if (ijCD != null) {
                            String jndiName = ijCD.getJndiName();
                            this.bindConnectionFactory(url, deploymentName, cf, jndiName);
                            cfs = new Object[]{cf};
                            jndiNames = new String[]{jndiName};
                            cm.setJndiName(jndiName);
                        } else {
                            jndiNames = this.bindConnectionFactory(url, deploymentName, cf);
                            cfs = new Object[]{cf};
                            cm.setJndiName(jndiNames[0]);
                        }
                        break block61;
                    }
                    ResourceAdapter1516 ra = (ResourceAdapter1516)cmd.getResourceadapter();
                    if (ra != null && ra.getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getConnectionDefinitions() != null && (cdMetas = ra.getOutboundResourceadapter().getConnectionDefinitions()).size() > 0) {
                        cfs = new Object[cdMetas.size()];
                        jndiNames = new String[cdMetas.size()];
                        for (int cdIndex = 0; cdIndex < cdMetas.size(); ++cdIndex) {
                            CommonXaPool ijXaPool;
                            ConnectionDefinition connectionDefinition = (ConnectionDefinition)cdMetas.get(cdIndex);
                            failures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.MANAGED_CONNECTION_FACTORY, connectionDefinition.getManagedConnectionFactoryClass().getValue(), cl, connectionDefinition.getConfigProperties())), failures);
                            if (this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1) || !activateDeployment) continue;
                            CommonConnDef ijCD = null;
                            if (ijmd != null) {
                                ijCD = this.findConnectionDefinition(connectionDefinition.getManagedConnectionFactoryClass().getValue(), ijmd.getConnectionDefinitions());
                            }
                            if (ijCD != null && !ijCD.isEnabled().booleanValue()) continue;
                            ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(connectionDefinition.getManagedConnectionFactoryClass().getValue(), connectionDefinition.getConfigProperties(), cl);
                            if (this.trace) {
                                this.log.trace((Object)("ManagedConnectionFactory: " + mcf.getClass().getName()));
                                this.log.trace((Object)("ManagedConnectionFactory defined in classloader: " + mcf.getClass().getClassLoader()));
                            }
                            mcf.setLogWriter(this.getLogPrintWriter());
                            archiveValidationObjects.add((Validate)new ValidateObject(Key.MANAGED_CONNECTION_FACTORY, (Object)mcf, connectionDefinition.getConfigProperties()));
                            beanValidationObjects.add(mcf);
                            this.associateResourceAdapter(resourceAdapter, mcf);
                            PoolConfiguration pc = this.createPoolConfiguration(ijCD != null ? ijCD.getPool() : null, ijCD != null ? ijCD.getTimeOut() : null, ijCD != null ? ijCD.getValidation() : null);
                            PoolFactory pf = new PoolFactory();
                            Boolean noTxSeparatePool = Boolean.FALSE;
                            if (ijCD != null && ijCD.getPool() != null && ijCD.isXa().booleanValue() && (ijXaPool = (CommonXaPool)ijCD.getPool()) != null) {
                                noTxSeparatePool = ijXaPool.isNoTxSeparatePool();
                            }
                            Pool pool = pf.create(PoolStrategy.ONE_POOL, mcf, pc, noTxSeparatePool.booleanValue());
                            ConnectionManagerFactory cmf = new ConnectionManagerFactory();
                            NoTxConnectionManager cm = null;
                            TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                            TransactionSupportEnum tsmd = TransactionSupportEnum.NoTransaction;
                            tsmd = ijmd != null && ijmd.getTransactionSupport() != null ? ijmd.getTransactionSupport() : ra.getOutboundResourceadapter().getTransactionSupport();
                            if (tsmd == TransactionSupportEnum.NoTransaction) {
                                tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                            } else if (tsmd == TransactionSupportEnum.LocalTransaction) {
                                tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
                            } else if (tsmd == TransactionSupportEnum.XATransaction) {
                                tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
                            }
                            if (mcf instanceof TransactionSupport) {
                                tsl = ((TransactionSupport)mcf).getTransactionSupport();
                            }
                            Integer allocationRetry = null;
                            Long allocationRetryWaitMillis = null;
                            if (ijCD != null && ijCD.getTimeOut() != null) {
                                allocationRetry = ijCD.getTimeOut().getAllocationRetry();
                                allocationRetryWaitMillis = ijCD.getTimeOut().getAllocationRetryWaitMillis();
                            }
                            if (tsl == TransactionSupport.TransactionSupportLevel.NoTransaction) {
                                cm = cmf.createNonTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis);
                            } else {
                                Boolean interleaving = null;
                                Integer xaResourceTimeout = null;
                                Boolean isSameRMOverride = null;
                                Boolean wrapXAResource = null;
                                Boolean padXid = null;
                                if (ijCD != null && ijCD.isXa().booleanValue()) {
                                    CommonXaPool ijXaPool3 = (CommonXaPool)ijCD.getPool();
                                    interleaving = ijXaPool3.isInterleaving();
                                    isSameRMOverride = ijXaPool3.isSameRmOverride();
                                    wrapXAResource = ijXaPool3.isWrapXaDataSource();
                                    padXid = ijXaPool3.isPadXid();
                                }
                                cm = cmf.createTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis, this.getTransactionManager(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
                            }
                            Object cf = mcf.createConnectionFactory((ConnectionManager)cm);
                            if (cf == null) {
                                this.log.error((Object)"ConnectionFactory is null");
                            } else if (this.trace) {
                                this.log.trace((Object)("ConnectionFactory: " + cf.getClass().getName()));
                                this.log.trace((Object)("ConnectionFactory defined in classloader: " + cf.getClass().getClassLoader()));
                            }
                            archiveValidationObjects.add((Validate)new ValidateObject(Key.CONNECTION_FACTORY, cf));
                            if (cf == null || !(cf instanceof Serializable) || !(cf instanceof Referenceable)) continue;
                            if (ijCD != null) {
                                String jndiName = ijCD.getJndiName();
                                this.bindConnectionFactory(url, deploymentName, cf, jndiName);
                                cfs[cdIndex] = cf;
                                jndiNames[cdIndex] = jndiName;
                                cm.setJndiName(jndiName);
                                continue;
                            }
                            jndiNames = this.bindConnectionFactory(url, deploymentName, cf);
                            cfs = new Object[]{cf};
                            cm.setJndiName(jndiNames[0]);
                        }
                    }
                }
                failures = this.initActivationSpec(cl, cmd, resourceAdapter, archiveValidationObjects, beanValidationObjects, failures, url, activateDeployment);
                failures = this.initAdminObject(cmd, cl, archiveValidationObjects, beanValidationObjects, failures, url, activateDeployment);
            }
            failures = this.validateArchive(url, archiveValidationObjects, failures);
            if (this.getConfiguration().getArchiveValidationFailOnWarn() && this.hasFailuresLevel(failures, 0) || this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) {
                throw new ValidatorException(this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]), failures);
            }
            this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]);
            if (cmd != null) {
                try {
                    this.registerResourceAdapterToMDR(url, root, cmd, ijmd);
                }
                catch (AlreadyExistsException e) {
                    // empty catch block
                }
            }
            if (activateDeployment) {
                if (this.getConfiguration().getBeanValidation()) {
                    ArrayList<Class> groupsClasses = null;
                    if (ijmd != null && ijmd.getBeanValidationGroups() != null && ijmd.getBeanValidationGroups().size() > 0) {
                        groupsClasses = new ArrayList<Class>();
                        for (String group : ijmd.getBeanValidationGroups()) {
                            groupsClasses.add(Class.forName(group, true, cl));
                        }
                    }
                    if (beanValidationObjects.size() > 0) {
                        BeanValidation beanValidator = new BeanValidation();
                        for (Object e : beanValidationObjects) {
                            beanValidator.validate(e, groupsClasses);
                        }
                    }
                }
                if (resourceAdapter != null) {
                    String bootstrapIdentifier = null;
                    if (ijmd != null) {
                        bootstrapIdentifier = ijmd.getBootstrapContext();
                    }
                    this.startContext(resourceAdapter, bootstrapIdentifier);
                }
            }
            if (activateDeployment) {
                this.log.info((Object)("Deployed: " + url.toExternalForm()));
            } else {
                this.log.debug((Object)("Activated: " + url.toExternalForm()));
            }
            return new CommonDeployment(url, deploymentName, activateDeployment, resourceAdapter, cfs, cl, this.log, jndiNames);
        }
        catch (DeployException de) {
            throw de;
        }
        catch (Throwable t) {
            if (this.getConfiguration().getArchiveValidationFailOnWarn() && this.hasFailuresLevel(failures, 0) || this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) {
                throw new DeployException("Deployment " + url.toExternalForm() + " failed", (Throwable)new ValidatorException(this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]), failures));
            }
            this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]);
            throw new DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
    }

    protected abstract File getReportDirectory();

    protected abstract void registerResourceAdapterToMDR(URL var1, File var2, Connector var3, IronJacamar var4) throws AlreadyExistsException;

    protected abstract TransactionManager getTransactionManager();

    protected abstract PrintWriter getLogPrintWriter();

    protected abstract String[] bindConnectionFactory(URL var1, String var2, Object var3) throws Throwable;

    protected abstract String[] bindConnectionFactory(URL var1, String var2, Object var3, String var4) throws Throwable;

    protected abstract boolean checkConfigurationIsValid();
}

