/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jboss.jca.codegenerator.ConfigPropType;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.xml.AbstractXmlGen;

public abstract class RaXmlGen
extends AbstractXmlGen {
    @Override
    public void writeXmlBody(Definition def, Writer out) throws IOException {
        int i;
        this.writeConnectorVersion(out);
        int indent = 1;
        this.writeIndent(out, indent);
        out.write("<vendor-name>Red Hat Inc</vendor-name>");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("<eis-type>Test RA</eis-type>");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("<resourceadapter-version>0.1</resourceadapter-version>");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("<resourceadapter>");
        this.writeEol(out);
        if (def.isUseRa()) {
            this.writeIndent(out, indent + 1);
            out.write("<resourceadapter-class>" + def.getRaPackage() + "." + def.getRaClass() + "</resourceadapter-class>");
            this.writeEol(out);
            this.writeConfigPropsXml(def.getRaConfigProps(), out, indent + 1);
        }
        if (def.isSupportOutbound()) {
            this.writeOutbound(def, out, indent + 1);
        }
        if (def.isSupportInbound()) {
            this.writeInbound(def, out, indent + 1);
        }
        if (def.isGenAdminObject() && def.getAdminObjects().size() > 0) {
            for (i = 0; i < def.getAdminObjects().size(); ++i) {
                this.writeIndent(out, indent + 1);
                out.write("<adminobject>");
                this.writeEol(out);
                this.writeIndent(out, indent + 2);
                out.write("<adminobject-interface>" + def.getRaPackage() + "." + def.getAdminObjects().get(i).getAdminObjectInterface() + "</adminobject-interface>");
                this.writeEol(out);
                this.writeIndent(out, indent + 2);
                out.write("<adminobject-class>" + def.getRaPackage() + "." + def.getAdminObjects().get(i).getAdminObjectClass() + "</adminobject-class>");
                this.writeEol(out);
                this.writeConfigPropsXml(def.getAdminObjects().get(i).getAoConfigProps(), out, indent + 2);
                this.writeIndent(out, indent + 1);
                out.write("</adminobject>");
                this.writeEol(out);
            }
        }
        if (def.getSecurityPermissions() != null && def.getSecurityPermissions().size() > 0) {
            for (i = 0; i < def.getSecurityPermissions().size(); ++i) {
                this.writeIndent(out, indent + 1);
                out.write("<security-permission>");
                this.writeEol(out);
                this.writeIndent(out, indent + 2);
                out.write("<security-permission-spec>" + def.getSecurityPermissions().get(i).getPermissionSpec() + "</security-permission-spec>");
                this.writeEol(out);
                this.writeIndent(out, indent + 1);
                out.write("</security-permission>");
                this.writeEol(out);
            }
        }
        this.writeIndent(out, indent);
        out.write("</resourceadapter>");
        this.writeEol(out);
        out.write("</connector>");
        this.writeEol(out);
    }

    abstract void writeConnectorVersion(Writer var1) throws IOException;

    void writeConfigPropsXml(List<ConfigPropType> props, Writer out, int indent) throws IOException {
        if (props == null || props.size() == 0) {
            return;
        }
        for (ConfigPropType prop : props) {
            this.writeIndent(out, indent);
            out.write("<config-property>");
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            out.write("<config-property-name>" + prop.getName() + "</config-property-name>");
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            out.write("<config-property-type>java.lang." + prop.getType() + "</config-property-type>");
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            out.write("<config-property-value>" + prop.getValue() + "</config-property-value>");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("</config-property>");
            this.writeEol(out);
            this.writeEol(out);
        }
    }

    abstract void writeAsConfigPropsXml(List<ConfigPropType> var1, Writer var2, int var3) throws IOException;

    void writeRequireConfigPropsXml(List<ConfigPropType> props, Writer out, int indent) throws IOException {
        if (props == null || props.size() == 0) {
            return;
        }
        for (ConfigPropType prop : props) {
            if (!prop.isRequired()) continue;
            this.writeIndent(out, indent);
            out.write("<required-config-property>");
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            out.write("<config-property-name>" + prop.getName() + "</config-property-name>");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("</required-config-property>");
            this.writeEol(out);
        }
        this.writeEol(out);
    }

    private void writeInbound(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("<inbound-resourceadapter>");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("<messageadapter>");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("<messagelistener>");
        this.writeEol(out);
        this.writeIndent(out, indent + 3);
        if (!def.isDefaultPackageInbound()) {
            out.write("<messagelistener-type>" + def.getMlClass() + "</messagelistener-type>");
        } else {
            out.write("<messagelistener-type>" + def.getRaPackage() + ".inflow." + def.getMlClass() + "</messagelistener-type>");
        }
        this.writeEol(out);
        this.writeIndent(out, indent + 3);
        out.write("<activationspec>");
        this.writeEol(out);
        this.writeIndent(out, indent + 4);
        out.write("<activationspec-class>" + def.getRaPackage() + ".inflow." + def.getAsClass() + "</activationspec-class>");
        this.writeEol(out);
        this.writeAsConfigPropsXml(def.getAsConfigProps(), out, indent + 4);
        this.writeIndent(out, indent + 3);
        out.write("</activationspec>");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("</messagelistener>");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("</messageadapter>");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("</inbound-resourceadapter>");
        this.writeEol(out);
    }

    private void writeOutbound(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("<outbound-resourceadapter>");
        this.writeEol(out);
        for (int num = 0; num < def.getMcfDefs().size(); ++num) {
            this.writeIndent(out, indent + 1);
            out.write("<connection-definition>");
            this.writeEol(out);
            this.writeIndent(out, indent + 2);
            out.write("<managedconnectionfactory-class>" + def.getRaPackage() + "." + def.getMcfDefs().get(num).getMcfClass() + "</managedconnectionfactory-class>");
            this.writeEol(out);
            this.writeConfigPropsXml(def.getMcfDefs().get(num).getMcfConfigProps(), out, indent + 2);
            if (!def.getMcfDefs().get(num).isUseCciConnection()) {
                this.writeIndent(out, indent + 2);
                out.write("<connectionfactory-interface>" + def.getRaPackage() + "." + def.getMcfDefs().get(num).getCfInterfaceClass() + "</connectionfactory-interface>");
                this.writeEol(out);
                this.writeIndent(out, indent + 2);
                out.write("<connectionfactory-impl-class>" + def.getRaPackage() + "." + def.getMcfDefs().get(num).getCfClass() + "</connectionfactory-impl-class>");
                this.writeEol(out);
                this.writeIndent(out, indent + 2);
                out.write("<connection-interface>" + def.getRaPackage() + "." + def.getMcfDefs().get(num).getConnInterfaceClass() + "</connection-interface>");
                this.writeEol(out);
                this.writeIndent(out, indent + 2);
                out.write("<connection-impl-class>" + def.getRaPackage() + "." + def.getMcfDefs().get(num).getConnImplClass() + "</connection-impl-class>");
                this.writeEol(out);
            } else {
                this.writeIndent(out, indent + 2);
                out.write("<connectionfactory-interface>jakarta.resource.cci.ConnectionFactory</connectionfactory-interface>");
                this.writeEol(out);
                this.writeIndent(out, indent + 2);
                out.write("<connectionfactory-impl-class>" + def.getRaPackage() + "." + def.getMcfDefs().get(num).getCciConnFactoryClass() + "</connectionfactory-impl-class>");
                this.writeEol(out);
                this.writeIndent(out, indent + 2);
                out.write("<connection-interface>jakarta.resource.cci.Connection</connection-interface>");
                this.writeEol(out);
                this.writeIndent(out, indent + 2);
                out.write("<connection-impl-class>" + def.getRaPackage() + "." + def.getMcfDefs().get(num).getCciConnClass() + "</connection-impl-class>");
                this.writeEol(out);
            }
            this.writeIndent(out, indent + 1);
            out.write("</connection-definition>");
            this.writeEol(out);
        }
        this.writeIndent(out, indent + 1);
        out.write("<transaction-support>" + def.getSupportTransaction() + "</transaction-support>");
        this.writeEol(out);
        if (def.getAuthenMechanisms() != null && def.getAuthenMechanisms().size() > 0) {
            for (int i = 0; i < def.getAuthenMechanisms().size(); ++i) {
                this.writeIndent(out, indent + 1);
                out.write("<authentication-mechanism>");
                this.writeEol(out);
                this.writeIndent(out, indent + 2);
                out.write("<authentication-mechanism-type>" + def.getAuthenMechanisms().get(i).getAuthMechanism() + "</authentication-mechanism-type>");
                this.writeEol(out);
                this.writeIndent(out, indent + 2);
                out.write("<credential-interface>");
                if (def.getAuthenMechanisms().get(i).getCredentialInterface().equals("GSSCredential")) {
                    out.write("org.ietf.jgss.GSSCredential");
                } else {
                    out.write("jakarta.resource.spi.security." + def.getAuthenMechanisms().get(i).getCredentialInterface());
                }
                out.write("</credential-interface>");
                this.writeEol(out);
                this.writeIndent(out, indent + 1);
                out.write("</authentication-mechanism>");
                this.writeEol(out);
            }
        }
        this.writeIndent(out, indent + 1);
        out.write("<reauthentication-support>" + def.isSupportReauthen() + "</reauthentication-support>");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("</outbound-resourceadapter>");
        this.writeEol(out);
    }
}

