/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jboss.jca.codegenerator.ConfigPropType;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.code.PropsCodeGen;

public class AoImplCodeGen
extends PropsCodeGen {
    int numOfAo = 0;

    public AoImplCodeGen() {
    }

    public AoImplCodeGen(int num) {
        this.numOfAo = num;
    }

    public int getNumOfAo() {
        return this.numOfAo;
    }

    public void setNumOfAo(int numOfAo) {
        this.numOfAo = numOfAo;
    }

    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        if (def.isUseAnnotation()) {
            out.write("@AdministeredObject(adminObjectInterfaces = { ");
            out.write(def.getAdminObjects().get(this.numOfAo).getAdminObjectInterface());
            out.write(".class })");
            this.writeEol(out);
        }
        out.write("public class " + this.getClassName(def) + " implements " + def.getAdminObjects().get(this.numOfAo).getAdminObjectInterface());
        if (def.isAdminObjectImplRaAssociation()) {
            out.write(",");
            this.writeEol(out);
            this.writeIndent(out, 1);
            out.write("ResourceAdapterAssociation, Referenceable, Serializable");
        }
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeIndent(out, indent);
        out.write("/** Serial version uid */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private static final long serialVersionUID = 1L;");
        this.writeEol(out);
        this.writeEol(out);
        if (def.isAdminObjectImplRaAssociation()) {
            this.writeIndent(out, indent);
            out.write("/** The resource adapter */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            if (def.isRaSerial()) {
                out.write("private ResourceAdapter ra;");
            } else {
                out.write("private transient ResourceAdapter ra;");
            }
            this.writeEol(out);
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("/** Reference */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("private Reference reference;");
            this.writeEol(out);
            this.writeEol(out);
        }
        this.writeConfigPropsDeclare(def, out, indent);
        this.writeDefaultConstructor(def, out, indent);
        this.writeConfigProps(def, out, indent);
        if (def.isAdminObjectImplRaAssociation()) {
            this.writeResourceAdapter(def, out, indent);
            this.writeReference(def, out, indent);
        }
        this.writeHashCode(def, out, indent);
        this.writeEquals(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        if (def.isAdminObjectImplRaAssociation()) {
            out.write("import java.io.Serializable;");
            this.writeEol(out);
            this.writeEol(out);
            out.write("import javax.naming.NamingException;");
            this.writeEol(out);
            out.write("import javax.naming.Reference;");
            this.writeEol(out);
            this.writeEol(out);
            out.write("import jakarta.resource.Referenceable;");
            this.writeEol(out);
        }
        if (def.isUseAnnotation()) {
            out.write("import jakarta.resource.spi.AdministeredObject;");
            this.writeEol(out);
            out.write("import jakarta.resource.spi.ConfigProperty;");
            this.writeEol(out);
        }
        if (def.isAdminObjectImplRaAssociation()) {
            out.write("import jakarta.resource.spi.ResourceAdapter;");
            this.writeEol(out);
            out.write("import jakarta.resource.spi.ResourceAdapterAssociation;");
            this.writeEol(out);
        }
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getAdminObjects().get(this.numOfAo).getAdminObjectClass();
    }

    @Override
    public List<ConfigPropType> getConfigProps(Definition def) {
        return def.getAdminObjects().get(this.numOfAo).getAoConfigProps();
    }

    private void writeResourceAdapter(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Get the resource adapter");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return The handle");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public ResourceAdapter getResourceAdapter()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return ra;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Set the resource adapter");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param ra The handle");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void setResourceAdapter(ResourceAdapter ra)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("this.ra = ra;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeReference(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Get the Reference instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Reference instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @exception NamingException Thrown if a reference can't be obtained");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public Reference getReference() throws NamingException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return reference;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Set the Reference instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param reference A Reference instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void setReference(Reference reference)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("this.reference = reference;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

