/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator;

import java.util.HashMap;
import java.util.Map;

public enum Version {
    UNKNOWN(null),
    V_10("1.0"),
    V_15("1.5"),
    V_16("1.6"),
    V_17("1.7");

    private String name;
    private static final Map<String, Version> MAP;

    private Version(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    Version value(String v) {
        this.name = v;
        return this;
    }

    public static Version forName(String localName) {
        Version element = MAP.get(localName);
        return element == null ? UNKNOWN.value(localName) : element;
    }

    static {
        HashMap<String, Version> map = new HashMap<String, Version>();
        for (Version element : Version.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

