/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator;

public enum BasicType {
    String,
    Boolean,
    Integer,
    Double,
    Byte,
    Short,
    Long,
    Float,
    Character;

    private static String[] primitive;

    public static boolean isBasicType(String type) {
        for (BasicType pt : BasicType.values()) {
            if (!type.equals(pt.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitiveType(String type) {
        for (String ptype : primitive) {
            if (!type.equals(ptype)) continue;
            return true;
        }
        return false;
    }

    public static String allBasicType() {
        StringBuilder sb = new StringBuilder();
        BasicType[] types = BasicType.values();
        for (int i = 0; i < types.length; ++i) {
            sb.append(types[i].toString());
            if (i + 1 >= types.length) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String allType() {
        StringBuilder sb = new StringBuilder();
        for (String ptype : primitive) {
            sb.append(ptype);
            sb.append(", ");
        }
        BasicType[] types = BasicType.values();
        for (int i = 0; i < types.length; ++i) {
            sb.append(types[i].toString());
            if (i + 1 >= types.length) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String defaultValue(String type) {
        if (type.equals("String")) {
            return "null";
        }
        if (type.equals("boolean")) {
            return "false";
        }
        if (type.equals("int")) {
            return "0";
        }
        if (type.equals("double")) {
            return "0.0";
        }
        if (type.equals("long")) {
            return "0";
        }
        if (type.equals("byte")) {
            return "0";
        }
        if (type.equals("short")) {
            return "0";
        }
        if (type.equals("float")) {
            return "0.0";
        }
        if (type.equals("char")) {
            return "''";
        }
        return "null";
    }

    static {
        primitive = new String[]{"int", "boolean", "double", "byte", "short", "long", "float", "char"};
    }
}

