/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.arquillian.embedded;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.jca.arquillian.embedded.Inject;
import org.jboss.jca.arquillian.embedded.SecurityActions;
import org.jboss.jca.embedded.Embedded;
import org.jboss.logging.Logger;

class EmbeddedJCAEnricher
implements TestEnricher {
    private static Logger log = Logger.getLogger(EmbeddedJCAEnricher.class);
    private static boolean trace = log.isTraceEnabled();
    @org.jboss.arquillian.core.api.annotation.Inject
    private Instance<Embedded> embeddedInst;

    EmbeddedJCAEnricher() {
    }

    public void enrich(Object testCase) {
        if (this.embeddedInst.get() != null) {
            if (trace) {
                log.tracef("Injecting test case: %s", (Object)testCase.getClass().getName());
            }
            this.injectClass(testCase);
        }
    }

    public Object[] resolve(Method method) {
        return new Object[method.getParameterTypes().length];
    }

    private void injectClass(Object testCase) {
        List<Field> annotatedFields = SecurityActions.getFieldsWithAnnotation(testCase.getClass(), Inject.class);
        if (trace) {
            log.tracef("Fields: %s", annotatedFields);
        }
        if (annotatedFields != null) {
            for (Field field : annotatedFields) {
                if (trace) {
                    log.tracef("Injecting field: %s", (Object)field);
                }
                Inject annotation = null;
                try {
                    field.setAccessible(true);
                    annotation = field.getAnnotation(Inject.class);
                    field.set(testCase, this.resolveResource(field, annotation));
                }
                catch (IllegalAccessException iae) {
                    throw new RuntimeException("Could not inject: " + annotation + " (" + field.getType() + ")", iae);
                }
            }
        }
    }

    private Object resolveResource(Field field, Inject annotation) {
        try {
            return ((Embedded)this.embeddedInst.get()).lookup(annotation.name(), field.getType());
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Could not inject: " + annotation.name() + " (" + field.getType() + ")");
        }
    }
}

