/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.xmlkey.common;

import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jboss.identity.xmlkey.common.SecurityActions;

public class JBossJAXBUtil {
    public static Marshaller getValidatingMarshaller(String pkgName, String schemaLocation) throws Exception {
        if (pkgName == null) {
            throw new IllegalArgumentException("pkgName is null");
        }
        JAXBContext jc = JAXBContext.newInstance((String)pkgName);
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        URL schemaURL = tcl.getResource(schemaLocation);
        if (schemaURL == null) {
            throw new IllegalStateException("Schema URL is null:" + schemaLocation);
        }
        SchemaFactory scFact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = scFact.newSchema(schemaURL);
        marshaller.setSchema(schema);
        return marshaller;
    }

    public static Unmarshaller getValidatingUnmarshaller(String pkgName, String schemaLocation) throws Exception {
        if (pkgName == null) {
            throw new IllegalArgumentException("pkgName is null");
        }
        JAXBContext jc = JAXBContext.newInstance((String)pkgName);
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        URL schemaURL = tcl.getResource(schemaLocation);
        if (schemaURL == null) {
            throw new IllegalStateException("Schema URL is null:" + schemaLocation);
        }
        SchemaFactory scFact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = scFact.newSchema(schemaURL);
        unmarshaller.setSchema(schema);
        return unmarshaller;
    }
}

