/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.identity.idm.impl.api.query;

import org.jboss.identity.idm.api.query.GroupQuery;
import org.jboss.identity.idm.api.query.UnsupportedQueryCriterium;
import org.jboss.identity.idm.api.query.QueryException;
import org.jboss.identity.idm.api.SortOrder;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.impl.NotYetImplementedException;
import org.jboss.identity.idm.impl.api.session.IdentitySessionImpl;
import org.jboss.identity.idm.impl.api.model.GroupId;
import org.jboss.identity.idm.impl.api.model.SimpleGroup;
import org.jboss.identity.idm.impl.api.model.SimpleUser;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.HashSet;

/**
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
public class GroupQueryImpl extends AbstractQuery implements GroupQuery
{
   private GroupId groupId;

   private String groupName;

   private String groupType;

   private Set<Group> associatedParentGroups = new HashSet<Group>();

   private Set<Group> associatedChildGroups = new HashSet<Group>();

   private Set<User> usersAssociated = new HashSet<User>();

   private Set<User> usersRelated = new HashSet<User>();

   private Set<User> usersConnectedByRole = new HashSet<User>(); 

   public GroupQueryImpl(IdentitySessionImpl identitySession)
   {
      super(identitySession);
   }

   public Collection<Group> execute() throws QueryException
   {
      prepare();
      throw new NotYetImplementedException();
   }

   private void prepare()
   {
      if (groupId == null && (groupName != null && groupType != null))
      {
         groupId = new GroupId(groupName, groupType);
      }
   }

   public Group uniqueResult() throws QueryException
   {
      throw new NotYetImplementedException();
   }

   public List<Group> list() throws QueryException
   {
      throw new NotYetImplementedException();
   }

   public GroupQuery setId(String id)
   {
      groupId = new GroupId(id);
      return this;
   }

   public GroupQuery setNameAndType(String name, String type)
   {
      groupId = new GroupId(name, type);
      groupName = name;
      groupType = type;

      return this;
   }

   public GroupQuery setName(String name)
   {
      checkNotNullArgument(name, "Group name");
      groupName = name;
      return this;
   }

   public GroupQuery setType(String type)
   {
      checkNotNullArgument(type, "Group type");
      groupType = type;
      return this;
   }

   public GroupQuery addAssociatedGroup(Group group, boolean parent)
   {
      checkNotNullArgument(group, "Group");
      if (parent)
      {
         associatedParentGroups.add(group);
      }
      else
      {
         associatedChildGroups.add(group);
      }
      return this;
   }

   public GroupQuery addAssociatedGroup(String id, boolean parent)
   {
      checkNotNullArgument(id, "Group id");

      Group group = new SimpleGroup(new GroupId(id));

      if (parent)
      {
         associatedParentGroups.add(group);
      }
      else
      {
         associatedChildGroups.add(group);
      }


      return this;
   }

   public GroupQuery addAssociatedGroups(Collection<Group> groups, boolean parent)
   {
      checkNotNullArgument(groups, "Groups");

      if (parent)
      {
         associatedParentGroups.addAll(groups);
      }
      else
      {
         associatedChildGroups.addAll(groups);
      }

      return this;
   }

   public GroupQuery addAssociatedGroupsIds(Collection<String> ids, boolean parent)
   {
      checkNotNullArgument(ids, "Groups ids");
      for (String groupId : ids)
      {
         Group group = new SimpleGroup(new GroupId(groupId));

         if (parent)
         {
            associatedParentGroups.add(group);
         }
         else
         {
            associatedChildGroups.add(group);
         }
      }

      return this;
   }

   public GroupQuery addAssociatedUser(User user)
   {
      checkNotNullArgument(user, "User");
      usersAssociated.add(user);
      return this;
   }

   public GroupQuery addAssociatedUser(String id)
   {
      checkNotNullArgument(id, "User id");
      usersAssociated.add(new SimpleUser(id));
      return this;
   }

   public GroupQuery addAssociatedUsers(Collection<User> users)
   {
      checkNotNullArgument(users, "Users");
      usersAssociated.addAll(users);
      return this;
   }

   public GroupQuery addAssociatedUsersIds(Collection<String> ids)
   {
      checkNotNullArgument(ids, "Users ids");
      for (String id : ids)
      {
         usersAssociated.add(new SimpleUser(id));
      }
      return this;
   }

   public GroupQuery addUserConnectedByRole(User user)
   {
      checkNotNullArgument(user, "User");
      usersConnectedByRole.add(user);
      return this;
   }

   public GroupQuery addUserConnectedByRole(String id)
   {
      checkNotNullArgument(id, "User id");
      usersConnectedByRole.add(new SimpleUser(id));
      return this;
   }

   public GroupQuery addUsersConnectedByRole(Collection<User> users)
   {
      checkNotNullArgument(users, "Users");
      usersConnectedByRole.addAll(users);
      return this;
   }

   public GroupQuery addUsersIdsConnectedByRole(Collection<String> ids)
   {
      checkNotNullArgument(ids, "Users ids");
      for (String id : ids)
      {
         usersConnectedByRole.add(new SimpleUser(id));
      }
      return this;
   }

   public GroupQuery addRelatedUser(User user)
   {
      checkNotNullArgument(user, "User");
      usersRelated.add(user);
      return this;
   }

   public GroupQuery addRelatedUser(String id)
   {
      checkNotNullArgument(id, "User id");
      usersRelated.add(new SimpleUser(id));
      return this;
   }

   public GroupQuery sort(SortOrder order) throws UnsupportedQueryCriterium
   {
      return (GroupQuery)super.sort(order);
   }

   public GroupQuery sortAttributeName(String name) throws UnsupportedQueryCriterium
   {
      return (GroupQuery)super.sortAttributeName(name);
   }

   public GroupQuery page(int firstResult, int maxResults) throws UnsupportedQueryCriterium
   {
      return (GroupQuery)super.page(firstResult, maxResults);
   }

   public GroupQuery attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium
   {
      return (GroupQuery)super.attributeValuesFilter(attributeName, attributeValue);
   }
}
