/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.store.ldap;

import java.util.HashMap;
import java.util.Map;
import org.jboss.identity.idm.impl.store.ldap.LDAPIdentityObjectTypeConfiguration;
import org.jboss.identity.idm.impl.store.ldap.LDAPIdentityStoreConfiguration;
import org.jboss.identity.idm.impl.store.ldap.SimpleLDAPIdentityObjectTypeConfiguration;
import org.jboss.identity.idm.impl.types.SimpleIdentityObjectType;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityObjectTypeMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;
import org.jboss.identity.idm.spi.model.IdentityObjectType;

public class SimpleLDAPIdentityStoreConfiguration
implements LDAPIdentityStoreConfiguration {
    private final String providerURL;
    private final String adminDN;
    private final String adminPassword;
    private final int searchTimeLimit;
    private final Map<String, LDAPIdentityObjectTypeConfiguration> typesConfiguration;
    public static final String PROVIDER_URL = "providerURL";
    public static final String ADMIN_DN = "adminDN";
    public static final String ADMIN_PASSWORD = "adminPassword";
    public static final String SEARCH_TIME_LIMIT = "searchTimeLimit";
    public static final int SEARCH_TIME_LIMIT_DEFAULT = 10000;

    public SimpleLDAPIdentityStoreConfiguration(IdentityStoreConfigurationMetaData storeMD) {
        if (storeMD == null) {
            throw new IllegalArgumentException();
        }
        this.providerURL = storeMD.getOptionSingleValue(PROVIDER_URL);
        this.adminDN = storeMD.getOptionSingleValue(ADMIN_DN);
        this.adminPassword = storeMD.getOptionSingleValue(ADMIN_PASSWORD);
        String searchTL = storeMD.getOptionSingleValue(SEARCH_TIME_LIMIT);
        this.searchTimeLimit = searchTL != null ? Integer.valueOf(searchTL) : 10000;
        HashMap<String, LDAPIdentityObjectTypeConfiguration> types = new HashMap<String, LDAPIdentityObjectTypeConfiguration>();
        for (IdentityObjectTypeMetaData identityObjectTypeMetaData : storeMD.getSupportedIdentityTypes()) {
            SimpleLDAPIdentityObjectTypeConfiguration typeConfig = new SimpleLDAPIdentityObjectTypeConfiguration(identityObjectTypeMetaData);
            types.put(identityObjectTypeMetaData.getName(), typeConfig);
        }
        this.typesConfiguration = types;
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public String getAdminDN() {
        return this.adminDN;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public int getSearchTimeLimit() {
        return this.searchTimeLimit;
    }

    public LDAPIdentityObjectTypeConfiguration getTypeConfiguration(String typeName) {
        return this.typesConfiguration.get(typeName);
    }

    public IdentityObjectType[] getConfiguredTypes() {
        IdentityObjectType[] types = new IdentityObjectType[this.typesConfiguration.size()];
        Object[] names = this.typesConfiguration.keySet().toArray();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i].toString();
            types[i] = new SimpleIdentityObjectType(name);
        }
        return types;
    }
}

