/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.repository;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.identity.idm.exception.IdentityException;
import org.jboss.identity.idm.impl.cache.JBossCacheIdentityStoreWrapper;
import org.jboss.identity.idm.spi.configuration.IdentityRepositoryConfigurationContext;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityRepositoryConfigurationMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityStoreMappingMetaData;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.repository.IdentityStoreRepository;
import org.jboss.identity.idm.spi.store.AttributeStore;
import org.jboss.identity.idm.spi.store.IdentityStore;
import org.jboss.identity.idm.spi.store.IdentityStoreInvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIdentityStoreRepository
implements IdentityStoreRepository {
    protected Map<String, IdentityStore> identityStoreMappings = new HashMap<String, IdentityStore>();
    protected Map<String, AttributeStore> attributeStoreMappings = new HashMap<String, AttributeStore>();
    protected IdentityStore defaultIdentityStore;
    protected AttributeStore defaultAttributeStore;
    public static final String CACHE_OPTION = "cache";
    public static final String CACHE_CONFIG_FILE_OPTION = "cache.config-file";

    public void bootstrap(IdentityRepositoryConfigurationContext configurationContext, Map<String, IdentityStore> bootstrappedIdentityStores, Map<String, AttributeStore> bootstrappedAttributeStores) throws IdentityException {
        IdentityRepositoryConfigurationMetaData configurationMD = configurationContext.getRepositoryConfigurationMetaData();
        String asId = configurationMD.getDefaultAttributeStoreId();
        String isId = configurationMD.getDefaultIdentityStoreId();
        if (asId != null && bootstrappedAttributeStores.keySet().contains(asId)) {
            this.defaultAttributeStore = bootstrappedAttributeStores.get(asId);
        }
        if (isId != null && bootstrappedIdentityStores.keySet().contains(isId)) {
            this.defaultIdentityStore = bootstrappedIdentityStores.get(isId);
            String cacheOption = configurationMD.getOptionSingleValue(CACHE_OPTION);
            if (cacheOption != null && cacheOption.equalsIgnoreCase("true")) {
                String cacheConfig = configurationMD.getOptionSingleValue(CACHE_CONFIG_FILE_OPTION);
                if (cacheConfig == null) {
                    throw new IdentityException("cache.config-file is missing in the repository configuration");
                }
                File cacheConfigFile = new File(cacheConfig);
                if (!cacheConfigFile.exists()) {
                    throw new IdentityException("JBoss Cache config file specified in option \"cache.config-file\" doesn't exist: " + cacheConfig);
                }
                this.defaultIdentityStore = new JBossCacheIdentityStoreWrapper(this.defaultIdentityStore, cacheConfig);
            }
        }
        for (IdentityStoreMappingMetaData identityStoreMappingMetaData : configurationMD.getIdentityStoreToIdentityObjectTypeMappings()) {
            String storeId = identityStoreMappingMetaData.getIdentityStoreId();
            List identityObjectTypeMappings = identityStoreMappingMetaData.getIdentityObjectTypeMappings();
            IdentityStore store = bootstrappedIdentityStores.get(storeId);
            String cacheOption = identityStoreMappingMetaData.getOptionSingleValue(CACHE_OPTION);
            if (cacheOption != null && cacheOption.equalsIgnoreCase("true")) {
                String cacheConfig = identityStoreMappingMetaData.getOptionSingleValue(CACHE_CONFIG_FILE_OPTION);
                if (cacheConfig == null) {
                    throw new IdentityException("cache.config-file is missing in the repository identity-store-mapping configuration");
                }
                File cacheConfigFile = new File(cacheConfig);
                if (!cacheConfigFile.exists()) {
                    throw new IdentityException("JBoss Cache config file specified in option \"cache.config-file\" doesn't exist: " + cacheConfig);
                }
                store = new JBossCacheIdentityStoreWrapper(store, cacheConfig);
            }
            if (store == null) {
                throw new IdentityException("Mapped IdentityStore not available: " + storeId);
            }
            for (String mapping : identityObjectTypeMappings) {
                this.identityStoreMappings.put(mapping, store);
                this.attributeStoreMappings.put(mapping, (AttributeStore)store);
            }
        }
    }

    public Set<IdentityStore> getConfiguredIdentityStores() {
        return new HashSet<IdentityStore>(this.identityStoreMappings.values());
    }

    public Set<AttributeStore> getConfiguredAttributeStores() {
        return new HashSet<AttributeStore>(this.attributeStoreMappings.values());
    }

    public Map<String, IdentityStore> getIdentityStoreMappings() {
        return this.identityStoreMappings;
    }

    public Map<String, AttributeStore> getAttributeStoreMappings() {
        return this.attributeStoreMappings;
    }

    public IdentityStore getIdentityStore(IdentityObjectType identityObjectType) {
        return this.identityStoreMappings.get(identityObjectType.getName());
    }

    public AttributeStore getAttributeStore(IdentityObjectType identityObjectType) {
        return this.attributeStoreMappings.get(identityObjectType.getName());
    }

    protected boolean hasIdentityObject(IdentityStoreInvocationContext ctx, IdentityStore is, IdentityObject io) throws IdentityException {
        try {
            if (is.findIdentityObject(ctx, io.getName(), io.getIdentityType()) != null) {
                return true;
            }
        }
        catch (IdentityException e) {
            // empty catch block
        }
        return false;
    }
}

