/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.model.hibernate;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import org.hibernate.annotations.CollectionOfElements;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObject;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="identity_obj_attrs_binary")
@PrimaryKeyJoinColumn(name="ATTRIBUTE_ID")
public class HibernateIdentityObjectBinaryAttribute
extends HibernateIdentityObjectAttribute {
    @CollectionOfElements(targetElement=byte[].class)
    private Set<byte[]> values = new HashSet<byte[]>();

    public HibernateIdentityObjectBinaryAttribute() {
    }

    public HibernateIdentityObjectBinaryAttribute(HibernateIdentityObject identityObject, String name, Set<byte[]> values) {
        super(identityObject, name);
        this.values = values;
    }

    public Set<byte[]> getValues() {
        return this.values;
    }

    public void setValues(Set<byte[]> values) {
        this.values = Collections.unmodifiableSet(values);
    }

    public byte[] getValue() {
        if (this.values.size() > 0) {
            return this.values.iterator().next();
        }
        return null;
    }

    public int getSize() {
        return this.values.size();
    }

    public void addValue(Object value) {
        if (value instanceof byte[]) {
            this.values.add((byte[])value);
        }
    }
}

