/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.session.managers;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.IdentitySearchControl;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.api.Role;
import org.jboss.identity.idm.api.RoleManager;
import org.jboss.identity.idm.api.RoleManagerFeaturesDescription;
import org.jboss.identity.idm.api.RoleType;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.exception.IdentityException;
import org.jboss.identity.idm.impl.api.model.SimpleRole;
import org.jboss.identity.idm.impl.api.model.SimpleRoleType;
import org.jboss.identity.idm.impl.api.session.managers.AbstractManager;
import org.jboss.identity.idm.spi.exception.OperationNotSupportedException;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationship;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationshipType;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.searchcontrol.IdentityObjectSearchControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleManagerImpl
extends AbstractManager
implements RoleManager {
    public static final IdentityObjectRelationshipType ROLE = new IdentityObjectRelationshipType(){

        public String getName() {
            return "JBOSS_IDENTITY_ROLE";
        }
    };
    private final RoleManagerFeaturesDescription featuresDescription = new RoleManagerFeaturesDescription(){

        public boolean isRoleTypeAddRemoveSupported() {
            return RoleManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isRelationshipNameAddRemoveSupported();
        }

        public boolean isRoleTypeSearchControlSupported(Class controlClazz) {
            return RoleManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isRoleNameControlSupported(controlClazz);
        }

        public boolean isRoleTypeSearchControlSupported(IdentitySearchControl control) {
            if (control instanceof IdentityObjectSearchControl) {
                return RoleManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isRoleNameControlSupported((IdentityObjectSearchControl)control);
            }
            return false;
        }
    };

    public RoleManagerImpl(IdentitySession session) {
        super(session);
    }

    public RoleManagerFeaturesDescription getSupportedFeatures() {
        return this.featuresDescription;
    }

    public RoleType createRoleType(String name) throws IdentityException {
        this.checkNotNullArgument(name, "RoleType name");
        this.checkObjectName(name);
        String roleType = null;
        try {
            roleType = this.getRepository().createRelationshipName(this.getInvocationContext(), name);
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
        return new SimpleRoleType(roleType);
    }

    public void removeRoleType(String name) throws IdentityException {
        this.checkNotNullArgument(name, "RoleType name");
        try {
            this.getRepository().removeRelationshipName(this.getInvocationContext(), name);
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
    }

    public void removeRoleType(RoleType roleType) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.removeRoleType(roleType.getName());
    }

    public RoleType getRoleType(String name) throws IdentityException {
        this.checkNotNullArgument(name, "RoleType name");
        try {
            Set names = this.getRepository().getRelationshipNames(this.getInvocationContext(), null);
            if (names.contains(name)) {
                return new SimpleRoleType(name);
            }
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
        return null;
    }

    public Collection<RoleType> findRoleTypes(IdentitySearchControl[] controls) throws IdentityException {
        try {
            Set names = this.getRepository().getRelationshipNames(this.getInvocationContext(), this.convertSearchControls(controls));
            HashSet<RoleType> types = new HashSet<RoleType>();
            for (String name : names) {
                types.add(new SimpleRoleType(name));
            }
            return types;
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
    }

    public Role createRole(RoleType roleType, User identity, Group group) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(identity, "User");
        this.checkNotNullArgument(group, "Group");
        IdentityObjectRelationship rel = this.getRepository().createRelationship(this.getInvocationContext(), this.createIdentityObject(group), this.createIdentityObject(identity), ROLE, roleType.getName(), false);
        return new SimpleRole(new SimpleRoleType(rel.getName()), this.createUser(rel.getToIdentityObject()), this.createGroup(rel.getFromIdentityObject()));
    }

    public Role createRole(String roleTypeName, String userName, String groupId) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.checkNotNullArgument(userName, "User name");
        this.checkNotNullArgument(groupId, "Group Id");
        User user = this.createUserFromId(userName);
        Group group = this.createGroupFromId(groupId);
        return this.createRole(new SimpleRoleType(roleTypeName), user, group);
    }

    public void removeRole(RoleType roleType, User identity, Group group) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(identity, "User");
        this.checkNotNullArgument(group, "Group");
        this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObject(group), this.createIdentityObject(identity), ROLE, roleType.getName());
    }

    public void removeRole(String roleTypeName, String userName, String groupId) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.checkNotNullArgument(userName, "User name");
        this.checkNotNullArgument(groupId, "Group Id");
        User user = this.createUserFromId(userName);
        Group group = this.createGroupFromId(groupId);
        this.removeRole(new SimpleRoleType(roleTypeName), user, group);
    }

    public void removeRole(Role role) throws IdentityException {
        this.checkNotNullArgument(role, "Role");
        this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObject(role.getGroup()), this.createIdentityObject(role.getIdentity()), ROLE, role.getRoleType().getName());
    }

    public boolean hasRole(User identity, Group group, RoleType roleType) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(identity, "User");
        this.checkNotNullArgument(group, "Group");
        Set rels = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(group), this.createIdentityObject(identity), ROLE);
        for (IdentityObjectRelationship rel : rels) {
            if (!rel.getType().getName().equals(ROLE.getName()) || rel.getName() == null || !rel.getName().equals(roleType.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasRole(String userName, String groupId, String roleTypeName) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.checkNotNullArgument(userName, "User name");
        this.checkNotNullArgument(groupId, "Group Id");
        User user = this.createUserFromId(userName);
        Group group = this.createGroupFromId(groupId);
        return this.hasRole(user, group, new SimpleRoleType(roleTypeName));
    }

    public Collection<RoleType> findRoleTypes(User identity, Group group) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        this.checkNotNullArgument(group, "Group");
        return this.findRoleTypes(identity, group, null);
    }

    public Collection<RoleType> findRoleTypes(User identity, Group group, IdentitySearchControl[] controls) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        this.checkNotNullArgument(group, "Group");
        Set rels = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(group), this.createIdentityObject(identity), ROLE);
        HashSet<RoleType> types = new HashSet<RoleType>();
        for (IdentityObjectRelationship rel : rels) {
            types.add(new SimpleRoleType(rel.getName()));
        }
        return types;
    }

    public Collection<RoleType> findRoleTypes(String userName, String groupId, IdentitySearchControl[] controls) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        this.checkNotNullArgument(groupId, "Group Id");
        User user = this.createUserFromId(userName);
        Group group = this.createGroupFromId(groupId);
        return this.findRoleTypes(user, group, controls);
    }

    public Collection<RoleType> findUserRoleTypes(User identity) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        return this.findUserRoleTypes(identity, null);
    }

    public Collection<RoleType> findUserRoleTypes(User identity, IdentitySearchControl[] controls) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        HashSet<RoleType> types = new HashSet<RoleType>();
        try {
            Set names = this.getRepository().getRelationshipNames(this.getInvocationContext(), this.createIdentityObject(identity), this.convertSearchControls(controls));
            for (String name : names) {
                types.add(new SimpleRoleType(name));
            }
            return types;
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported", (Throwable)e);
        }
    }

    public Collection<RoleType> findUserRoleTypes(String userName, IdentitySearchControl[] controls) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        User user = this.createUserFromId(userName);
        return this.findUserRoleTypes(user, controls);
    }

    public Collection<RoleType> findGroupRoleTypes(Group group) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        return this.findGroupRoleTypes(group, null);
    }

    public Collection<RoleType> findGroupRoleTypes(String groupId, IdentitySearchControl[] controls) throws IdentityException {
        this.checkNotNullArgument(groupId, "Group Id");
        Group group = this.createGroupFromId(groupId);
        return this.findGroupRoleTypes(group, controls);
    }

    public Collection<RoleType> findGroupRoleTypes(Group group, IdentitySearchControl[] controls) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        HashSet<RoleType> types = new HashSet<RoleType>();
        try {
            Set names = this.getRepository().getRelationshipNames(this.getInvocationContext(), this.createIdentityObject(group), this.convertSearchControls(controls));
            for (String name : names) {
                types.add(new SimpleRoleType(name));
            }
            return types;
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
    }

    public Collection<Group> findGroupsWithRelatedRole(User identity, IdentitySearchControl[] controls) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        LinkedList<Group> identities = new LinkedList<Group>();
        Collection ios = null;
        ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(identity), ROLE, false, this.convertSearchControls(controls));
        for (IdentityObject io : ios) {
            identities.add(this.createGroup(io));
        }
        return identities;
    }

    public Collection<Group> findGroupsWithRelatedRole(String userName, IdentitySearchControl[] controls) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        User user = this.createUserFromId(userName);
        return this.findGroupsWithRelatedRole(user, controls);
    }

    public Collection<Group> findGroupsWithRelatedRole(User identity, String groupType, IdentitySearchControl[] controls) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        this.checkNotNullArgument(groupType, "Group type");
        LinkedList<Group> identities = new LinkedList<Group>();
        IdentityObjectType iot = this.getIdentityObjectType(groupType);
        Collection ios = null;
        ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(identity), ROLE, false, this.convertSearchControls(controls));
        for (IdentityObject io : ios) {
            if (!io.getIdentityType().getName().equals(iot.getName())) continue;
            identities.add(this.createGroup(io));
        }
        return identities;
    }

    public Collection<Group> findGroupsWithRelatedRole(String userName, String groupType, IdentitySearchControl[] controls) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        this.checkNotNullArgument(groupType, "Group type");
        User user = this.createUserFromId(userName);
        return this.findGroupsWithRelatedRole(user, groupType, controls);
    }

    public Collection<Role> findRoles(IdentityType identityType, RoleType roleType) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        this.checkNotNullArgument(roleType, "RoleType");
        HashSet<Role> roles = new HashSet<Role>();
        Set relationships = null;
        relationships = identityType instanceof User ? this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(identityType), ROLE, false, true, null) : this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(identityType), ROLE, true, true, null);
        for (IdentityObjectRelationship relationship : relationships) {
            if (!roleType.getName().equals(relationship.getName())) continue;
            roles.add(new SimpleRole(new SimpleRoleType(relationship.getName()), this.createUser(relationship.getToIdentityObject()), this.createGroup(relationship.getFromIdentityObject())));
        }
        return roles;
    }

    public <T extends IdentityType> Collection<Role> findRoles(String id, String roleTypeName) throws IdentityException {
        this.checkNotNullArgument(id, "Group id or User name");
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        return this.findRoles(this.createIdentityTypeFromId(id), new SimpleRoleType(roleTypeName));
    }
}

