/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.session.managers;

import java.util.Collection;
import java.util.LinkedList;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.IdentitySearchControl;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.PersistenceManager;
import org.jboss.identity.idm.api.PersistenceManagerFeaturesDescription;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.exception.IdentityException;
import org.jboss.identity.idm.impl.api.model.GroupId;
import org.jboss.identity.idm.impl.api.session.managers.AbstractManager;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.searchcontrol.IdentityObjectSearchControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceManagerImpl
extends AbstractManager
implements PersistenceManager {
    private final PersistenceManagerFeaturesDescription featuresDescription = new PersistenceManagerFeaturesDescription(){

        public boolean isUsersAddRemoveSupported() {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isIdentityObjectAddRemoveSupported(objectType);
        }

        public boolean isGroupsAddRemoveSupported(String groupType) {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(groupType);
            return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isIdentityObjectAddRemoveSupported(objectType);
        }

        public boolean isUsersSearchControlSupported(IdentitySearchControl control) {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            if (control instanceof IdentityObjectSearchControl) {
                return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isControlSupported(objectType, (IdentityObjectSearchControl)control);
            }
            return false;
        }

        public boolean isUsersSearchControlSupported(Class controlClazz) {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isControlSupported(objectType, controlClazz);
        }

        public boolean isGroupsSearchControlSupported(String groupType, IdentitySearchControl control) {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(groupType);
            if (control instanceof IdentityObjectSearchControl) {
                return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isControlSupported(objectType, (IdentityObjectSearchControl)control);
            }
            return false;
        }

        public boolean isGroupsSearchControlSupported(String groupType, Class controlClazz) {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(groupType);
            return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isControlSupported(objectType, controlClazz);
        }
    };

    public PersistenceManagerImpl(IdentitySession session) {
        super(session);
    }

    public PersistenceManagerFeaturesDescription getFeaturesDescription() {
        return this.featuresDescription;
    }

    public User createUser(String identityName) throws IdentityException {
        this.checkNotNullArgument(identityName, "Identity name");
        this.checkObjectName(identityName);
        IdentityObjectType iot = this.getUserObjectType();
        IdentityObject identityObject = this.getRepository().createIdentityObject(this.getInvocationContext(), identityName, iot);
        return this.createUser(identityObject);
    }

    public Group createGroup(String groupName, String groupType) throws IdentityException {
        this.checkNotNullArgument(groupName, "Group name");
        this.checkNotNullArgument(groupType, "Group type");
        this.checkObjectName(groupName);
        this.checkObjectName(groupType);
        IdentityObjectType iot = this.getIdentityObjectType(groupType);
        IdentityObject identityObject = this.getRepository().createIdentityObject(this.getInvocationContext(), groupName, iot);
        return this.createGroup(identityObject);
    }

    public String createGroupId(String groupName, String groupType) {
        this.checkNotNullArgument(groupName, "Group name");
        this.checkNotNullArgument(groupType, "Group type");
        this.checkObjectName(groupName);
        this.checkObjectName(groupType);
        return new GroupId(groupName, groupType).getId();
    }

    public void removeUser(User user, boolean force) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        this.getRepository().removeIdentityObject(this.getInvocationContext(), this.createIdentityObject(user));
    }

    public void removeUser(String userName, boolean force) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        this.getRepository().removeIdentityObject(this.getInvocationContext(), this.createIdentityObjectForUserName(userName));
    }

    public void removeGroup(Group group, boolean force) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        this.getRepository().removeIdentityObject(this.getInvocationContext(), this.createIdentityObject(group));
    }

    public void removeGroup(String groupId, boolean force) throws IdentityException {
        this.checkNotNullArgument(groupId, "Group Id");
        this.getRepository().removeIdentityObject(this.getInvocationContext(), this.createIdentityObjectForGroupId(groupId));
    }

    public int getUserCount() throws IdentityException {
        IdentityObjectType iot = this.getUserObjectType();
        return this.getRepository().getIdentityObjectsCount(this.getInvocationContext(), iot);
    }

    public int getGroupTypeCount(String groupType) throws IdentityException {
        this.checkNotNullArgument(groupType, "Group type");
        IdentityObjectType iot = this.getIdentityObjectType(groupType);
        return this.getRepository().getIdentityObjectsCount(this.getInvocationContext(), iot);
    }

    public User findUser(String name) throws IdentityException {
        this.checkNotNullArgument(name, "User name");
        return this.createUser(this.getRepository().findIdentityObject(this.getInvocationContext(), name, this.getUserObjectType()));
    }

    public Collection<User> findUser(IdentitySearchControl[] controls) throws IdentityException {
        Collection ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.getUserObjectType(), this.convertSearchControls(controls));
        LinkedList<User> identities = new LinkedList<User>();
        for (IdentityObject identityObject : ios) {
            identities.add(this.createUser(identityObject));
        }
        return identities;
    }

    public Group findGroup(String name, String groupType) throws IdentityException {
        this.checkNotNullArgument(name, "Group name");
        this.checkNotNullArgument(groupType, "Group type");
        return this.createGroup(this.getRepository().findIdentityObject(this.getInvocationContext(), name, this.getIdentityObjectType(groupType)));
    }

    public Group findGroupById(String id) throws IdentityException {
        this.checkNotNullArgument(id, "Group id");
        return this.createGroup(this.getRepository().findIdentityObject(this.getInvocationContext(), id));
    }

    public Collection<Group> findGroup(String groupType, IdentitySearchControl[] controls) throws IdentityException {
        this.checkNotNullArgument(groupType, "Group type");
        Collection ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.getIdentityObjectType(groupType), this.convertSearchControls(controls));
        LinkedList<Group> groups = new LinkedList<Group>();
        for (IdentityObject identityObject : ios) {
            groups.add(this.createGroup(identityObject));
        }
        return groups;
    }

    public Collection<Group> findGroup(String groupType) throws IdentityException {
        this.checkNotNullArgument(groupType, "Group type");
        return this.findGroup(groupType, (IdentitySearchControl[])null);
    }
}

