/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.session;

import org.jboss.identity.idm.api.AttributesManager;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.PersistenceManager;
import org.jboss.identity.idm.api.RelationshipManager;
import org.jboss.identity.idm.api.RoleManager;
import org.jboss.identity.idm.api.Transaction;
import org.jboss.identity.idm.exception.FeatureNotSupportedException;
import org.jboss.identity.idm.exception.IdentityException;
import org.jboss.identity.idm.impl.api.session.SimpleTransactionImpl;
import org.jboss.identity.idm.impl.api.session.context.IdentitySessionContext;
import org.jboss.identity.idm.impl.api.session.context.IdentitySessionContextImpl;
import org.jboss.identity.idm.impl.api.session.context.IdentityStoreInvocationContextResolver;
import org.jboss.identity.idm.impl.api.session.managers.AttributesManagerImpl;
import org.jboss.identity.idm.impl.api.session.managers.PersistenceManagerImpl;
import org.jboss.identity.idm.impl.api.session.managers.RelationshipManagerImpl;
import org.jboss.identity.idm.impl.api.session.managers.RoleManagerImpl;
import org.jboss.identity.idm.impl.api.session.mapper.IdentityObjectTypeMapper;
import org.jboss.identity.idm.impl.store.SimpleIdentityStoreInvocationContext;
import org.jboss.identity.idm.spi.repository.IdentityStoreRepository;
import org.jboss.identity.idm.spi.store.IdentityStoreInvocationContext;
import org.jboss.identity.idm.spi.store.IdentityStoreSession;

public class IdentitySessionImpl
implements IdentitySession {
    private final String realmName;
    private final IdentitySessionContext sessionContext;
    private final PersistenceManager persistenceManager;
    private final RelationshipManager relationshipManager;
    private final AttributesManager profileManager;
    private final RoleManager roleManager;

    public IdentitySessionContext getSessionContext() {
        return this.sessionContext;
    }

    public IdentitySessionImpl(String realmName, IdentityStoreRepository repository, IdentityObjectTypeMapper typeMapper) throws IdentityException {
        this.realmName = realmName;
        IdentityStoreSession storeSession = repository.createIdentityStoreSession();
        final SimpleIdentityStoreInvocationContext invocationCtx = new SimpleIdentityStoreInvocationContext(storeSession, realmName);
        IdentityStoreInvocationContextResolver resolver = new IdentityStoreInvocationContextResolver(){

            public IdentityStoreInvocationContext resolveInvocationContext() {
                return invocationCtx;
            }
        };
        this.sessionContext = new IdentitySessionContextImpl(repository, typeMapper, resolver);
        this.persistenceManager = new PersistenceManagerImpl(this);
        this.relationshipManager = new RelationshipManagerImpl(this);
        this.profileManager = new AttributesManagerImpl(this);
        this.roleManager = new RoleManagerImpl(this);
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void close() throws IdentityException {
        this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession().close();
    }

    public void save() throws IdentityException {
        this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession().save();
    }

    public void clear() throws IdentityException {
        this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession().clear();
    }

    public boolean isOpen() {
        return this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession().isOpen();
    }

    public Transaction beginTransaction() {
        SimpleTransactionImpl transaction = new SimpleTransactionImpl(this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession());
        transaction.start();
        return transaction;
    }

    public Transaction getTransaction() {
        return new SimpleTransactionImpl(this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession());
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public RelationshipManager getRelationshipManager() {
        return this.relationshipManager;
    }

    public AttributesManager getAttributesManager() {
        return this.profileManager;
    }

    public RoleManager getRoleManager() throws FeatureNotSupportedException {
        if (!this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isNamedRelationshipsSupported()) {
            throw new FeatureNotSupportedException("Role management not supported by underlaying configured identity stores");
        }
        return this.roleManager;
    }
}

